/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.model.prediction;

import java.util.Set;
import java.util.UUID;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.model.prediction.PredictionModelLastItemPointDto;
import org.thingsboard.trendz.dao.model.prediction.PredictionModelLastItemPointId;

@Repository
public interface PredictionModelLastItemPointRepository
extends CrudRepository<PredictionModelLastItemPointDto, PredictionModelLastItemPointId> {
    @Query(value="select pm.id\nfrom PredictionModelDto pm\nwhere pm.tenantId = :tenantId and\n(coalesce(:customerId, null) is null or pm.customerId = :customerId)\n")
    public Set<UUID> findAllPredictionModelIdsByTenantIdAndCustomerId(@Param(value="tenantId") UUID var1, @Param(value="customerId") UUID var2);

    @Query(value="select pmlipd\nfrom PredictionModelLastItemPointDto pmlipd\nwhere pmlipd.predictionModelId in (\n    select pm.id\n    from PredictionModelDto pm\n    where pm.tenantId = :tenantId and\n    (coalesce(:customerId, null) is null or pm.customerId = :customerId)\n)\n")
    public Set<PredictionModelLastItemPointDto> findAllByTenantIdAndCustomerId(@Param(value="tenantId") UUID var1, @Param(value="customerId") UUID var2);

    @Query(value="select pmlipd\nfrom PredictionModelLastItemPointDto pmlipd\nwhere pmlipd.predictionModelId = :modelId\n")
    public Set<PredictionModelLastItemPointDto> findAllByPredictionModelId(@Param(value="modelId") UUID var1);

    @Query(value="delete from PredictionModelLastItemPointDto pmlipd\nwhere pmlipd.predictionModelId = :modelId\n")
    @Modifying
    public void deleteAllByPredictionModelId(@Param(value="modelId") UUID var1);
}

