/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.model.anomaly.scoredpoint;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Table;
import java.util.UUID;
import lombok.Generated;
import org.springframework.data.domain.Persistable;
import org.thingsboard.trendz.dao.model.anomaly.scoredpoint.ScoredPointHistogramDto;
import org.thingsboard.trendz.dao.model.anomaly.scoredpoint.ScoredPointHistogramDtoId;
import org.thingsboard.trendz.domain.anomaly.ScoredPoint;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="scored_point_histogram")
@IdClass(value=ScoredPointHistogramDtoId.class)
public class ScoredPointHistogramDto
implements Comparable<ScoredPointHistogramDto>,
Persistable<ScoredPointHistogramDtoId> {
    @Id
    @Column(name="t")
    private long t;
    @Column(name="s")
    private Double s;
    @Id
    @Column(name="cluster_info_id")
    private UUID clusterInfoId;

    public ScoredPoint toData() {
        return new ScoredPoint(this.t, this.s);
    }

    public static ScoredPointHistogramDto from(ScoredPoint entity, UUID clusterInfoId) {
        return ScoredPointHistogramDto.builder().t(entity.getT()).s(entity.getS()).clusterInfoId(clusterInfoId).build();
    }

    @Override
    public int compareTo(ScoredPointHistogramDto that) {
        return Long.compare(this.t, that.t);
    }

    public ScoredPointHistogramDtoId getId() {
        return new ScoredPointHistogramDtoId(this.t, this.clusterInfoId);
    }

    public boolean isNew() {
        return true;
    }

    @Generated
    public static ScoredPointHistogramDtoBuilder builder() {
        return new ScoredPointHistogramDtoBuilder();
    }

    @Generated
    public long getT() {
        return this.t;
    }

    @Generated
    public Double getS() {
        return this.s;
    }

    @Generated
    public UUID getClusterInfoId() {
        return this.clusterInfoId;
    }

    @Generated
    public void setT(long t) {
        this.t = t;
    }

    @Generated
    public void setS(Double s) {
        this.s = s;
    }

    @Generated
    public void setClusterInfoId(UUID clusterInfoId) {
        this.clusterInfoId = clusterInfoId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScoredPointHistogramDto)) {
            return false;
        }
        ScoredPointHistogramDto other = (ScoredPointHistogramDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getT() != other.getT()) {
            return false;
        }
        Double this$s = this.getS();
        Double other$s = other.getS();
        if (this$s == null ? other$s != null : !((Object)this$s).equals(other$s)) {
            return false;
        }
        UUID this$clusterInfoId = this.getClusterInfoId();
        UUID other$clusterInfoId = other.getClusterInfoId();
        return !(this$clusterInfoId == null ? other$clusterInfoId != null : !((Object)this$clusterInfoId).equals(other$clusterInfoId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ScoredPointHistogramDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $t = this.getT();
        result = result * 59 + (int)($t >>> 32 ^ $t);
        Double $s = this.getS();
        result = result * 59 + ($s == null ? 43 : ((Object)$s).hashCode());
        UUID $clusterInfoId = this.getClusterInfoId();
        result = result * 59 + ($clusterInfoId == null ? 43 : ((Object)$clusterInfoId).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ScoredPointHistogramDto(t=" + this.getT() + ", s=" + this.getS() + ", clusterInfoId=" + String.valueOf(this.getClusterInfoId()) + ")";
    }

    @Generated
    public ScoredPointHistogramDto() {
    }

    @Generated
    public ScoredPointHistogramDto(long t, Double s, UUID clusterInfoId) {
        this.t = t;
        this.s = s;
        this.clusterInfoId = clusterInfoId;
    }
}

