/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.model.anomaly;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.dao.model.anomaly.DatasetConfigDto;
import org.thingsboard.trendz.dao.view.ViewFieldDto;
import org.thingsboard.trendz.domain.anomaly.DatasetConfig;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.tools.json.JsonUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="dataset_config")
public class DatasetConfigDto {
    @Id
    private UUID id;
    @Column(name="max_points_count")
    private int maxPointsCount;
    @Column(name="start_ts")
    private long startTs;
    @Column(name="end_ts")
    private long endTs;
    @Column(name="tz_name")
    private String tzName;
    @Column(name="business_entity_id")
    private UUID businessEntityId;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SUBSELECT)
    @JoinColumn(name="dataset_config_id")
    private List<ViewFieldDto> fields;
    @Column(name="item_set")
    private String itemSet;

    public DatasetConfig toData() {
        CollectionType type = JsonUtils.getObjectMapper().getTypeFactory().constructCollectionType(Set.class, ItemLite.class);
        List fields = this.fields == null ? Collections.emptyList() : this.fields.stream().filter(field -> !field.isHidden()).map(ViewFieldDto::toData).collect(Collectors.toList());
        Set itemSet = this.itemSet == null ? null : (Set)JsonUtils.fromJson((String)this.itemSet, (JavaType)type);
        return DatasetConfig.builder().id(this.id).fields(fields).maxPointsCount(this.maxPointsCount).startTs(this.startTs).endTs(this.endTs).tzName(this.tzName).businessEntityId(this.businessEntityId).itemSet(itemSet).build();
    }

    public static DatasetConfigDto from(DatasetConfig entity) {
        if (entity.getId() == null) {
            entity.setId(TimeStampUUIDGenerator.generateId());
        }
        List viewFieldDtos = entity.getFields().stream().map(field -> ViewFieldDto.from(null, (ViewField)field, null)).peek(viewFieldDto -> viewFieldDto.setDatasetConfigId(entity.getId())).collect(Collectors.toList());
        return DatasetConfigDto.builder().id(entity.getId()).maxPointsCount(entity.getMaxPointsCount()).startTs(entity.getStartTs()).endTs(entity.getEndTs()).tzName(entity.getTzName()).businessEntityId(entity.getBusinessEntityId()).fields(viewFieldDtos).itemSet(entity.getItemSet() == null || entity.getItemSet().isEmpty() ? null : JsonUtils.toJson((Object)entity.getItemSet())).build();
    }

    @Generated
    public static DatasetConfigDtoBuilder builder() {
        return new DatasetConfigDtoBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public int getMaxPointsCount() {
        return this.maxPointsCount;
    }

    @Generated
    public long getStartTs() {
        return this.startTs;
    }

    @Generated
    public long getEndTs() {
        return this.endTs;
    }

    @Generated
    public String getTzName() {
        return this.tzName;
    }

    @Generated
    public UUID getBusinessEntityId() {
        return this.businessEntityId;
    }

    @Generated
    public List<ViewFieldDto> getFields() {
        return this.fields;
    }

    @Generated
    public String getItemSet() {
        return this.itemSet;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setMaxPointsCount(int maxPointsCount) {
        this.maxPointsCount = maxPointsCount;
    }

    @Generated
    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    @Generated
    public void setEndTs(long endTs) {
        this.endTs = endTs;
    }

    @Generated
    public void setTzName(String tzName) {
        this.tzName = tzName;
    }

    @Generated
    public void setBusinessEntityId(UUID businessEntityId) {
        this.businessEntityId = businessEntityId;
    }

    @Generated
    public void setFields(List<ViewFieldDto> fields) {
        this.fields = fields;
    }

    @Generated
    public void setItemSet(String itemSet) {
        this.itemSet = itemSet;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatasetConfigDto)) {
            return false;
        }
        DatasetConfigDto other = (DatasetConfigDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getMaxPointsCount() != other.getMaxPointsCount()) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.getEndTs() != other.getEndTs()) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$tzName = this.getTzName();
        String other$tzName = other.getTzName();
        if (this$tzName == null ? other$tzName != null : !this$tzName.equals(other$tzName)) {
            return false;
        }
        UUID this$businessEntityId = this.getBusinessEntityId();
        UUID other$businessEntityId = other.getBusinessEntityId();
        if (this$businessEntityId == null ? other$businessEntityId != null : !((Object)this$businessEntityId).equals(other$businessEntityId)) {
            return false;
        }
        List this$fields = this.getFields();
        List other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        String this$itemSet = this.getItemSet();
        String other$itemSet = other.getItemSet();
        return !(this$itemSet == null ? other$itemSet != null : !this$itemSet.equals(other$itemSet));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DatasetConfigDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxPointsCount();
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        long $endTs = this.getEndTs();
        result = result * 59 + (int)($endTs >>> 32 ^ $endTs);
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $tzName = this.getTzName();
        result = result * 59 + ($tzName == null ? 43 : $tzName.hashCode());
        UUID $businessEntityId = this.getBusinessEntityId();
        result = result * 59 + ($businessEntityId == null ? 43 : ((Object)$businessEntityId).hashCode());
        List $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        String $itemSet = this.getItemSet();
        result = result * 59 + ($itemSet == null ? 43 : $itemSet.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DatasetConfigDto(id=" + String.valueOf(this.getId()) + ", maxPointsCount=" + this.getMaxPointsCount() + ", startTs=" + this.getStartTs() + ", endTs=" + this.getEndTs() + ", tzName=" + this.getTzName() + ", businessEntityId=" + String.valueOf(this.getBusinessEntityId()) + ", fields=" + String.valueOf(this.getFields()) + ", itemSet=" + this.getItemSet() + ")";
    }

    @Generated
    public DatasetConfigDto() {
    }

    @Generated
    public DatasetConfigDto(UUID id, int maxPointsCount, long startTs, long endTs, String tzName, UUID businessEntityId, List<ViewFieldDto> fields, String itemSet) {
        this.id = id;
        this.maxPointsCount = maxPointsCount;
        this.startTs = startTs;
        this.endTs = endTs;
        this.tzName = tzName;
        this.businessEntityId = businessEntityId;
        this.fields = fields;
        this.itemSet = itemSet;
    }
}

