/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.model.anomaly;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.model.anomaly.ClusterModelDto;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelLite;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelStatus;
import org.thingsboard.trendz.domain.summary.TrendzEntityUsage;

@Repository
public interface AnomalyModelRepository
extends CrudRepository<ClusterModelDto, UUID> {
    @Query(value="SELECT new org.thingsboard.trendz.domain.anomaly.AnomalyModelLite(\n   cm.id,\n   cm.name,\n   COALESCE(td.enabledRefresh, false),\n   COALESCE(td.enabledSaveToTb, false),\n   COALESCE(td.enabledAlarmCreation, false),\n   cm.createTs,\n   cm.updateTs,\n   cm.type,\n   cm.status,\n   dc.businessEntityId,\n   cm.tbTelemetryKey\n)\nFROM ClusterModelDto cm\n    INNER JOIN cm.datasetConfig dc\n    LEFT JOIN cm.taskData td\nWHERE cm.tenantId = :tenantId AND\n    (coalesce(:customerId, null) IS NULL OR cm.customerId = :customerId) AND\n    (coalesce(:name, null) IS NULL OR LOWER(cm.name) LIKE %:name%) AND\n    (coalesce(:anomalyModelStatus, null) IS NULL OR cm.status = :anomalyModelStatus)\n")
    public Page<AnomalyModelLite> findAllLiteByTenantIdAndCustomerId(@Param(value="tenantId") UUID var1, @Param(value="customerId") UUID var2, @Param(value="name") String var3, @Param(value="anomalyModelStatus") AnomalyModelStatus var4, PageRequest var5);

    @Query(value=" select cm\n from ClusterModelDto cm\n where cm.tenantId = :tenantId and\n (coalesce(:customerId, null) is null or cm.customerId = :customerId)\n")
    public List<ClusterModelDto> findAllByTenantIdAndCustomerId(@Param(value="tenantId") UUID var1, @Param(value="customerId") UUID var2);

    @Query(value="select cm\nfrom ClusterModelDto cm\nwhere cm.id = :id and cm.tenantId = :tenantId and\n(:insecure = TRUE OR coalesce(:customerId, null) is null or cm.customerId = :customerId)\n")
    public Optional<ClusterModelDto> findByIdAndTenantIdAndCustomerId(@Param(value="id") UUID var1, @Param(value="tenantId") UUID var2, @Param(value="customerId") UUID var3, @Param(value="insecure") boolean var4);

    @Query(value="SELECT new org.thingsboard.trendz.domain.anomaly.AnomalyModelLite(\n   cm.id,\n   cm.name,\n   COALESCE(td.enabledRefresh, false),\n   COALESCE(td.enabledSaveToTb, false),\n   COALESCE(td.enabledAlarmCreation, false),\n   cm.createTs,\n   cm.updateTs,\n   cm.type,\n   cm.status,\n   dc.businessEntityId,\n   cm.tbTelemetryKey\n) FROM ClusterModelDto cm\n    INNER JOIN cm.datasetConfig dc\n    LEFT JOIN cm.taskData td\nWHERE\n    (cm.anomalyScoreAssociatedFieldId = :entityFieldId OR cm.anomalyScoreIndexAssociatedFieldId = :entityFieldId)\n        AND cm.tenantId = :tenantId\n        AND (:insecure = TRUE OR coalesce(:customerId, null) is null OR cm.customerId = :customerId)\n")
    public Optional<AnomalyModelLite> findByAssociatedEntityFieldIdAndTenantIdAndCustomerId(@Param(value="entityFieldId") UUID var1, @Param(value="tenantId") UUID var2, @Param(value="customerId") UUID var3, @Param(value="insecure") boolean var4);

    @Query(value="SELECT COUNT(cm)\nFROM ClusterModelDto cm\nWHERE cm.name = :name and cm.tenantId = :tenantId\n")
    public int countAllByTenantIdAndName(@Param(value="name") String var1, @Param(value="tenantId") UUID var2);

    @Query(nativeQuery=true, value="WITH associated_entity_fields AS (\n    SELECT bef.id, bef.business_entity_id\n    FROM business_entity_field bef\n    WHERE bef.id IN (\n        SELECT unnest(array[\n            cm.score_associated_field_id,\n            cm.score_index_associated_field_id\n        ])\n        FROM cluster_model cm\n        WHERE cm.id = :id\n            AND cm.tenant_id = :tenantId\n            AND (:customerId = :nullId OR cm.customer_id = :customerId)\n    )\n)\n    SELECT 'BUSINESS_ENTITY' AS TYPE, be.name AS name\n    FROM business_entity be\n    WHERE be.id IN (\n        SELECT business_entity_id\n        FROM associated_entity_fields\n    )\nUNION\n    SELECT 'VIEW_CONFIG' AS TYPE, vc.name AS name\n    FROM view_config vc\n    WHERE vc.tenant_id = :tenantId\n        AND vc.customer_id IN :customerIdSet\n        AND vc.id IN (\n\t\t    SELECT vf.view_config_id\n\t\t    FROM view_field vf\n\t\t    WHERE vf.entity_field_id IN (\n                SELECT id\n                FROM associated_entity_fields\n            )\n        )\nUNION\n    SELECT 'PREDICTION_MODEL' AS TYPE, pm.name AS name\n    FROM prediction_model pm\n    WHERE pm.tenant_id = :tenantId\n        AND (:customerId = :nullId OR pm.customer_id = :customerId)\n        AND CAST(CAST(pm.datasource_parameters AS JSONB) ->> 'businessEntityFieldId' AS UUID) IN (\n            SELECT id\n            FROM associated_entity_fields\n        )\n")
    public List<Object[]> findDependedEntities(@Param(value="id") UUID var1, @Param(value="tenantId") UUID var2, @Param(value="customerId") UUID var3, @Param(value="customerIdSet") Set<UUID> var4, @Param(value="nullId") UUID var5);

    @Query(value="SELECT new org.thingsboard.trendz.domain.summary.TrendzEntityUsage(\n    SUM(CASE WHEN td.enabledRefresh = true THEN 1 ELSE 0 END),\n    COUNT(m)\n)\nFROM ClusterModelDto m\nLEFT JOIN m.taskData td\nWHERE :tenantId = :nullId OR m.tenantId = :tenantId\n")
    public Optional<TrendzEntityUsage> findUsage(UUID var1, UUID var2);
}

