/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.model.anomaly;

import com.google.common.collect.Lists;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.dao.model.anomaly.AnomalyModelRepository;
import org.thingsboard.trendz.dao.model.anomaly.ClusterExampleRepository;
import org.thingsboard.trendz.dao.model.anomaly.ClusterModelDto;
import org.thingsboard.trendz.dao.model.anomaly.LiteClusterModelDto;
import org.thingsboard.trendz.dao.model.anomaly.LiteClusterModelRepository;
import org.thingsboard.trendz.dao.model.anomaly.scoredpoint.ScoredPointCentroidDto;
import org.thingsboard.trendz.dao.model.anomaly.scoredpoint.ScoredPointCentroidRepository;
import org.thingsboard.trendz.dao.model.anomaly.scoredpoint.ScoredPointClusterDto;
import org.thingsboard.trendz.dao.model.anomaly.scoredpoint.ScoredPointClusterRepository;
import org.thingsboard.trendz.dao.model.anomaly.scoredpoint.ScoredPointHistogramDto;
import org.thingsboard.trendz.dao.model.anomaly.scoredpoint.ScoredPointHistogramRepository;
import org.thingsboard.trendz.domain.anomaly.AnomalyModel;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelLite;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelSortingField;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelStatus;
import org.thingsboard.trendz.domain.anomaly.ClusterInfo;
import org.thingsboard.trendz.domain.anomaly.ModelFilteringField;
import org.thingsboard.trendz.domain.anomaly.ScoredPoint;
import org.thingsboard.trendz.domain.summary.TrendzEntityUsage;
import org.thingsboard.trendz.exception.model.anomaly.AnomalyModelNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationInfo;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationItem;
import org.thingsboard.trendz.tools.UUIDUtils;

@Service
@Transactional
public class AnomalyModelDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnomalyModelDao.class);
    private final AnomalyModelRepository anomalyModelRepository;
    private final ClusterExampleRepository clusterExampleRepository;
    private final ScoredPointCentroidRepository scoredPointCentroidRepository;
    private final ScoredPointClusterRepository scoredPointClusterRepository;
    private final ScoredPointHistogramRepository scoredPointHistogramRepository;
    private final LiteClusterModelRepository liteClusterModelRepository;

    @Autowired
    public AnomalyModelDao(AnomalyModelRepository anomalyModelRepository, ClusterExampleRepository clusterExampleRepository, ScoredPointCentroidRepository scoredPointCentroidRepository, ScoredPointClusterRepository scoredPointClusterRepository, ScoredPointHistogramRepository scoredPointHistogramRepository, LiteClusterModelRepository liteClusterModelRepository) {
        this.anomalyModelRepository = anomalyModelRepository;
        this.clusterExampleRepository = clusterExampleRepository;
        this.scoredPointCentroidRepository = scoredPointCentroidRepository;
        this.scoredPointClusterRepository = scoredPointClusterRepository;
        this.scoredPointHistogramRepository = scoredPointHistogramRepository;
        this.liteClusterModelRepository = liteClusterModelRepository;
    }

    public Page<AnomalyModelLite> getAllLite(int page, int pageSize, JwtSecurityUser user, List<ModelFilteringField> filteringFields, List<AnomalyModelSortingField> sortingFields) {
        long startTime = System.currentTimeMillis();
        UUID tenantId = user.getTenantId();
        UUID customerId = UUIDUtils.mapNullUuidToNull((UUID)user.getCustomerId());
        Map<ModelFilteringField.Type, String> filterMap = filteringFields.stream().collect(Collectors.toMap(ModelFilteringField::getType, ModelFilteringField::getValue));
        String name = Optional.ofNullable(filterMap.get(ModelFilteringField.Type.NAME)).map(String::toLowerCase).orElse("");
        AnomalyModelStatus anomalyModelStatus = Optional.ofNullable(filterMap.get(ModelFilteringField.Type.STATUS)).map(AnomalyModelStatus::valueOf).orElse(null);
        List orders = sortingFields.stream().map(sortingField -> new Sort.Order(sortingField.getDirection(), sortingField.getType().getValue())).collect(Collectors.toList());
        Page models = this.anomalyModelRepository.findAllLiteByTenantIdAndCustomerId(tenantId, customerId, name, anomalyModelStatus, PageRequest.of((int)page, (int)pageSize, (Sort)Sort.by(orders)));
        long endTime = System.currentTimeMillis();
        log.debug("Models' page has been loaded, count = {}, time = {}", (Object)models.getSize(), (Object)(endTime - startTime));
        return models;
    }

    public List<AnomalyModel> getAll(JwtSecurityUser user) {
        long startTime = System.currentTimeMillis();
        UUID tenantId = user.getTenantId();
        UUID customerId = UUIDUtils.mapNullUuidToNull((UUID)user.getCustomerId());
        List<AnomalyModel> anomalyModels = this.anomalyModelRepository.findAllByTenantIdAndCustomerId(tenantId, customerId).stream().map(ClusterModelDto::toData).peek(arg_0 -> this.loadScoredPointsForModel(arg_0)).peek(anomalyModel -> anomalyModel.setUser(user)).collect(Collectors.toList());
        long endTime = System.currentTimeMillis();
        log.debug("All models have been loaded, count = {}, time = {}", (Object)anomalyModels.size(), (Object)(endTime - startTime));
        return anomalyModels;
    }

    public AnomalyModel findByIdOrThrow(JwtSecurityUser user, UUID modelId, boolean insecure) {
        return (AnomalyModel)this.findById(user, modelId, insecure).orElseThrow(() -> new AnomalyModelNotFoundException(modelId));
    }

    public void delete(JwtSecurityUser user, UUID id) {
        Set clusterInfoIds;
        long startTime = System.currentTimeMillis();
        AnomalyModel model = this.findByIdOrThrow(user, id, false);
        if (model.getClusters() != null && !(clusterInfoIds = model.getClusters().stream().map(ClusterInfo::getId).collect(Collectors.toSet())).isEmpty()) {
            this.scoredPointCentroidRepository.deleteByClusterInfoIds(clusterInfoIds);
            this.scoredPointHistogramRepository.deleteByClusterInfoIds(clusterInfoIds);
            Set clusterExampleIds = this.clusterExampleRepository.getIdsByClusterInfoIds(clusterInfoIds);
            if (!clusterExampleIds.isEmpty()) {
                this.scoredPointClusterRepository.deleteByClusterExampleIds(clusterExampleIds);
            }
        }
        this.anomalyModelRepository.deleteById((Object)model.getId());
        long endTime = System.currentTimeMillis();
        log.debug("Model has been deleted, id = {}, time = {}", (Object)id, (Object)(endTime - startTime));
    }

    public AnomalyModel save(AnomalyModel anomalyModel) {
        log.debug("Trying to save model");
        long startTime = System.currentTimeMillis();
        ArrayList centroidDtos = new ArrayList();
        ArrayList histogramDtos = new ArrayList();
        ArrayList clusterExamplePointsDtos = new ArrayList();
        if (anomalyModel.getClusters() != null) {
            anomalyModel.getClusters().stream().peek(clusterInfo -> clusterInfo.setId(TimeStampUUIDGenerator.generateId())).forEach(clusterInfo -> {
                centroidDtos.addAll(this.getCentroidDtos(clusterInfo.getCentroid(), clusterInfo.getId()));
                histogramDtos.addAll(this.getHistogramDtos(clusterInfo.getHistogram(), clusterInfo.getId()));
                clusterInfo.getClusterExamples().keySet().forEach(clusterExampleId -> clusterExamplePointsDtos.addAll(this.getClusterExamplePointsDtos((List)clusterInfo.getClusterExamples().get(clusterExampleId), clusterExampleId)));
            });
        }
        AnomalyModel savedModel = ((ClusterModelDto)this.anomalyModelRepository.save((Object)ClusterModelDto.from((AnomalyModel)anomalyModel))).toData();
        ArrayList savedCentroids = Lists.newArrayList((Iterable)this.scoredPointCentroidRepository.saveAll(centroidDtos));
        ArrayList savedHistogram = Lists.newArrayList((Iterable)this.scoredPointHistogramRepository.saveAll(histogramDtos));
        ArrayList savedClusterExamplePoints = Lists.newArrayList((Iterable)this.scoredPointClusterRepository.saveAll(clusterExamplePointsDtos));
        if (savedModel.getClusters() != null) {
            savedModel.getClusters().stream().peek(clusterInfo -> clusterInfo.setCentroid(this.getCentroidPointPojos(savedCentroids, clusterInfo.getId()))).peek(clusterInfo -> clusterInfo.setHistogram(this.getHistogramPointPojos(savedHistogram, clusterInfo.getId()))).map(ClusterInfo::getClusterExamples).forEach(clusterExampleMap -> clusterExampleMap.keySet().forEach(clusterExampleId -> clusterExampleMap.put(clusterExampleId, this.getClusterExamplePointPojos(savedClusterExamplePoints, clusterExampleId))));
        }
        long endTime = System.currentTimeMillis();
        log.debug("Model {} saved in {} ms", (Object)savedModel.getId(), (Object)(endTime - startTime));
        return savedModel;
    }

    public void saveOnlyAnomalyModelParameters(AnomalyModel anomalyModel) {
        this.liteClusterModelRepository.save((Object)LiteClusterModelDto.from((AnomalyModel)anomalyModel));
    }

    public ChangeEntityValidationInfo findDependedEntities(JwtSecurityUser user, UUID modelId, Set<UUID> subCustomers) {
        UUID tenantId = user.getTenantId();
        UUID customerId = user.getCustomerId();
        Set dependencyItemSet = this.anomalyModelRepository.findDependedEntities(modelId, tenantId, customerId, subCustomers, EntityId.NULL_UUID).stream().map(array -> new ChangeEntityValidationItem((String)array[0], (String)array[1])).collect(Collectors.toSet());
        return new ChangeEntityValidationInfo(dependencyItemSet);
    }

    private Optional<AnomalyModel> findById(JwtSecurityUser user, UUID id, boolean insecure) {
        long startTime = System.currentTimeMillis();
        UUID tenantId = user.getTenantId();
        UUID customerId = UUIDUtils.mapNullUuidToNull((UUID)user.getCustomerId());
        Optional clusterModelDto = this.anomalyModelRepository.findByIdAndTenantIdAndCustomerId(id, tenantId, customerId, insecure);
        return clusterModelDto.map(ClusterModelDto::toData).map(model -> {
            long endTime = System.currentTimeMillis();
            log.debug("Model has been found, id = {}, time = {}", (Object)id, (Object)(endTime - startTime));
            this.loadScoredPointsForModel(model);
            model.setUser(user);
            return model;
        });
    }

    private void loadScoredPointsForModel(AnomalyModel model) {
        Set clusterInfoIds = model.getClusters().stream().map(ClusterInfo::getId).collect(Collectors.toSet());
        Set clusterExampleIds = model.getClusters().stream().map(ClusterInfo::getClusterExamples).map(Map::keySet).flatMap(Collection::stream).collect(Collectors.toSet());
        List loadedCentroids = this.loadCentroidByClusterInfoId(clusterInfoIds);
        List loadedHistograms = this.loadHistogramByClusterInfoId(clusterInfoIds);
        List loadedClusterExamplePoints = this.loadScoredPointsByClusterExampleId(clusterExampleIds);
        model.getClusters().forEach(clusterInfo -> {
            clusterInfo.setCentroid(loadedCentroids.stream().filter(centroid -> centroid.getClusterInfoId().equals(clusterInfo.getId())).map(ScoredPointCentroidDto::toData).sorted().collect(Collectors.toList()));
            clusterInfo.setHistogram(loadedHistograms.stream().filter(histogram -> histogram.getClusterInfoId().equals(clusterInfo.getId())).map(ScoredPointHistogramDto::toData).sorted().collect(Collectors.toList()));
            clusterInfo.getClusterExamples().keySet().forEach(clusterExampleId -> clusterInfo.getClusterExamples().put(clusterExampleId, loadedClusterExamplePoints.stream().filter(examplePoint -> examplePoint.getClusterExampleId().equals(clusterExampleId)).map(ScoredPointClusterDto::toData).sorted().collect(Collectors.toList())));
        });
    }

    private List<ScoredPointCentroidDto> loadCentroidByClusterInfoId(Set<UUID> clusterInfoIds) {
        if (clusterInfoIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.scoredPointCentroidRepository.findByClusterInfoIds(clusterInfoIds);
    }

    private List<ScoredPointHistogramDto> loadHistogramByClusterInfoId(Set<UUID> clusterInfoIds) {
        if (clusterInfoIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.scoredPointHistogramRepository.findByClusterInfoIds(clusterInfoIds);
    }

    private List<ScoredPointClusterDto> loadScoredPointsByClusterExampleId(Set<UUID> clusterExampleIds) {
        if (clusterExampleIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.scoredPointClusterRepository.findByClusterExampleIds(clusterExampleIds);
    }

    private List<ScoredPointCentroidDto> getCentroidDtos(List<ScoredPoint> centroids, UUID clusterInfoId) {
        return centroids.stream().map(scoredPoint -> ScoredPointCentroidDto.from((ScoredPoint)scoredPoint, (UUID)clusterInfoId)).collect(Collectors.toList());
    }

    private List<ScoredPointHistogramDto> getHistogramDtos(List<ScoredPoint> histograms, UUID clusterInfoId) {
        return histograms.stream().map(scoredPoint -> ScoredPointHistogramDto.from((ScoredPoint)scoredPoint, (UUID)clusterInfoId)).collect(Collectors.toList());
    }

    private List<ScoredPointClusterDto> getClusterExamplePointsDtos(List<ScoredPoint> clusterExamplePoints, UUID clusterExampleId) {
        return clusterExamplePoints.stream().map(scoredPoint -> ScoredPointClusterDto.from((ScoredPoint)scoredPoint, (UUID)clusterExampleId)).collect(Collectors.toList());
    }

    private List<ScoredPoint> getCentroidPointPojos(List<ScoredPointCentroidDto> allCentroidPointDtos, UUID clusterInfoId) {
        return allCentroidPointDtos.stream().filter(centroid -> centroid.getClusterInfoId().equals(clusterInfoId)).map(ScoredPointCentroidDto::toData).sorted().collect(Collectors.toList());
    }

    private List<ScoredPoint> getHistogramPointPojos(List<ScoredPointHistogramDto> allHistogramPointDtos, UUID clusterInfoId) {
        return allHistogramPointDtos.stream().filter(histogram -> histogram.getClusterInfoId().equals(clusterInfoId)).map(ScoredPointHistogramDto::toData).sorted().collect(Collectors.toList());
    }

    private List<ScoredPoint> getClusterExamplePointPojos(List<ScoredPointClusterDto> allClusterExamplePointDtos, UUID clusterExampleId) {
        return allClusterExamplePointDtos.stream().filter(clusterExamplePoint -> clusterExamplePoint.getClusterExampleId().equals(clusterExampleId)).map(ScoredPointClusterDto::toData).sorted().collect(Collectors.toList());
    }

    public Optional<AnomalyModelLite> findByEntityFieldId(UUID entityFieldId, JwtSecurityUser user, boolean insecure) {
        UUID tenantId = user.getTenantId();
        UUID customerId = UUIDUtils.mapNullUuidToNull((UUID)user.getCustomerId());
        return this.anomalyModelRepository.findByAssociatedEntityFieldIdAndTenantIdAndCustomerId(entityFieldId, tenantId, customerId, insecure);
    }

    public int countAllByTenantIdAndName(String newName, UUID tenantId) {
        return this.anomalyModelRepository.countAllByTenantIdAndName(newName, tenantId);
    }

    public TrendzEntityUsage findUsage(UUID tenantId) {
        return this.anomalyModelRepository.findUsage(tenantId, EntityId.NULL_UUID).orElseGet(() -> new TrendzEntityUsage(false, 0L, 0L));
    }
}

