/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.model.anomaly;

import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.dao.model.anomaly.AnomalyDto;
import org.thingsboard.trendz.dao.model.anomaly.AnomalyRepository;
import org.thingsboard.trendz.dao.model.anomaly.scoredpoint.ScoredPointAnomalyDto;
import org.thingsboard.trendz.dao.model.anomaly.scoredpoint.ScoredPointAnomalyRepository;
import org.thingsboard.trendz.domain.anomaly.Anomaly;
import org.thingsboard.trendz.domain.anomaly.AnomalyPersistenceReport;
import org.thingsboard.trendz.domain.anomaly.ScoredPoint;
import org.thingsboard.trendz.service.model.anomaly.components.AnomalyFilter;

@Service
@Transactional
public class AnomalyDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnomalyDao.class);
    private final AnomalyRepository anomalyRepository;
    private final ScoredPointAnomalyRepository scoredPointAnomalyRepository;

    @Autowired
    public AnomalyDao(AnomalyRepository anomalyRepository, ScoredPointAnomalyRepository scoredPointAnomalyRepository) {
        this.anomalyRepository = anomalyRepository;
        this.scoredPointAnomalyRepository = scoredPointAnomalyRepository;
    }

    public List<Anomaly> findByFilter(AnomalyFilter filter) {
        long startTime = System.currentTimeMillis();
        if (filter.getItemIds() != null && filter.getItemIds().isEmpty()) {
            log.debug("Anomaly item set is empty, skip search");
            return new ArrayList<Anomaly>();
        }
        if (filter.getModelIds() != null && filter.getModelIds().isEmpty()) {
            log.debug("Anomaly model set is empty, skip search");
            return new ArrayList<Anomaly>();
        }
        List<Anomaly> anomalies = this.anomalyRepository.find(filter.getItemIds(), filter.getModelIds(), filter.getStartTs(), filter.getEndTs(), filter.getMinScore()).stream().map(AnomalyDto::toData).collect(Collectors.toList());
        this.loadAnomalyPoints(anomalies);
        long endTime = System.currentTimeMillis();
        log.debug("{} Anomalies has been found in {} ms", (Object)anomalies.size(), (Object)(endTime - startTime));
        return anomalies;
    }

    public AnomalyPersistenceReport saveForReprocess(UUID modelId, Set<UUID> itemSet, List<Anomaly> anomaliesToSave, long saveFrom, long saveTo, long minAnomalyDuration) {
        AnomalyFilter anomalyFilter = new AnomalyFilter();
        anomalyFilter.setModelIds(Set.of(modelId));
        anomalyFilter.setStartTs(Long.valueOf(saveFrom));
        anomalyFilter.setEndTs(Long.valueOf(saveTo));
        anomalyFilter.setItemIds(itemSet == null || itemSet.isEmpty() ? null : itemSet);
        List truncated = this.truncate(anomaliesToSave, saveFrom, saveTo, minAnomalyDuration);
        List deleted = this.deleteByAnomalyFilter(anomalyFilter);
        List saved = this.saveAll(truncated);
        return new AnomalyPersistenceReport(saved, deleted);
    }

    private List<Anomaly> truncate(List<Anomaly> anomalies, long startTs, long endTs, long minAnomalyDuration) {
        ArrayList<Anomaly> truncated = new ArrayList<Anomaly>(anomalies.size());
        anomalies.forEach(anomaly -> {
            if (startTs <= anomaly.getStartTs() && anomaly.getEndTs() <= endTs) {
                truncated.add((Anomaly)anomaly);
            } else {
                List<ScoredPoint> scoredPoints;
                if (anomaly.getStartTs() < startTs && startTs < anomaly.getEndTs()) {
                    scoredPoints = anomaly.getData().stream().filter(scoredPoint -> scoredPoint.getT() >= startTs).toList();
                    if (scoredPoints.size() < 2) {
                        return;
                    }
                    anomaly.populateFromScoredPoints(scoredPoints);
                }
                if (anomaly.getStartTs() < endTs && endTs < anomaly.getEndTs()) {
                    scoredPoints = anomaly.getData().stream().filter(scoredPoint -> scoredPoint.getT() <= endTs).toList();
                    if (scoredPoints.size() < 2) {
                        return;
                    }
                    anomaly.populateFromScoredPoints(scoredPoints);
                }
                if (anomaly.getEndTs() - anomaly.getStartTs() >= minAnomalyDuration) {
                    truncated.add((Anomaly)anomaly);
                }
            }
        });
        return truncated;
    }

    public AnomalyPersistenceReport rewriteAll(UUID modelId, List<Anomaly> anomaliesToSave) {
        AnomalyFilter anomalyFilter = new AnomalyFilter();
        anomalyFilter.setModelIds(Set.of(modelId));
        List deleted = this.deleteByAnomalyFilter(anomalyFilter);
        List saved = this.saveAll(anomaliesToSave);
        return new AnomalyPersistenceReport(saved, deleted);
    }

    private List<Anomaly> deleteByAnomalyFilter(AnomalyFilter anomalyFilter) {
        List oldAnomaliesFromInterval = this.findByFilter(anomalyFilter);
        Set anomalyIdsToDelete = oldAnomaliesFromInterval.stream().map(Anomaly::getId).collect(Collectors.toSet());
        this.scoredPointAnomalyRepository.deleteByAnomalyIds(anomalyIdsToDelete);
        this.anomalyRepository.deleteAllByIds(anomalyIdsToDelete);
        return oldAnomaliesFromInterval;
    }

    private List<Anomaly> saveAll(List<Anomaly> anomalies) {
        log.debug("Save {} anomalies", (Object)anomalies.size());
        if (anomalies.isEmpty()) {
            log.debug("Skip empty anomaly list");
            return Collections.emptyList();
        }
        long startTime = System.currentTimeMillis();
        for (Anomaly anomaly2 : anomalies) {
            if (anomaly2.getId() != null) continue;
            anomaly2.setId(TimeStampUUIDGenerator.generateId());
        }
        List dtoList = anomalies.stream().map(AnomalyDto::from).collect(Collectors.toList());
        List savedDtoList = StreamSupport.stream(this.anomalyRepository.saveAll(dtoList).spliterator(), false).toList();
        long afterAnomalySavingTime = System.currentTimeMillis();
        List pointsDtos = anomalies.stream().flatMap(anomaly -> anomaly.getData().stream().map(scoredPoint -> ScoredPointAnomalyDto.from((ScoredPoint)scoredPoint, (UUID)anomaly.getId()))).collect(Collectors.toList());
        Map savedPointsMap = StreamSupport.stream(this.scoredPointAnomalyRepository.saveAll(pointsDtos).spliterator(), false).collect(Collectors.groupingBy(ScoredPointAnomalyDto::getAnomalyId, Collectors.toList()));
        long afterAnomalyScorePointsSavingTime = System.currentTimeMillis();
        List<Anomaly> saved = savedDtoList.stream().map(anomalyDto -> {
            Anomaly anomaly = anomalyDto.toData();
            List data = ((List)savedPointsMap.get(anomalyDto.getId())).stream().map(ScoredPointAnomalyDto::toData).collect(Collectors.toList());
            anomaly.setData(data);
            return anomaly;
        }).toList();
        log.debug("Anomalies has been saved with anomalies: count = {}, time = {}, points = {}, time = {}", new Object[]{saved.size(), afterAnomalySavingTime - startTime, pointsDtos.size(), afterAnomalyScorePointsSavingTime - afterAnomalySavingTime});
        return saved;
    }

    private void loadAnomalyPoints(List<Anomaly> anomalies) {
        if (anomalies.isEmpty()) {
            return;
        }
        Map idToAnomalyMap = anomalies.stream().collect(Collectors.toMap(Anomaly::getId, Function.identity()));
        this.scoredPointAnomalyRepository.findByAnomalyIds(idToAnomalyMap.keySet()).stream().collect(Collectors.groupingBy(ScoredPointAnomalyDto::getAnomalyId)).forEach((anomalyId, value) -> {
            Anomaly anomaly = (Anomaly)idToAnomalyMap.get(anomalyId);
            List anomalyPoints = value.stream().map(ScoredPointAnomalyDto::toData).sorted().collect(Collectors.toList());
            anomaly.setData(anomalyPoints);
        });
    }

    public void populateAlarmId(Anomaly anomaly, UUID alarmId) {
        this.anomalyRepository.populateAlarmId(anomaly.getId(), alarmId);
    }

    public Optional<Integer> getMinAnomalyScoreFotModel(UUID modelId) {
        return this.anomalyRepository.getMinAnomalyScoreFotModel(modelId);
    }
}

