/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.metric;

import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.metric.MetricExplorationDto;

@Repository
public interface MetricExplorationRepository
extends JpaRepository<MetricExplorationDto, UUID> {
    @Modifying
    @Query(value="INSERT INTO metric_exploration\n    (id, tenant_id, customer_id, item_id, item_name, business_entity_id, business_entity_field_id, metric_definition_id, exploration_ts)\nVALUES (\n     :#{#dto.id},\n     :#{#dto.tenantId},\n     :#{#dto.customerId},\n     :#{#dto.itemId},\n     :#{#dto.itemName},\n     :#{#dto.businessEntityId},\n     :#{#dto.businessEntityFieldId},\n     :#{#dto.metricDefinitionId},\n     :#{#dto.explorationTs}\n)\nON CONFLICT (tenant_id, customer_id, item_id, business_entity_id, business_entity_field_id, metric_definition_id)\nDO UPDATE SET\n    item_name = EXCLUDED.item_name,\n    exploration_ts = EXCLUDED.exploration_ts\n", nativeQuery=true)
    public void upsert(@Param(value="dto") MetricExplorationDto var1);

    @Query(value="SELECT me\nFROM metric_exploration me\nWHERE me.tenantId = :tenantId\n    AND me.customerId = :customerId\n")
    public Page<MetricExplorationDto> findAllByTenantIdAndCustomerId(UUID var1, UUID var2, Pageable var3);
}

