/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.metric;

import jakarta.transaction.Transactional;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.metric.MetricExplorationDto;
import org.thingsboard.trendz.dao.metric.MetricExplorationRepository;
import org.thingsboard.trendz.domain.metric.exploration.MetricExploration;
import org.thingsboard.trendz.domain.metric.exploration.MetricExplorationFilteringField;
import org.thingsboard.trendz.domain.metric.exploration.MetricExplorationSortingField;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;

@Service
@Transactional
public class MetricExplorationDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricExplorationDao.class);
    private final MetricExplorationRepository metricExplorationRepository;

    @Autowired
    public MetricExplorationDao(MetricExplorationRepository metricExplorationRepository) {
        this.metricExplorationRepository = metricExplorationRepository;
    }

    public void upsert(MetricExploration metricExploration) {
        this.metricExplorationRepository.upsert(MetricExplorationDto.from((MetricExploration)metricExploration));
    }

    public Page<MetricExploration> getAllMetricExplorations(int page, int pageSize, JwtSecurityUser user, List<MetricExplorationFilteringField> filteringFields, List<MetricExplorationSortingField> sortingFields) {
        long startTime = System.currentTimeMillis();
        UUID tenantId = user.getTenantId();
        UUID customerId = user.getCustomerId();
        List orders = sortingFields.stream().map(sortingField -> new Sort.Order(sortingField.direction(), sortingField.type().getValue())).collect(Collectors.toList());
        Page metricExploration = this.metricExplorationRepository.findAllByTenantIdAndCustomerId(tenantId, customerId, (Pageable)PageRequest.of((int)page, (int)pageSize, (Sort)Sort.by(orders))).map(MetricExplorationDto::toData);
        long endTime = System.currentTimeMillis();
        log.debug("Metric exploration' page has been loaded, count = {}, time = {}", (Object)metricExploration.getSize(), (Object)(endTime - startTime));
        return metricExploration;
    }
}

