/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.metric;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.metric.MetricDefinitionMetadataDto;

@Repository
public interface MetricDefinitionMetadataRepository
extends JpaRepository<MetricDefinitionMetadataDto, UUID> {
    @Query(value="SELECT mdm\nFROM metric_definition_metadata mdm\nWHERE mdm.metricDefinitionId = :metricId\n")
    public Optional<MetricDefinitionMetadataDto> findByMetricId(UUID var1);

    @Query(value="SELECT mdm\nFROM metric_definition_metadata mdm\nWHERE mdm.tenantId = :tenantId\n    AND (coalesce(:customerId, null) is null or mdm.customerId = :customerId)\n")
    public List<MetricDefinitionMetadataDto> findAllByTenantIdAndCustomerId(UUID var1, UUID var2);

    @Query(value="SELECT mdm\nFROM metric_definition_metadata mdm\nWHERE mdm.tenantId = :tenantId\n    AND (:customerId IS NULL OR mdm.customerId = :customerId)\n    AND mdm.businessEntityId = :businessEntityId\n    AND mdm.itemId = :itemId\n    AND mdm.advancedMode = :advancedMode\nORDER BY mdm.createdTs DESC\nLIMIT :limit\n")
    public List<MetricDefinitionMetadataDto> findRecentMetadata(UUID var1, UUID var2, UUID var3, UUID var4, boolean var5, int var6);
}

