/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.customize;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Table;
import java.util.UUID;
import lombok.Generated;
import org.thingsboard.trendz.dao.customize.UserRecordDto;
import org.thingsboard.trendz.dao.customize.UserRecordDtoId;
import org.thingsboard.trendz.domain.customize.UserRecord;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.tools.json.JsonUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="user_record")
@IdClass(value=UserRecordDtoId.class)
public class UserRecordDto {
    @Id
    @Column(name="tenant_id")
    private UUID tenantId;
    @Id
    @Column(name="customer_id")
    private UUID customerId;
    @Id
    @Column(name="user_id")
    private UUID userId;
    @Column(name="username")
    private String username;
    @Column(name="visit_first_ts")
    private long visitFirstTs;
    @Column(name="visit_last_ts")
    private long visitLastTs;
    @Column(name="valid")
    private boolean valid;
    @Column(name="validation_last_ts")
    private long validationLastTs;
    @Column(name="json_data")
    private String jsonData;

    public UserRecord toData() {
        JsonNode jsonConfigsNode = JsonUtils.toNodeFromRaw((String)this.jsonData);
        JsonNode subscriptionUpdateTsNode = jsonConfigsNode.get("subscriptionUpdateTs");
        JsonNode subscriptionNode = jsonConfigsNode.get("subscription");
        JsonNode tenantInfoNode = jsonConfigsNode.get("tenantInfo");
        JsonNode customerInfoNode = jsonConfigsNode.get("customerInfo");
        Long subscriptionUpdateTs = subscriptionUpdateTsNode != null ? (Long)JsonUtils.fromNodeToObject((JsonNode)subscriptionUpdateTsNode, Long.class) : null;
        String subscription = subscriptionNode != null ? JsonUtils.fromNodeToRaw((JsonNode)subscriptionNode) : null;
        String tenantInfo = tenantInfoNode != null ? JsonUtils.fromNodeToRaw((JsonNode)tenantInfoNode) : null;
        String customerInfo = customerInfoNode != null ? JsonUtils.fromNodeToRaw((JsonNode)customerInfoNode) : null;
        return UserRecord.builder().user(JwtSecurityUser.builder().tenantId(this.tenantId).customerId(this.customerId).userId(this.userId).build()).username(this.username).visitFirstTs(this.visitFirstTs).visitLastTs(this.visitLastTs).valid(this.valid).validationLastTs(this.validationLastTs).subscriptionUpdateTs(subscriptionUpdateTs).subscription(subscription).tenantInfo(tenantInfo).customerInfo(customerInfo).build();
    }

    public static UserRecordDto from(UserRecord entity) {
        ObjectNode node = JsonUtils.getObjectMapper().createObjectNode();
        if (entity.getSubscriptionUpdateTs() != null) {
            node.set("subscriptionUpdateTs", JsonUtils.toNodeFromObject((Object)entity.getSubscriptionUpdateTs()));
        }
        if (entity.getSubscription() != null) {
            node.set("subscription", JsonUtils.toNodeFromRaw((String)entity.getSubscription()));
        }
        if (entity.getTenantInfo() != null) {
            node.set("tenantInfo", JsonUtils.toNodeFromRaw((String)entity.getTenantInfo()));
        }
        if (entity.getCustomerInfo() != null) {
            node.set("customerInfo", JsonUtils.toNodeFromRaw((String)entity.getCustomerInfo()));
        }
        String jsonData = JsonUtils.fromNodeToRaw((JsonNode)node);
        return UserRecordDto.builder().tenantId(entity.getUser().getTenantId()).customerId(entity.getUser().getCustomerId()).userId(entity.getUser().getUserId()).username(entity.getUsername()).visitFirstTs(entity.getVisitFirstTs()).visitLastTs(entity.getVisitLastTs()).valid(entity.isValid()).validationLastTs(entity.getValidationLastTs()).jsonData(jsonData).build();
    }

    @Generated
    public static UserRecordDtoBuilder builder() {
        return new UserRecordDtoBuilder();
    }

    @Generated
    public UUID getTenantId() {
        return this.tenantId;
    }

    @Generated
    public UUID getCustomerId() {
        return this.customerId;
    }

    @Generated
    public UUID getUserId() {
        return this.userId;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public long getVisitFirstTs() {
        return this.visitFirstTs;
    }

    @Generated
    public long getVisitLastTs() {
        return this.visitLastTs;
    }

    @Generated
    public boolean isValid() {
        return this.valid;
    }

    @Generated
    public long getValidationLastTs() {
        return this.validationLastTs;
    }

    @Generated
    public String getJsonData() {
        return this.jsonData;
    }

    @Generated
    public void setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setCustomerId(UUID customerId) {
        this.customerId = customerId;
    }

    @Generated
    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setVisitFirstTs(long visitFirstTs) {
        this.visitFirstTs = visitFirstTs;
    }

    @Generated
    public void setVisitLastTs(long visitLastTs) {
        this.visitLastTs = visitLastTs;
    }

    @Generated
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Generated
    public void setValidationLastTs(long validationLastTs) {
        this.validationLastTs = validationLastTs;
    }

    @Generated
    public void setJsonData(String jsonData) {
        this.jsonData = jsonData;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserRecordDto)) {
            return false;
        }
        UserRecordDto other = (UserRecordDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getVisitFirstTs() != other.getVisitFirstTs()) {
            return false;
        }
        if (this.getVisitLastTs() != other.getVisitLastTs()) {
            return false;
        }
        if (this.isValid() != other.isValid()) {
            return false;
        }
        if (this.getValidationLastTs() != other.getValidationLastTs()) {
            return false;
        }
        UUID this$tenantId = this.getTenantId();
        UUID other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
            return false;
        }
        UUID this$customerId = this.getCustomerId();
        UUID other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !((Object)this$customerId).equals(other$customerId)) {
            return false;
        }
        UUID this$userId = this.getUserId();
        UUID other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$jsonData = this.getJsonData();
        String other$jsonData = other.getJsonData();
        return !(this$jsonData == null ? other$jsonData != null : !this$jsonData.equals(other$jsonData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UserRecordDto;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $visitFirstTs = this.getVisitFirstTs();
        result = result * 59 + (int)($visitFirstTs >>> 32 ^ $visitFirstTs);
        long $visitLastTs = this.getVisitLastTs();
        result = result * 59 + (int)($visitLastTs >>> 32 ^ $visitLastTs);
        result = result * 59 + (this.isValid() ? 79 : 97);
        long $validationLastTs = this.getValidationLastTs();
        result = result * 59 + (int)($validationLastTs >>> 32 ^ $validationLastTs);
        UUID $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
        UUID $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : ((Object)$customerId).hashCode());
        UUID $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $jsonData = this.getJsonData();
        result = result * 59 + ($jsonData == null ? 43 : $jsonData.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UserRecordDto(tenantId=" + String.valueOf(this.getTenantId()) + ", customerId=" + String.valueOf(this.getCustomerId()) + ", userId=" + String.valueOf(this.getUserId()) + ", username=" + this.getUsername() + ", visitFirstTs=" + this.getVisitFirstTs() + ", visitLastTs=" + this.getVisitLastTs() + ", valid=" + this.isValid() + ", validationLastTs=" + this.getValidationLastTs() + ", jsonData=" + this.getJsonData() + ")";
    }

    @Generated
    public UserRecordDto() {
    }

    @Generated
    public UserRecordDto(UUID tenantId, UUID customerId, UUID userId, String username, long visitFirstTs, long visitLastTs, boolean valid, long validationLastTs, String jsonData) {
        this.tenantId = tenantId;
        this.customerId = customerId;
        this.userId = userId;
        this.username = username;
        this.visitFirstTs = visitFirstTs;
        this.visitLastTs = visitLastTs;
        this.valid = valid;
        this.validationLastTs = validationLastTs;
        this.jsonData = jsonData;
    }
}

