/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.cache;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.cache.CachedTelemetryDto;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;

@Repository
public interface CachedTelemetryRepository
extends CrudRepository<CachedTelemetryDto, UUID> {
    @Query(value="select ct from CachedTelemetryDto ct where ct.itemId in (:itemIds) and ct.startTs <= :endTs and ct.endTs >= :startTs and ct.fieldAggregation = :fieldAggregation and ct.dateAggregationType = :equalDateAggregationType and ct.businessEntityFieldId = :businessEntityFieldId")
    public List<CachedTelemetryDto> findAllCompatibleBySingleTelemetry(@Param(value="itemIds") Set<UUID> var1, @Param(value="startTs") long var2, @Param(value="endTs") long var4, @Param(value="fieldAggregation") FieldAggregation var6, @Param(value="equalDateAggregationType") DateAggregationType var7, @Param(value="businessEntityFieldId") UUID var8);

    @Query(value="select ct from CachedTelemetryDto ct where ct.itemId in (:itemIds) and ct.startTs <= :endTs and ct.endTs >= :startTs and ct.fieldAggregation = :fieldAggregation and ct.dateAggregationType = :equalDateAggregationType and ct.calculatedOrStateFunction = :function")
    public List<CachedTelemetryDto> findAllCompatibleByCalculatedTelemetry(@Param(value="itemIds") Set<UUID> var1, @Param(value="startTs") long var2, @Param(value="endTs") long var4, @Param(value="fieldAggregation") FieldAggregation var6, @Param(value="equalDateAggregationType") DateAggregationType var7, @Param(value="function") String var8);

    @Query(value="select count(1) from CachedTelemetryDto")
    public long computeCacheTelemetryCount();

    @Query(value="select count(1) from CachedTelemetryDto ct where ct.itemId = :itemId")
    public long computeCacheTelemetryCountOfItem(@Param(value="itemId") UUID var1);

    @Query(value="select ct.id from CachedTelemetryDto ct where ct.tenantId = :tenantId")
    public Set<UUID> findIdsByTenantId(@Param(value="tenantId") UUID var1);

    @Modifying
    @Query(value="delete from CachedTelemetryDto ct where ct.tenantId = :tenantId")
    public void deleteByTenantId(@Param(value="tenantId") UUID var1);

    @Modifying
    @Query(value="delete from CachedTelemetryDto ct where ct.id in (:idSet)")
    public void deleteByIdSet(@Param(value="idSet") Set<UUID> var1);
}

