/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.cache;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.dao.cache.CachedTelemetryPointDto;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Component
public class CachedTelemetryPointNativeRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CachedTelemetryPointNativeRepository.class);
    @Autowired
    private NamedParameterJdbcTemplate namedJdbcTemplate;
    private final Scheduler scheduler = Schedulers.newParallel((String)"cached-telemetry-native-repository-pool", (int)20);

    public List<CachedTelemetryPointDto> findAllByCachedTelemetryIds(Set<UUID> cachedTelemetryIds) {
        long startTs = System.currentTimeMillis();
        List partition = Lists.partition(new ArrayList<UUID>(cachedTelemetryIds), (int)50);
        List<CachedTelemetryPointDto> result = partition.stream().map(idList -> {
            MapSqlParameterSource queryParameters = new MapSqlParameterSource("ids", idList);
            return this.namedJdbcTemplate.query("SELECT * FROM cached_telemetry_point WHERE cached_telemetry_id in (:ids)", (SqlParameterSource)queryParameters, (resultSet, rowNumber) -> CachedTelemetryPointDto.builder().ts(resultSet.getLong("ts")).cachedTelemetryId(UUID.fromString(resultSet.getString("cached_telemetry_id"))).numericValue(Double.valueOf(resultSet.getDouble("numeric_value"))).stringValue(resultSet.getString("string_value")).booleanValue(Boolean.valueOf(resultSet.getBoolean("boolean_value"))).build());
        }).flatMap(Collection::stream).collect(Collectors.toList());
        long endTs = System.currentTimeMillis();
        log.debug("The points were loaded, time {}, count {}", (Object)(endTs - startTs), (Object)result.size());
        return result;
    }
}

