/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.dao.cache.CachedTelemetryDto;
import org.thingsboard.trendz.dao.cache.CachedTelemetryPointDto;
import org.thingsboard.trendz.dao.cache.CachedTelemetryPointNativeRepository;
import org.thingsboard.trendz.dao.cache.CachedTelemetryPointRepository;
import org.thingsboard.trendz.dao.cache.CachedTelemetryRepository;
import org.thingsboard.trendz.domain.cache.CachedTelemetry;
import org.thingsboard.trendz.domain.cache.CachedTelemetryPoint;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;

@Service
public class CachedTelemetryDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CachedTelemetryDao.class);
    @Autowired
    private CachedTelemetryRepository cachedTelemetryRepository;
    @Autowired
    private CachedTelemetryPointRepository cachedTelemetryPointRepository;
    @Autowired
    private CachedTelemetryPointNativeRepository cachedTelemetryPointNativeRepository;

    @Transactional
    public List<CachedTelemetry> findAllCompatibleCachedTelemetries(Set<UUID> itemIds, long startTs, long endTs, FieldAggregation fieldAggregation, DateAggregationType equalDateAggregationType, UUID businessEntityFieldId, String function) {
        long logStartTs = System.currentTimeMillis();
        List loadedCacheTelemetryDtos = this.loadCompatibleTelemetryHeaders(itemIds, startTs, endTs, fieldAggregation, equalDateAggregationType, businessEntityFieldId, function);
        List<CachedTelemetry> loadedCacheTelemetries = loadedCacheTelemetryDtos.stream().map(CachedTelemetryDto::toData).collect(Collectors.toList());
        long logHeadersLoadedTs = System.currentTimeMillis();
        if (!loadedCacheTelemetries.isEmpty()) {
            this.loadCompatibleTelemetryPoints(loadedCacheTelemetries);
        }
        long logEndTs = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            long telemetryCount = loadedCacheTelemetries.size();
            long telemetryPointCount = loadedCacheTelemetries.stream().map(CachedTelemetry::getPoints).mapToLong(List::size).sum();
            log.debug("CachedTelemetryDao: find compatible caches, loading headers time = {} ms, loading points time = {} ms, count = {}, pointsCount = {}", new Object[]{logHeadersLoadedTs - logStartTs, logEndTs - logHeadersLoadedTs, telemetryCount, telemetryPointCount});
        }
        return loadedCacheTelemetries;
    }

    @Transactional
    public UUID saveAndMergeCaches(CachedTelemetry cachedTelemetry, List<CachedTelemetry> cachedTelemetryList) {
        long logStartTs = System.currentTimeMillis();
        this.removeCachedTelemetryList(cachedTelemetryList);
        UUID uuid = this.saveCachedTelemetry(cachedTelemetry);
        long logEndTs = System.currentTimeMillis();
        log.debug("CachedTelemetryDao: save and merge caches, time = {} ms", (Object)(logEndTs - logStartTs));
        return uuid;
    }

    @Transactional
    public UUID saveCachedTelemetry(CachedTelemetry cachedTelemetry) {
        long logStartTs = System.currentTimeMillis();
        CachedTelemetryDto savedCache = this.updateTelemetryHeader(cachedTelemetry);
        this.saveNewPointsAssignedToHeader(savedCache.getId(), savedCache.getFieldType(), cachedTelemetry.getPoints());
        long logEndTs = System.currentTimeMillis();
        log.debug("CachedTelemetryDao: save cache, time = {} ms, pointCount = {}", (Object)(logEndTs - logStartTs), (Object)cachedTelemetry.getPoints().size());
        cachedTelemetry.setId(savedCache.getId());
        return savedCache.getId();
    }

    @Transactional
    public void removeAllByTenantId(TenantId tenantId) {
        long logStartTs = System.currentTimeMillis();
        Set cachedTelemetryIds = this.cachedTelemetryRepository.findIdsByTenantId(tenantId.getId());
        this.cachedTelemetryRepository.deleteByTenantId(tenantId.getId());
        if (!cachedTelemetryIds.isEmpty()) {
            for (List partition : Lists.partition((List)Lists.newArrayList((Iterable)cachedTelemetryIds), (int)10000)) {
                this.cachedTelemetryPointRepository.deleteAllByCachedTelemetryIds((Set)Sets.newHashSet((Iterable)partition));
            }
        }
        long logEndTs = System.currentTimeMillis();
        log.debug("CachedTelemetryDao: removing all caches by tenant id, time = {} ms", (Object)(logEndTs - logStartTs));
    }

    @Transactional
    public void removeAllCache() {
        long logStartTs = System.currentTimeMillis();
        this.cachedTelemetryPointRepository.deleteAll();
        this.cachedTelemetryRepository.deleteAll();
        long logEndTs = System.currentTimeMillis();
        log.debug("CachedTelemetryDao: removing all caches, time = {} ms", (Object)(logEndTs - logStartTs));
    }

    public long computeCacheTelemetryCount() {
        return this.cachedTelemetryRepository.computeCacheTelemetryCount();
    }

    public long computePointCount() {
        return this.cachedTelemetryPointRepository.computePointCount();
    }

    @Transactional
    public void removeCachedTelemetryListWithTransaction(List<CachedTelemetry> cachedTelemetryList) {
        this.removeCachedTelemetryList(cachedTelemetryList);
    }

    private List<CachedTelemetryDto> loadCompatibleTelemetryHeaders(Set<UUID> itemIds, long startTs, long endTs, FieldAggregation fieldAggregation, DateAggregationType equalDateAggregationType, UUID businessEntityFieldId, String function) {
        if (function == null || function.startsWith("null\n")) {
            return this.cachedTelemetryRepository.findAllCompatibleBySingleTelemetry(itemIds, startTs, endTs, fieldAggregation, equalDateAggregationType, businessEntityFieldId);
        }
        return this.cachedTelemetryRepository.findAllCompatibleByCalculatedTelemetry(itemIds, startTs, endTs, fieldAggregation, equalDateAggregationType, function);
    }

    private void loadCompatibleTelemetryPoints(List<CachedTelemetry> loadedCacheTelemetries) {
        Set loadedCacheTelemetryIds = loadedCacheTelemetries.stream().map(CachedTelemetry::getId).collect(Collectors.toSet());
        Map<UUID, List<CachedTelemetryPointDto>> telemetryIdToPoints = this.cachedTelemetryPointNativeRepository.findAllByCachedTelemetryIds(loadedCacheTelemetryIds).stream().collect(Collectors.groupingBy(CachedTelemetryPointDto::getCachedTelemetryId));
        for (CachedTelemetry telemetry : loadedCacheTelemetries) {
            List cachedTelemetryPoints = telemetryIdToPoints.computeIfAbsent(telemetry.getId(), i -> new ArrayList()).stream().map(CachedTelemetryPointDto::toData).collect(Collectors.toList());
            telemetry.setPoints(cachedTelemetryPoints);
        }
    }

    private CachedTelemetryDto updateTelemetryHeader(CachedTelemetry cachedTelemetry) {
        CachedTelemetryDto dto = CachedTelemetryDto.from((CachedTelemetry)cachedTelemetry);
        if (dto.getId() == null) {
            dto.setId(TimeStampUUIDGenerator.generateId());
        }
        return (CachedTelemetryDto)this.cachedTelemetryRepository.save((Object)dto);
    }

    private void saveNewPointsAssignedToHeader(UUID cacheId, FieldType fieldType, List<CachedTelemetryPoint> pointSet) {
        Set telemetryPointDtos = pointSet.stream().map(point -> CachedTelemetryPointDto.from((CachedTelemetryPoint)point, (UUID)cacheId, (FieldType)fieldType)).collect(Collectors.toSet());
        if (!telemetryPointDtos.isEmpty()) {
            this.cachedTelemetryPointRepository.saveAll(telemetryPointDtos);
        }
    }

    private void removeCachedTelemetryList(List<CachedTelemetry> cachedTelemetryList) {
        if (cachedTelemetryList.isEmpty()) {
            return;
        }
        Set cachedTelemetryIds = cachedTelemetryList.stream().map(CachedTelemetry::getId).collect(Collectors.toSet());
        this.cachedTelemetryRepository.deleteByIdSet(cachedTelemetryIds);
        if (!cachedTelemetryIds.isEmpty()) {
            this.cachedTelemetryPointRepository.deleteAllByCachedTelemetryIds(cachedTelemetryIds);
        }
    }
}

