/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.business.metadata;

import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.business.metadata.BusinessEntityFieldMetadataDto;
import org.thingsboard.trendz.dao.business.metadata.BusinessEntityFieldMetadataRepository;
import org.thingsboard.trendz.domain.definition.entity.metadata.BusinessEntityFieldMetadata;
import org.thingsboard.trendz.domain.definition.entity.metadata.RangeConfig;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.tools.json.JsonUtils;

@Service
@Transactional
public class BusinessEntityFieldMetadataDao {
    private final BusinessEntityFieldMetadataRepository fieldMetadataRepository;

    @Autowired
    public BusinessEntityFieldMetadataDao(BusinessEntityFieldMetadataRepository fieldMetadataRepository) {
        this.fieldMetadataRepository = fieldMetadataRepository;
    }

    public Optional<BusinessEntityFieldMetadata> getMetadata(JwtSecurityUser user, UUID entityFieldId) {
        UUID tenantId = user.getTenantId();
        UUID customerId = user.getCustomerId();
        return this.fieldMetadataRepository.findByEntityFieldId(entityFieldId, tenantId, customerId).map(BusinessEntityFieldMetadataDto::toData);
    }

    public BusinessEntityFieldMetadata updateMetadata(RangeConfig newRangeConfig, String dateGrouping, FieldAggregation aggregation, JwtSecurityUser user, UUID entityFieldId) {
        UUID tenantId = user.getTenantId();
        UUID customerId = user.getCustomerId();
        BusinessEntityFieldMetadataDto metadataDto = this.fieldMetadataRepository.findByEntityFieldId(entityFieldId, tenantId, customerId).orElseGet(() -> BusinessEntityFieldMetadataDto.builder().id(UUID.randomUUID()).businessEntityFieldId(entityFieldId).tenantId(tenantId).customerId(customerId).build());
        if (aggregation != null) {
            metadataDto.setAggregation(aggregation.name());
        }
        if (newRangeConfig != null) {
            metadataDto.setRangeConfig(JsonUtils.toJson((Object)newRangeConfig));
        }
        if (dateGrouping != null) {
            metadataDto.setDateGrouping(dateGrouping);
        }
        return ((BusinessEntityFieldMetadataDto)this.fieldMetadataRepository.save((Object)metadataDto)).toData();
    }

    public void clearDataFromMetadata(JwtSecurityUser user, UUID entityFieldId, boolean clearRange, boolean clearAggregation, boolean clearDateGrouping) {
        UUID tenantId = user.getTenantId();
        UUID customerId = user.getCustomerId();
        this.fieldMetadataRepository.findByEntityFieldId(entityFieldId, tenantId, customerId).ifPresent(businessEntityFieldMetadataDto -> {
            if (clearRange) {
                businessEntityFieldMetadataDto.setRangeConfig(null);
            }
            if (clearAggregation) {
                businessEntityFieldMetadataDto.setAggregation(null);
            }
            if (clearDateGrouping) {
                businessEntityFieldMetadataDto.setDateGrouping(null);
            }
            this.fieldMetadataRepository.save(businessEntityFieldMetadataDto);
        });
    }

    public List<BusinessEntityFieldMetadata> findAll(JwtSecurityUser user) {
        return this.fieldMetadataRepository.findAllByTenantId(user.getTenantId()).stream().map(BusinessEntityFieldMetadataDto::toData).toList();
    }

    public List<BusinessEntityFieldMetadata> saveAll(List<BusinessEntityFieldMetadata> entityFieldMetadata) {
        return entityFieldMetadata.stream().map(metadata -> this.updateMetadata(metadata.getRangeConfig(), metadata.getDateGrouping(), metadata.getAggregation(), JwtSecurityUser.builder().tenantId(metadata.getTenantId()).customerId(metadata.getCustomerId()).build(), metadata.getBusinessEntityFieldId())).toList();
    }
}

