/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.assistance.customprompt;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.assistance.customprompt.CustomPromptDto;
import org.thingsboard.trendz.domain.assistance.customprompt.CustomPromptLite;

@Repository
public interface CustomPromptRepository
extends CrudRepository<CustomPromptDto, UUID> {
    @Query(value="SELECT new org.thingsboard.trendz.domain.assistance.customprompt.CustomPromptLite(\n    cp.id,\n    cp.name,\n    cp.isSystem,\n    cp.createdTs,\n    cp.lastModifiedTs\n)\nFROM custom_prompt cp\nWHERE (\n        (\n            cp.tenantId = :tenantId\n            AND (coalesce(:customerId, null) is null or cp.customerId = :customerId)\n        ) OR cp.isSystem\n    ) AND NOT cp.isDeleted\n    AND (\n        :isSystem IS NULL OR\n        (:isSystem = 'true' AND cp.isSystem = true) OR\n        (:isSystem = 'false' AND cp.isSystem = false)\n    )\n")
    public Page<CustomPromptLite> findAllCustomPromptLiteByTenantIdAndCustomerId(UUID var1, UUID var2, String var3, PageRequest var4);

    @Query(value="SELECT cp FROM custom_prompt cp\nWHERE (\n        (\n            cp.tenantId = :tenantId\n            AND (coalesce(:customerId, null) is null or cp.customerId = :customerId)\n        ) OR cp.isSystem\n    ) AND cp.id = :id\n    AND NOT cp.isDeleted\n")
    public Optional<CustomPromptDto> findByIdAndTenantIdAndCustomerId(UUID var1, UUID var2, UUID var3);

    @Query(value="SELECT cp FROM custom_prompt cp\nWHERE cp.tenantId = :tenantId\n    AND NOT cp.isDeleted\n    AND NOT cp.isSystem\n")
    public List<CustomPromptDto> findAllNonSystemByTenantId(UUID var1);

    @Query(value="SELECT new org.thingsboard.trendz.domain.assistance.customprompt.CustomPromptLite(\n    cp.id,\n    cp.name,\n    cp.isSystem,\n    cp.createdTs,\n    cp.lastModifiedTs\n)\nFROM custom_prompt cp\nWHERE cp.isSystem\n    AND NOT cp.isDeleted\n")
    public List<CustomPromptLite> findAllSystemCustomPromptLite();

    @Query(value="WITH user_prompts AS (\n    SELECT cp.id AS id\n    FROM custom_prompt cp\n    WHERE NOT cp.is_system\n        AND cp.id = :id\n        AND cp.tenant_id = :tenantId\n        AND NOT cp.is_deleted\n)\nSELECT 'VIEW_CONFIG' as TYPE, vc.name AS name\nFROM view_config vc\nJOIN user_prompts up\n    ON CAST((CAST(vc.settings AS jsonb) ->> 'promptId') AS uuid) = up.id;\n", nativeQuery=true)
    public List<Object[]> findDependedEntities(UUID var1, UUID var2);
}

