/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.assistance.chat;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.assistance.chat.ChatDto;
import org.thingsboard.trendz.dao.assistance.chat.ChatMessageDto;
import org.thingsboard.trendz.domain.chat.ChatLite;
import org.thingsboard.trendz.domain.summary.TrendzSimpleEntityUsage;

@Repository
public interface ChatRepository
extends CrudRepository<ChatDto, UUID> {
    @Query(value="SELECT cd FROM view_assistance_chat cd\nWHERE cd.id = :id\n    AND cd.tenantId = :tenantId\n    AND (coalesce(:customerId, null) is null or cd.customerId = :customerId)\n    AND NOT cd.isDeleted\n")
    public Optional<ChatDto> findByIdAndTenantIdAndCustomerId(UUID var1, UUID var2, UUID var3);

    @Query(value="SELECT new org.thingsboard.trendz.domain.chat.ChatLite(\n    cd, cmd, (\n        SELECT COUNT(ss.id)\n        FROM view_assistance_chat_message ss\n        WHERE ss.chatId = cd.id\n            AND NOT ss.isDeleted\n    )\n)\nFROM view_assistance_chat cd\nLEFT JOIN cd.chatMessageDtoList cmd\nON cd.id = cmd.chatId\n    AND cmd.lastModifiedTs = (\n        SELECT MAX(ss.lastModifiedTs)\n        FROM view_assistance_chat_message ss\n        WHERE ss.chatId = cd.id\n            AND NOT ss.isDeleted\n    ) AND NOT cmd.isDeleted\nWHERE cd.tenantId = :tenantId\n    AND (coalesce(:customerId, null) is null or cd.customerId = :customerId)\n    AND (coalesce(:referenceKey, null) is null or cd.referenceKey = :referenceKey)\n    AND (coalesce(:type, null) is null or cd.type = :type)\n    AND (coalesce(:metricId, null) is null or cd.metricDefinitionId = :metricId)\n    AND NOT cd.isDeleted\n")
    public Page<ChatLite> findAllChatLiteByTenantIdAndCustomerId(UUID var1, UUID var2, String var3, String var4, UUID var5, PageRequest var6);

    @Query(value="SELECT new org.thingsboard.trendz.domain.chat.ChatLite(\n    cd, cmd, (\n        SELECT COUNT(ss.id)\n        FROM view_assistance_chat_message ss\n        WHERE ss.chatId = cd.id\n            AND NOT ss.isDeleted\n    )\n)\nFROM view_assistance_chat cd\nLEFT JOIN cd.chatMessageDtoList cmd\nON cd.id = cmd.chatId\n    AND cmd.lastModifiedTs = (\n        SELECT MAX(ss.lastModifiedTs)\n        FROM view_assistance_chat_message ss\n        WHERE ss.chatId = cd.id\n            AND NOT ss.isDeleted\n    ) AND NOT cmd.isDeleted\nWHERE cd.tenantId = :tenantId\n    AND (coalesce(:customerId, null) is null or cd.customerId = :customerId)\n    AND cd.id = :chatId\n    AND NOT cd.isDeleted\n")
    public Optional<ChatLite> findLiteByIdAndTenantIdAndCustomerId(UUID var1, UUID var2, UUID var3);

    @Query(value="SELECT cmd FROM view_assistance_chat cd\nINNER JOIN cd.chatMessageDtoList cmd ON cd.id = cmd.chatId\nWHERE cd.tenantId = :tenantId\n    AND (coalesce(:customerId, null) is null or cd.customerId = :customerId)\n    AND cd.id = :chatId AND cmd.id = :messageId\n    AND NOT cd.isDeleted\n    AND NOT cmd.isDeleted\n")
    public Optional<ChatMessageDto> findChatMessageByChatIdAndMessageIdAndTenantIdAndCustomerId(UUID var1, UUID var2, UUID var3, UUID var4);

    @Query(value="UPDATE view_assistance_chat cd\nSET cd.isDeleted=true\nWHERE cd.tenantId = :tenantId\n    AND (coalesce(:customerId, null) is null or cd.customerId = :customerId)\n    AND cd.id = :chatId\n")
    @Modifying
    public void deleteByIdAndTenantIdAndCustomerId(UUID var1, UUID var2, UUID var3);

    @Query(value="UPDATE view_assistance_chat cd\nSET cd.chatSummary=:chatSummary\nWHERE cd.id = :chatId\n")
    @Modifying
    public void updateChatSummaryById(UUID var1, String var2);

    @Query(value="SELECT cd FROM view_assistance_chat cd\nWHERE cd.tenantId = :tenantId\n    AND NOT cd.isDeleted\n    AND (coalesce(:customerId, null) is null or cd.customerId = :customerId)\n")
    public List<ChatDto> findAllByTenantIdAndCustomerId(UUID var1, UUID var2);

    @Query(value="    SELECT new org.thingsboard.trendz.domain.summary.TrendzSimpleEntityUsage(COUNT(c))\n    FROM view_assistance_chat c\n    WHERE (:tenantId = :nullId OR c.tenantId = :tenantId)\n        AND c.isDeleted = false\n")
    public Optional<TrendzSimpleEntityUsage> findUsage(UUID var1, UUID var2);
}

