/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.dao.assistance.chat;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Repository;
import org.thingsboard.trendz.dao.assistance.chat.ChatMessageDto;
import org.thingsboard.trendz.domain.chat.ChatMessageLite;

@Repository
public interface ChatMessageRepository
extends CrudRepository<ChatMessageDto, UUID> {
    @Query(value="SELECT new org.thingsboard.trendz.domain.chat.ChatMessageLite(cmd)\nFROM view_assistance_chat_message cmd\nINNER JOIN view_assistance_chat cd ON cd.id = cmd.chatId\nWHERE cd.tenantId = :tenantId\n    AND (coalesce(:customerId, null) is null or cd.customerId = :customerId)\n    AND cd.id = :chatId\n    AND NOT cd.isDeleted\n    AND NOT cmd.isDeleted\n")
    public Page<ChatMessageLite> findAllChatMessageLiteByChatIdAndTenantIdAndCustomerId(UUID var1, UUID var2, UUID var3, PageRequest var4);

    @Query(value="SELECT new org.thingsboard.trendz.domain.chat.ChatMessageLite(cmd)\nFROM view_assistance_chat_message cmd\nINNER JOIN view_assistance_chat cd ON cd.id = cmd.chatId\nWHERE cd.tenantId = :tenantId\n    AND (coalesce(:customerId, null) is null or cd.customerId = :customerId)\n    AND cd.id = :chatId\n    AND NOT cd.isDeleted\n    AND NOT cmd.isDeleted\nORDER BY cd.createdTs\n")
    public List<ChatMessageLite> findAllChatMessageLiteByChatIdAndTenantIdAndCustomerId(UUID var1, UUID var2, UUID var3);

    @Query(value="SELECT cmd\nFROM view_assistance_chat_message cmd\nWHERE cmd.chatId = :chatId\n    AND NOT cmd.isDeleted\nORDER BY cmd.createdTs DESC\nLIMIT 1\n")
    public Optional<ChatMessageDto> findLastByChatId(UUID var1);

    @Modifying
    @Query(value="   UPDATE view_assistance_chat_message cmd\n   SET cmd.jsonJobResponse = :jsonJobResponse,\n        cmd.aiAnswer = :aiAnswer,\n        cmd.aiMemory = :aiMemory\n   WHERE cmd.id = :messageId\n")
    public void updateJsonJobResponseAndAiAnswer(UUID var1, String var2, String var3, String var4);

    @Query(value="UPDATE view_assistance_chat_message cmd\nSET cmd.isDeleted=true\nWHERE cmd.chatId = :chatId\n")
    @Modifying
    public void deleteByChatId(UUID var1);

    @Query(value="SELECT cmd FROM view_assistance_chat_message cmd\nINNER JOIN view_assistance_chat cd ON cd.id = cmd.chatId\nWHERE cd.tenantId = :tenantId\n    AND NOT cd.isDeleted\n    AND NOT cmd.isDeleted\n")
    public List<ChatMessageDto> findAllByTenantId(UUID var1);

    @Query(value="SELECT cmd FROM view_assistance_chat_message cmd\nINNER JOIN view_assistance_chat cd ON cd.id = cmd.chatId\nWHERE cd.tenantId = :tenantId\n    AND (coalesce(:customerId, null) is null or cd.customerId = :customerId)\n    AND cd.id = :chatId\n    AND NOT cd.isDeleted\n    AND NOT cmd.isDeleted\n    AND (COALESCE(:toExclude, NULL) IS NULL OR cmd.id NOT IN :toExclude)\nORDER BY cmd.createdTs DESC\nLIMIT 1\n")
    public Optional<ChatMessageDto> getLastChatMessage(UUID var1, UUID var2, UUID var3, Set<UUID> var4);
}

