/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.definition.view.config.ViewCollection;
import org.thingsboard.trendz.exception.view.ViewCollectionNotFoundException;
import org.thingsboard.trendz.service.ViewCollectionService;
import org.thingsboard.trendz.tools.UUIDUtils;

@RestController
@RequestMapping(value={"/apiTrendz/view/collection"})
public class ViewCollectionController
extends BaseController {
    private final ViewCollectionService viewCollectionService;

    @Autowired
    public ViewCollectionController(ViewCollectionService viewCollectionService) {
        this.viewCollectionService = viewCollectionService;
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/filter/{prefix}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getAllConfigsByPrefix(@PathVariable(value="prefix") String prefix) {
        Set set = this.viewCollectionService.getAllCollectionsByPrefix(this.getSecurityUser(), prefix);
        return ResponseEntity.ok(new ArrayList(set));
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/all"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getAllCollections() {
        Set set = this.viewCollectionService.getAllCollections(this.getSecurityUser());
        return ResponseEntity.ok(new ArrayList(set));
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/all/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getAllCollectionsByParent(@PathVariable(value="id") String collectionIdStr) {
        UUID collectionId = UUIDUtils.parse((String)collectionIdStr);
        Set set = this.viewCollectionService.getAllCollectionsByParent(this.getSecurityUser(), collectionId);
        return ResponseEntity.ok(new ArrayList(set));
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getById(@PathVariable(value="id") String collectionIdStr) {
        UUID collectionId = UUIDUtils.parse((String)collectionIdStr);
        ViewCollection collection = (ViewCollection)this.viewCollectionService.findById(this.getSecurityUser(), collectionId).orElseThrow(() -> new ViewCollectionNotFoundException(collectionId));
        return ResponseEntity.ok((Object)collection);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/rename/{id}/{name}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<?> rename(@PathVariable(value="id") String collectionIdStr, @PathVariable(value="name") String name) {
        UUID collectionId = UUIDUtils.parse((String)collectionIdStr);
        boolean renamed = this.viewCollectionService.renameCollection(this.getSecurityUser(), collectionId, name);
        return ResponseEntity.ok((Object)renamed);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> save(@RequestBody ViewCollection viewCollection) {
        ViewCollection savedCollection = this.viewCollectionService.saveCollection(this.getSecurityUser(), viewCollection);
        return ResponseEntity.ok((Object)savedCollection);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{parentCollectionId}/{currentCollectionId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<?> move(@PathVariable(value="currentCollectionId") String strCurrentCollectionId, @PathVariable(value="parentCollectionId") String strParentCollectionId) {
        UUID currentCollectionId = UUIDUtils.parse((String)strCurrentCollectionId);
        UUID parentCollectionId = UUIDUtils.parse((String)strParentCollectionId);
        boolean moved = this.viewCollectionService.moveCollection(this.getSecurityUser(), currentCollectionId, parentCollectionId);
        return ResponseEntity.ok((Object)moved);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{parentCollectionId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<?> moveSet(@RequestBody Set<String> strCollectionIdSet, @PathVariable(value="parentCollectionId") String strParentCollectionId) {
        Set collectionIdSet = strCollectionIdSet.stream().map(UUIDUtils::parse).collect(Collectors.toSet());
        UUID parentCollectionId = UUIDUtils.parse((String)strParentCollectionId);
        boolean moved = this.viewCollectionService.moveCollectionSet(this.getSecurityUser(), collectionIdSet, parentCollectionId);
        return ResponseEntity.ok((Object)moved);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/delete/{collectionId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<?> delete(@PathVariable(value="collectionId") String collectionIdStr) {
        UUID collectionId = UUIDUtils.parse((String)collectionIdStr);
        boolean deleted = this.viewCollectionService.deleteCollection(this.getSecurityUser(), collectionId);
        return ResponseEntity.ok((Object)deleted);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/deleteSet"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> deleteAll(@RequestBody Set<String> strCollectionIdSet) {
        Set collectionIdSet = strCollectionIdSet.stream().map(UUIDUtils::parse).collect(Collectors.toSet());
        boolean deleted = this.viewCollectionService.deleteCollectionSet(this.getSecurityUser(), collectionIdSet);
        return ResponseEntity.ok((Object)deleted);
    }
}

