/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.user.UserMetadataService;
import org.thingsboard.trendz.tools.UUIDUtils;

@RestController
@RequestMapping(value={"/apiTrendz/user/metadata"})
public class UserMetadataController
extends BaseController {
    private final UserMetadataService userMetadataService;

    @Autowired
    public UserMetadataController(UserMetadataService userMetadataService) {
        this.userMetadataService = userMetadataService;
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/datePicker"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<DatePickerConfig> getDatePickerConfig() {
        JwtSecurityUser user = this.getSecurityUser();
        DatePickerConfig datePickerConfig = this.userMetadataService.getDatePickerConfig(user);
        return ResponseEntity.ok((Object)datePickerConfig);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/datePicker"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> saveDatePickerConfig(@RequestBody DatePickerConfig datePickerConfig) {
        JwtSecurityUser user = this.getSecurityUser();
        this.userMetadataService.saveDatePickerConfig(user, datePickerConfig);
        return ResponseEntity.ok((Object)"");
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/entityId"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getBusinessEntityId() {
        JwtSecurityUser user = this.getSecurityUser();
        UUID businessEntityId = this.userMetadataService.getBusinessEntityId(user);
        return ResponseEntity.ok((Object)businessEntityId);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/entityId/{entityId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> saveBusinessEntityId(@PathVariable(value="entityId") String entityIdStr) {
        JwtSecurityUser user = this.getSecurityUser();
        UUID entityId = UUIDUtils.parse((String)entityIdStr);
        this.userMetadataService.saveBusinessEntityId(user, entityId);
        return ResponseEntity.ok((Object)"");
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/item"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getDefaultItem() {
        JwtSecurityUser user = this.getSecurityUser();
        ItemLite itemLite = this.userMetadataService.getItem(user);
        return ResponseEntity.ok((Object)itemLite);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/item"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> saveItem(@RequestBody ItemLite item) {
        JwtSecurityUser user = this.getSecurityUser();
        this.userMetadataService.saveItem(user, item);
        return ResponseEntity.ok((Object)"");
    }
}

