/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.summary.TrendzSummary;
import org.thingsboard.trendz.domain.summary.TrendzUsageSummary;
import org.thingsboard.trendz.service.summary.TrendzSummaryService;

@RestController
@RequestMapping(value={"/apiTrendz/summary"})
public class TrendzSummaryController
extends BaseController {
    private final TrendzSummaryService trendzSummaryService;

    @Autowired
    public TrendzSummaryController(TrendzSummaryService trendzSummaryService) {
        this.trendzSummaryService = trendzSummaryService;
    }

    @GetMapping
    @ResponseBody
    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    public ResponseEntity<TrendzSummary> getTrendzSummary() {
        TrendzSummary trendzSummary = this.trendzSummaryService.getTrendzSummary(this.getSecurityUser());
        return ResponseEntity.ok((Object)trendzSummary);
    }

    @GetMapping(value={"/usage"})
    @ResponseBody
    @PreAuthorize(value="hasAnyAuthority('SYS_ADMIN', 'TENANT_ADMIN')")
    public ResponseEntity<TrendzUsageSummary> getTrendzUsage() {
        TrendzUsageSummary trendzUsageSummary = this.trendzSummaryService.getUsageSummary(this.getSecurityUser());
        return ResponseEntity.ok((Object)trendzUsageSummary);
    }
}

