/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.sql.SqlDatasource;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationInfo;
import org.thingsboard.trendz.service.sql.SqlDatasourceService;
import org.thingsboard.trendz.tools.UUIDUtils;

@RestController
@RequestMapping(value={"/apiTrendz/datasource"})
@ConditionalOnProperty(value={"deployment.cloud"}, havingValue="false")
public class SqlDatasourceController
extends BaseController {
    private final SqlDatasourceService sqlDatasourceService;

    @Autowired
    public SqlDatasourceController(SqlDatasourceService sqlDatasourceService) {
        this.sqlDatasourceService = sqlDatasourceService;
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/all"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<List<SqlDatasource>> getAllDatasource() {
        JwtSecurityUser user = this.getSecurityUser();
        List sqlDatasource = this.sqlDatasourceService.findAll(user);
        return ResponseEntity.ok((Object)sqlDatasource);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<SqlDatasource> findById(@PathVariable(value="id") String strEntityId) {
        UUID id = UUID.fromString(strEntityId);
        JwtSecurityUser user = this.getSecurityUser();
        SqlDatasource entity = this.sqlDatasourceService.getById(user.getTenantId(), id);
        entity.maskPassword();
        return ResponseEntity.ok((Object)entity);
    }

    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<SqlDatasource> save(@RequestBody SqlDatasource sqlDatasource) {
        SqlDatasource saved = this.sqlDatasourceService.save(this.getSecurityUser(), sqlDatasource);
        return ResponseEntity.ok((Object)saved);
    }

    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<Boolean> delete(@PathVariable(value="id") String strEntityId) {
        UUID id = UUID.fromString(strEntityId);
        JwtSecurityUser user = this.getSecurityUser();
        boolean res = this.sqlDatasourceService.delete(user, id);
        return ResponseEntity.ok((Object)res);
    }

    @PreAuthorize(value="hasAuthority('TENANT_ADMIN')")
    @RequestMapping(value={"/dependedEntities/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> checkDependedEntitiesBeforeDelete(@PathVariable(value="id") String strEntityId) {
        JwtSecurityUser user = this.getSecurityUser();
        UUID entityId = UUIDUtils.parse((String)strEntityId);
        SqlDatasource entity = this.sqlDatasourceService.getById(user.getTenantId(), entityId);
        ChangeEntityValidationInfo dependedEntitiesInfo = this.sqlDatasourceService.findDependedEntities(user, entity);
        return ResponseEntity.ok((Object)dependedEntitiesInfo);
    }
}

