/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.time.ZoneId;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityQuery;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.metadata.RangeConfig;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.metric.item.ItemSummary;
import org.thingsboard.trendz.domain.metric.item.MetricExplorationGenericRequest;
import org.thingsboard.trendz.domain.metric.item.pattern.ItemMetricTimePatternRequest;
import org.thingsboard.trendz.domain.metric.item.pattern.ItemMetricTimePatternResponse;
import org.thingsboard.trendz.domain.metric.item.range.RangeConfigBuildRequest;
import org.thingsboard.trendz.domain.metric.item.range.RangeConfigBuildResponse;
import org.thingsboard.trendz.domain.metric.item.statistics.ItemMetricStatistics;
import org.thingsboard.trendz.domain.runtime.EnhancedItemLite;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.metric.item.ItemMetricRangeConfigService;
import org.thingsboard.trendz.service.metric.item.ItemMetricStatisticsService;
import org.thingsboard.trendz.service.metric.item.ItemMetricSummaryService;
import org.thingsboard.trendz.service.metric.item.ItemMetricTimePatternService;
import org.thingsboard.trendz.service.view.ItemService;
import org.thingsboard.trendz.tools.DateTimeUtils;
import org.thingsboard.trendz.tools.DonReactive;
import org.thingsboard.trendz.tools.UUIDUtils;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/apiTrendz/item/"})
public class ItemController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ItemController.class);
    private final BusinessEntityService businessEntityService;
    private final ItemService itemService;
    private final ItemMetricSummaryService itemMetricSummaryService;
    private final ItemMetricStatisticsService itemMetricStatisticsService;
    private final ItemMetricTimePatternService itemMetricTimePatternService;
    private final ItemMetricRangeConfigService itemMetricRangeConfigService;

    @Autowired
    public ItemController(BusinessEntityService businessEntityService, ItemService itemService, ItemMetricSummaryService itemMetricSummaryService, ItemMetricStatisticsService itemMetricStatisticsService, ItemMetricTimePatternService itemMetricTimePatternService, ItemMetricRangeConfigService itemMetricRangeConfigService) {
        this.businessEntityService = businessEntityService;
        this.itemService = itemService;
        this.itemMetricSummaryService = itemMetricSummaryService;
        this.itemMetricStatisticsService = itemMetricStatisticsService;
        this.itemMetricTimePatternService = itemMetricTimePatternService;
        this.itemMetricRangeConfigService = itemMetricRangeConfigService;
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/all"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getAll(@RequestParam(value="businessEntityId") String businessEntityIdStr) {
        UUID businessEntityId = UUIDUtils.parse((String)businessEntityIdStr);
        JwtSecurityUser user = this.getSecurityUser();
        BusinessEntity entity = this.businessEntityService.findEntityById(user, businessEntityId);
        boolean isExternal = Optional.of(entity.getQuery()).map(BusinessEntityQuery::getEntityType).filter(type -> type == BusinessEntityType.EXTERNAL).isPresent();
        if (isExternal) {
            return ResponseEntity.ok(Collections.emptyList());
        }
        List items = (List)DonReactive.block((Mono)this.itemService.loadItems(entity, null, null, null, user).map(Item::toLite).collectList());
        return ResponseEntity.ok((Object)items);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/textSearch"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getAllByName(@RequestParam(value="value", required=false) String textSearch) {
        List<EnhancedItemLite> items = ((List)DonReactive.block((Mono)this.itemService.loadItems(textSearch, this.getSecurityUser(), Integer.valueOf(500)).collectList())).stream().filter(item -> textSearch == null || item.getItem().getName().toLowerCase().contains(textSearch.toLowerCase())).sorted(Comparator.comparing(item -> item.getItem().getName())).toList();
        return ResponseEntity.ok(items);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/summary"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> summary(@RequestParam(value="businessEntityId") String businessEntityIdStr, @RequestParam(value="itemId") String itemIdStr, @RequestBody MetricExplorationGenericRequest request) {
        UUID itemId = UUIDUtils.parse((String)itemIdStr);
        UUID businessEntityId = UUIDUtils.parse((String)businessEntityIdStr);
        JwtSecurityUser user = this.getSecurityUser();
        BusinessEntity businessEntity = this.businessEntityService.findEntityById(user, businessEntityId);
        ItemSummary itemSummary = this.itemMetricSummaryService.getItemSummary(businessEntity, itemId, user, request);
        return ResponseEntity.ok((Object)itemSummary);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/statistics"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> getStatistics(@RequestParam(value="entityFieldId") String entityFieldIdStr, @RequestParam(value="itemId") String itemIdStr, @RequestBody MetricExplorationGenericRequest request) {
        UUID itemId = UUIDUtils.parse((String)itemIdStr);
        UUID entityFieldId = UUIDUtils.parse((String)entityFieldIdStr);
        JwtSecurityUser user = this.getSecurityUser();
        ItemMetricStatistics statistics = this.itemMetricStatisticsService.getStatistics(user, itemId, entityFieldId, request);
        return ResponseEntity.ok((Object)statistics);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/time-patterns"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> getTimePatterns(@RequestBody ItemMetricTimePatternRequest request) {
        JwtSecurityUser user = this.getSecurityUser();
        ItemMetricTimePatternResponse timePatterns = this.itemMetricTimePatternService.getTimePatterns(user, request);
        return ResponseEntity.ok((Object)timePatterns);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/range-config/default"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> getDefaultRangeConfig(@RequestParam(value="entityFieldId") String entityFieldIdStr, @RequestParam(value="itemId") String itemIdStr, @RequestBody MetricExplorationGenericRequest request) {
        UUID itemId = UUIDUtils.parse((String)itemIdStr);
        UUID entityFieldId = UUIDUtils.parse((String)entityFieldIdStr);
        DatePickerConfig datePickerConfig = request.getDatePickerConfig();
        ZoneId zoneId = DateTimeUtils.fromTzName((String)request.getTzName());
        JwtSecurityUser user = this.getSecurityUser();
        RangeConfig defaultRangeConfig = this.itemMetricRangeConfigService.getDefault(entityFieldId, user, datePickerConfig, zoneId, itemId);
        return ResponseEntity.ok((Object)defaultRangeConfig);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/range-config/execute"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> executeRangeConfig(@RequestBody RangeConfigBuildRequest request) {
        JwtSecurityUser user = this.getSecurityUser();
        RangeConfigBuildResponse response = this.itemMetricRangeConfigService.triggerRangeConfigBuild(user, request);
        return ResponseEntity.ok((Object)response);
    }
}

