/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.time.ZoneId;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.definition.calculation.CalculationField;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldFilteringField;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldSortingField;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldTaskData;
import org.thingsboard.trendz.domain.definition.calculation.CalculationFieldTestingRequest;
import org.thingsboard.trendz.exception.calculation.CalculationFieldNotFoundByEntityFieldException;
import org.thingsboard.trendz.exception.calculation.CalculationFieldNotFoundException;
import org.thingsboard.trendz.exception.task.TaskNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.calculation.CalculationFieldService;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationInfo;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskService;
import org.thingsboard.trendz.service.task.job.SaveCalculationFieldToTbJob;
import org.thingsboard.trendz.service.task.job.TestCalculationFieldJob;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskConfig;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;
import org.thingsboard.trendz.service.task.model.TaskSchedule;
import org.thingsboard.trendz.tools.PaginationPage;
import org.thingsboard.trendz.tools.UUIDUtils;

@RestController
@RequestMapping(value={"/apiTrendz/calculation"})
public class CalculationFieldController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculationFieldController.class);
    private final CalculationFieldService calculationFieldService;
    private final TaskService taskService;

    @Autowired
    public CalculationFieldController(CalculationFieldService calculationFieldService, TaskService taskService) {
        this.calculationFieldService = calculationFieldService;
        this.taskService = taskService;
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/all"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getAll(@RequestParam(value="page", required=false, defaultValue="0") String pageStr, @RequestParam(value="pageSize", required=false, defaultValue="1000") String pageSizeStr, @RequestParam(value="filter", required=false, defaultValue="") List<String> filter, @RequestParam(value="sort", required=false, defaultValue="creationTime:desc") List<String> sort) {
        JwtSecurityUser securityUser = this.getSecurityUser();
        int page = Integer.parseInt(pageStr);
        int pageSize = Integer.parseInt(pageSizeStr);
        List filteringFields = filter.stream().map(CalculationFieldFilteringField::fromString).collect(Collectors.toList());
        List sortingFields = sort.stream().map(CalculationFieldSortingField::fromString).collect(Collectors.toList());
        Page all = this.calculationFieldService.getAllLite(securityUser, page, pageSize, filteringFields, sortingFields);
        PaginationPage allPage = new PaginationPage(all);
        return ResponseEntity.ok((Object)allPage);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{fieldId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> findById(@PathVariable(value="fieldId") String strFieldId) {
        JwtSecurityUser securityUser = this.getSecurityUser();
        UUID fieldId = UUIDUtils.parse((String)strFieldId);
        CalculationField field = (CalculationField)this.calculationFieldService.findById(securityUser, fieldId, true).orElseThrow(() -> new CalculationFieldNotFoundException(fieldId));
        return ResponseEntity.ok((Object)field);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> save(@RequestBody CalculationField calculationField) {
        JwtSecurityUser securityUser = this.getSecurityUser();
        CalculationField saved = this.calculationFieldService.save(securityUser, calculationField);
        return ResponseEntity.ok((Object)saved);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{fieldId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<?> delete(@PathVariable(value="fieldId") String strFieldId) {
        JwtSecurityUser securityUser = this.getSecurityUser();
        UUID fieldId = UUIDUtils.parse((String)strFieldId);
        boolean deleted = this.calculationFieldService.delete(securityUser, fieldId);
        return ResponseEntity.ok((Object)deleted);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/rename/{fieldId}/{name}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ResponseEntity<?> rename(@PathVariable(value="fieldId") String strFieldId, @PathVariable(value="name") String name) {
        JwtSecurityUser user = this.getSecurityUser();
        UUID fieldId = UUIDUtils.parse((String)strFieldId);
        boolean renamed = this.calculationFieldService.rename(user, fieldId, name);
        return ResponseEntity.ok((Object)renamed);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/byEntityField/{entityFieldId}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getByEntityField(@PathVariable(value="entityFieldId") String entityFieldIdStr) {
        JwtSecurityUser user = this.getSecurityUser();
        UUID businessEntityFieldId = UUIDUtils.parse((String)entityFieldIdStr);
        CalculationField field = (CalculationField)this.calculationFieldService.findFieldByEntityFieldId(businessEntityFieldId, user, true).orElseThrow(() -> new CalculationFieldNotFoundByEntityFieldException(businessEntityFieldId));
        return ResponseEntity.ok((Object)field);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/dependedEntities/{fieldId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> findDependedEntities(@PathVariable(value="fieldId") String strFieldId) {
        JwtSecurityUser securityUser = this.getSecurityUser();
        UUID fieldId = UUIDUtils.parse((String)strFieldId);
        ChangeEntityValidationInfo dependedEntitiesInfo = this.calculationFieldService.findDependedEntities(securityUser, fieldId);
        return ResponseEntity.ok((Object)dependedEntitiesInfo);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/test"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> test(@RequestBody CalculationFieldTestingRequest request) {
        JwtSecurityUser user = this.getSecurityUser();
        UUID id = request.getCalculationField().getId();
        String referenceKey = id == null ? user.getTenantCustomerKey() : id.toString();
        TaskReference reference = new TaskReference(TaskReferencedEntityType.CALCULATION_FIELD_TEST, referenceKey);
        Task task = (Task)this.taskService.findTaskByReferencedEntity(user, reference).orElseThrow(() -> new TaskNotFoundException(reference));
        TestCalculationFieldJob job = new TestCalculationFieldJob(request);
        UUID executionId = this.taskService.runExecution(user, task.getId(), (TaskJob)job, false);
        return ResponseEntity.ok((Object)executionId);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/taskData/{calculationId}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getTaskData(@PathVariable(value="calculationId") String strCalculationId) {
        JwtSecurityUser user = this.getSecurityUser();
        UUID calculationId = UUIDUtils.parse((String)strCalculationId);
        CalculationField calculationField = (CalculationField)this.calculationFieldService.findById(user, calculationId).orElseThrow(() -> new CalculationFieldNotFoundException(calculationId));
        CalculationFieldTaskData taskData = this.calculationFieldService.getTaskData(user, calculationId);
        return ResponseEntity.ok((Object)taskData);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/taskData"}, method={RequestMethod.POST})
    public ResponseEntity<?> setTaskData(@RequestBody CalculationFieldTaskData taskData) {
        JwtSecurityUser user = this.getSecurityUser();
        UUID calculationId = taskData.getCalculationFieldId();
        boolean enabled = taskData.isEnabled();
        CalculationField calculationField = (CalculationField)this.calculationFieldService.findById(user, calculationId).orElseThrow(() -> new CalculationFieldNotFoundException(calculationId));
        TaskReference refreshTaskReference = new TaskReference(TaskReferencedEntityType.CALCULATION_FIELD_REFRESH, calculationId.toString());
        Task refreshTask = (Task)this.taskService.findTaskByReferencedEntity(user, refreshTaskReference).orElseThrow(() -> new TaskNotFoundException(refreshTaskReference));
        ZoneId zoneId = ZoneId.of(taskData.getTzName());
        long now = System.currentTimeMillis();
        TimeRange timeRange = taskData.getReprocessDatePickerConfig().buildStartEndPair(zoneId, now);
        SaveCalculationFieldToTbJob refreshJob = SaveCalculationFieldToTbJob.builder().calculationId(calculationId).reprocess(false).executionStartTs(timeRange.getStartTs()).executionEndTs(now).tzName(taskData.getTzName()).filterItems(taskData.getItemSet()).build();
        TaskSchedule refreshSchedule = this.taskService.makeSchedulingConfig(taskData.getRefreshTimeUnitCount(), taskData.getRefreshTimeUnit(), taskData.isRefreshTimeUnitTruncated(), taskData.getTzName());
        TaskConfig refreshTaskConfig = TaskConfig.builder().id(refreshTask.getId()).name(refreshTask.getName()).enabled(Boolean.valueOf(enabled)).schedule(refreshSchedule).reference(refreshTaskReference).job((TaskJob)refreshJob).build();
        this.taskService.updateTask(user, refreshTaskConfig);
        if (!enabled) {
            this.taskService.cancelExecutionsByTaskId(user, refreshTask.getId());
        }
        this.calculationFieldService.saveTaskData(taskData);
        this.calculationFieldService.updateEnabling(user, calculationField.getId(), enabled);
        return ResponseEntity.ok((Object)true);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/reprocess"}, method={RequestMethod.POST})
    public ResponseEntity<?> reprocess(@RequestBody CalculationFieldTaskData taskData) {
        JwtSecurityUser user = this.getSecurityUser();
        UUID calculationId = taskData.getCalculationFieldId();
        CalculationField calculationField = (CalculationField)this.calculationFieldService.findById(user, calculationId).orElseThrow(() -> new CalculationFieldNotFoundException(calculationId));
        ZoneId zoneId = ZoneId.of(taskData.getTzName());
        long now = System.currentTimeMillis();
        TimeRange timeRange = taskData.getReprocessDatePickerConfig().buildStartEndPair(zoneId, now);
        SaveCalculationFieldToTbJob reprocessJob = SaveCalculationFieldToTbJob.builder().calculationId(calculationId).reprocess(true).executionStartTs(timeRange.getStartTs()).executionEndTs(timeRange.getEndTs()).tzName(taskData.getTzName()).filterItems(taskData.getItemSet()).build();
        TaskReference reprocessTaskReference = new TaskReference(TaskReferencedEntityType.CALCULATION_FIELD_REPROCESS, calculationId.toString());
        Task reprocessTask = (Task)this.taskService.findTaskByReferencedEntity(user, reprocessTaskReference).orElseThrow(() -> new TaskNotFoundException(reprocessTaskReference));
        UUID executionId = this.taskService.runExecution(user, reprocessTask.getId(), (TaskJob)reprocessJob, true);
        return ResponseEntity.ok((Object)executionId);
    }
}

