/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.time.ZoneId;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.definition.entity.metadata.BusinessEntityFieldMetadata;
import org.thingsboard.trendz.domain.definition.entity.metadata.RangeConfig;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.metric.item.MetricExplorationGenericRequest;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.metadata.BusinessEntityFieldMetadataService;
import org.thingsboard.trendz.tools.DateTimeUtils;
import org.thingsboard.trendz.tools.UUIDUtils;

@RestController
@RequestMapping(value={"/apiTrendz/businessEntity/metadata/fields"})
public class BusinessEntityFieldMetadataController
extends BaseController {
    private final BusinessEntityFieldMetadataService entityFieldMetadataService;

    @Autowired
    public BusinessEntityFieldMetadataController(BusinessEntityFieldMetadataService entityFieldMetadataService) {
        this.entityFieldMetadataService = entityFieldMetadataService;
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{entityFieldId}/rangeConfig/{itemId}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<RangeConfig> getRangeConfigForField(@PathVariable(value="entityFieldId") String entityFieldIdStr, @PathVariable(value="itemId") String itemIdStr, @RequestBody MetricExplorationGenericRequest request) {
        UUID entityFieldId = UUIDUtils.parse((String)entityFieldIdStr);
        UUID itemId = UUIDUtils.parse((String)itemIdStr);
        DatePickerConfig datePickerConfig = request.getDatePickerConfig();
        ZoneId zoneId = DateTimeUtils.fromTzName((String)request.getTzName());
        JwtSecurityUser user = this.getSecurityUser();
        RangeConfig rangeConfig = this.entityFieldMetadataService.getRangeConfig(entityFieldId, user, datePickerConfig, zoneId, itemId);
        return ResponseEntity.ok((Object)rangeConfig);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{entityFieldId}/rangeConfig"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> saveRangeConfigForField(@PathVariable(value="entityFieldId") String entityFieldIdStr, @RequestBody RangeConfig rangeConfig) {
        UUID entityFieldId = UUIDUtils.parse((String)entityFieldIdStr);
        JwtSecurityUser user = this.getSecurityUser();
        this.entityFieldMetadataService.saveRangeConfig(entityFieldId, user, rangeConfig);
        return ResponseEntity.ok((Object)"");
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{entityFieldId}/rangeConfig"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<?> saveRangeConfigForField(@PathVariable(value="entityFieldId") String entityFieldIdStr) {
        UUID entityFieldId = UUIDUtils.parse((String)entityFieldIdStr);
        JwtSecurityUser user = this.getSecurityUser();
        this.entityFieldMetadataService.clearRangeConfig(entityFieldId, user);
        return ResponseEntity.ok((Object)"");
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{entityFieldId}/aggregation"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<FieldAggregation> getAggregationForField(@PathVariable(value="entityFieldId") String entityFieldIdStr) {
        UUID entityFieldId = UUIDUtils.parse((String)entityFieldIdStr);
        JwtSecurityUser user = this.getSecurityUser();
        FieldAggregation fieldAggregation = this.entityFieldMetadataService.getAggregation(entityFieldId, user);
        return ResponseEntity.ok((Object)fieldAggregation);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{entityFieldId}/aggregation/{aggregation}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> postAggregationForField(@PathVariable(value="entityFieldId") String entityFieldIdStr, @PathVariable(value="aggregation") String aggregation) {
        UUID entityFieldId = UUIDUtils.parse((String)entityFieldIdStr);
        FieldAggregation fieldAggregation = FieldAggregation.valueOf((String)aggregation);
        JwtSecurityUser user = this.getSecurityUser();
        this.entityFieldMetadataService.saveAggregation(entityFieldId, user, fieldAggregation);
        return ResponseEntity.ok((Object)"");
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{entityFieldId}/dateGrouping"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getDateGroupingForField(@PathVariable(value="entityFieldId") String entityFieldIdStr) {
        UUID entityFieldId = UUIDUtils.parse((String)entityFieldIdStr);
        JwtSecurityUser user = this.getSecurityUser();
        String dateGrouping = this.entityFieldMetadataService.getDateGrouping(entityFieldId, user);
        return ResponseEntity.ok((Object)dateGrouping);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{entityFieldId}/dateGrouping/{dateGrouping}"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> saveDatePickerConfigForField(@PathVariable(value="entityFieldId") String entityFieldIdStr, @PathVariable(value="dateGrouping") String dateGrouping) {
        UUID entityFieldId = UUIDUtils.parse((String)entityFieldIdStr);
        JwtSecurityUser user = this.getSecurityUser();
        this.entityFieldMetadataService.saveDateGrouping(entityFieldId, user, dateGrouping);
        return ResponseEntity.ok((Object)"");
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/{entityFieldId}/overview"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getOverviewParams(@PathVariable(value="entityFieldId") String entityFieldIdStr) {
        UUID entityFieldId = UUIDUtils.parse((String)entityFieldIdStr);
        JwtSecurityUser user = this.getSecurityUser();
        BusinessEntityFieldMetadata.Overview overview = this.entityFieldMetadataService.getOverview(entityFieldId, user);
        return ResponseEntity.ok((Object)overview);
    }
}

