/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.security.TrendzApiKeyAuthData;
import org.thingsboard.trendz.security.entity.AuthType;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.entity.SecurityUser;
import org.thingsboard.trendz.security.service.TokenExtractor;

public abstract class BaseController {
    @Autowired
    private TokenExtractor tokenExtractor;

    protected AuthType getAuthType() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return null;
        }
        if (authentication.getPrincipal() instanceof SecurityUser) {
            return AuthType.JWT_TOKEN;
        }
        if (authentication.getPrincipal() instanceof TrendzApiKeyAuthData) {
            return AuthType.TRENDZ_API_KEY;
        }
        return null;
    }

    protected String getJwtToken() {
        if (this.getAuthType() != AuthType.JWT_TOKEN) {
            throw new IllegalStateException("You aren't authorized to perform this operation!");
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return ((SecurityUser)authentication.getPrincipal()).getAuthToken().getToken();
    }

    protected JwtSecurityUser getSecurityUser() {
        return switch (1.$SwitchMap$org$thingsboard$trendz$security$entity$AuthType[this.getAuthType().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> this.tokenExtractor.extractUser(this.getJwtToken());
            case 2 -> ((TrendzApiKeyAuthData)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUser();
        };
    }
}

