/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.anomaly.AnomalyModel;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelLite;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelProperties;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelReport;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelSortingField;
import org.thingsboard.trendz.domain.anomaly.AnomalyModelTaskData;
import org.thingsboard.trendz.domain.anomaly.ModelFilteringField;
import org.thingsboard.trendz.exception.model.anomaly.AnomalyModelNotFoundByEntityFieldException;
import org.thingsboard.trendz.exception.task.TaskNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.ChangeEntityValidationInfo;
import org.thingsboard.trendz.service.model.anomaly.AnomalyModelService;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskService;
import org.thingsboard.trendz.service.task.job.AnomalyModelBuildJob;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;
import org.thingsboard.trendz.tools.PaginationPage;
import org.thingsboard.trendz.tools.UUIDUtils;

@RestController
@RequestMapping(value={"/apiTrendz/model/anomaly"})
public class AnomalyModelController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnomalyModelController.class);
    private final AnomalyModelService anomalyModelService;
    private final TaskService taskService;

    @Autowired
    public AnomalyModelController(AnomalyModelService anomalyModelService, TaskService taskService) {
        this.anomalyModelService = anomalyModelService;
        this.taskService = taskService;
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/all"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<PaginationPage<AnomalyModelLite>> getAllModelsLite(@RequestParam(value="page", required=false, defaultValue="0") String pageStr, @RequestParam(value="pageSize", required=false, defaultValue="1000") String pageSizeStr, @RequestParam(value="filter", required=false, defaultValue="") List<String> filter, @RequestParam(value="sort", required=false, defaultValue="createTs:desc") List<String> sort) {
        JwtSecurityUser user = this.getSecurityUser();
        int page = Integer.parseInt(pageStr);
        int pageSize = Integer.parseInt(pageSizeStr);
        List filteringFields = filter.stream().map(ModelFilteringField::fromString).collect(Collectors.toList());
        List sortingFields = sort.stream().map(AnomalyModelSortingField::fromString).collect(Collectors.toList());
        Page allLite = this.anomalyModelService.getAllLite(page, pageSize, user, filteringFields, sortingFields);
        PaginationPage allLitePage = new PaginationPage(allLite);
        return ResponseEntity.ok((Object)allLitePage);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/get/{modelId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> getModel(@PathVariable(value="modelId") String modelIdStr) {
        UUID modelId = UUIDUtils.parse((String)modelIdStr);
        JwtSecurityUser user = this.getSecurityUser();
        AnomalyModel anomalyModel = this.anomalyModelService.getModelByIdOrThrow(user, modelId, true);
        return ResponseEntity.ok((Object)anomalyModel);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/byEntityField/{entityFieldId}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getByEntityField(@PathVariable(value="entityFieldId") String entityFieldIdStr) {
        JwtSecurityUser user = this.getSecurityUser();
        UUID businessEntityFieldId = UUIDUtils.parse((String)entityFieldIdStr);
        AnomalyModelLite field = (AnomalyModelLite)this.anomalyModelService.findAnomalyModelByEntityFieldId(businessEntityFieldId, user, true).orElseThrow(() -> new AnomalyModelNotFoundByEntityFieldException(businessEntityFieldId));
        return ResponseEntity.ok((Object)field);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/dependedEntities/{fieldId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<?> findDependedEntities(@PathVariable(value="fieldId") String strModelId) {
        JwtSecurityUser user = this.getSecurityUser();
        UUID modelId = UUIDUtils.parse((String)strModelId);
        ChangeEntityValidationInfo dependedEntitiesInfo = this.anomalyModelService.findDependedEntities(user, modelId);
        return ResponseEntity.ok((Object)dependedEntitiesInfo);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> saveModel(@RequestBody AnomalyModelProperties properties) {
        AnomalyModelReport anomalyModelReport;
        JwtSecurityUser user = this.getSecurityUser();
        AnomalyModelReport anomalyModelReport2 = anomalyModelReport = properties.getModelId() == null ? this.anomalyModelService.createAnomalyModel(user, properties) : this.anomalyModelService.modifyAnomalyModel(user, properties);
        if (!anomalyModelReport.isRebuildRequired()) {
            return ResponseEntity.ok((Object)"");
        }
        TaskReference reference = new TaskReference(TaskReferencedEntityType.ANOMALY_MODEL_BUILD, anomalyModelReport.getAnomalyModel().getId().toString());
        Task task = (Task)this.taskService.findTaskByReferencedEntity(user, reference).orElseThrow(() -> new TaskNotFoundException(reference));
        AnomalyModelBuildJob job = AnomalyModelBuildJob.builder().modelId(anomalyModelReport.getAnomalyModel().getId()).build();
        UUID executionId = this.taskService.runExecution(user, task.getId(), (TaskJob)job, false);
        return ResponseEntity.ok((Object)executionId);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/delete/{modelId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<?> deleteModel(@PathVariable(value="modelId") String modelIdStr) {
        UUID modelId = UUIDUtils.parse((String)modelIdStr);
        this.anomalyModelService.deleteModel(this.getSecurityUser(), modelId);
        return ResponseEntity.ok((Object)"");
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/taskData/{modelId}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getTaskData(@PathVariable(value="modelId") String modelIdStr) {
        JwtSecurityUser user = this.getSecurityUser();
        UUID modelId = UUIDUtils.parse((String)modelIdStr);
        AnomalyModelTaskData taskData = this.anomalyModelService.getTaskData(user, modelId);
        return ResponseEntity.ok((Object)taskData);
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/taskData"}, method={RequestMethod.POST})
    public ResponseEntity<?> saveTaskData(@RequestBody AnomalyModelTaskData taskData) {
        JwtSecurityUser user = this.getSecurityUser();
        AnomalyModelTaskData result = this.anomalyModelService.saveTaskData(user, taskData, false);
        return ResponseEntity.ok((Object)result);
    }
}

