/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.controller;

import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.thingsboard.trendz.controller.BaseController;
import org.thingsboard.trendz.domain.alarm.AlarmRequest;
import org.thingsboard.trendz.exception.task.TaskNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.task.TaskJob;
import org.thingsboard.trendz.service.task.TaskService;
import org.thingsboard.trendz.service.task.job.AlarmRequestJob;
import org.thingsboard.trendz.service.task.model.Task;
import org.thingsboard.trendz.service.task.model.TaskReference;
import org.thingsboard.trendz.service.task.model.TaskReferencedEntityType;

@RestController
@RequestMapping(value={"/apiTrendz/alarm/"})
public class AlarmRequestController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlarmRequestController.class);
    private final TaskService taskService;

    @Autowired
    public AlarmRequestController(TaskService taskService) {
        this.taskService = taskService;
    }

    @PreAuthorize(value="hasAnyAuthority('TENANT_ADMIN', 'CUSTOMER_USER')")
    @RequestMapping(value={"/request"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<?> buildAlarmReportAsync(@RequestBody AlarmRequest alarmRequest) {
        JwtSecurityUser user = this.getSecurityUser();
        TaskReference reference = TaskReference.builder().type(TaskReferencedEntityType.ALARM_REQUEST).key(user.getTenantCustomerKey()).build();
        AlarmRequestJob job = AlarmRequestJob.builder().datePickerConfig(alarmRequest.getDatePickerConfig()).tzName(alarmRequest.getTzName()).build();
        Task task = (Task)this.taskService.findTaskByReferencedEntity(user, reference).orElseThrow(() -> new TaskNotFoundException(reference));
        UUID executionId = this.taskService.runExecution(user, task.getId(), (TaskJob)job, false);
        return ResponseEntity.ok((Object)executionId);
    }
}

