/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.config;

import jakarta.servlet.Filter;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.thingsboard.trendz.security.SkipPathRequestMatcher;
import org.thingsboard.trendz.security.filter.RefreshTokenProcessingFilter;
import org.thingsboard.trendz.security.filter.RestLoginProcessingFilter;
import org.thingsboard.trendz.security.filter.TokenAuthenticationProcessingFilter;
import org.thingsboard.trendz.security.handler.TrendzErrorResponseHandler;
import org.thingsboard.trendz.security.provider.JwtAuthenticationProvider;
import org.thingsboard.trendz.security.provider.RefreshTokenAuthenticationProvider;
import org.thingsboard.trendz.security.provider.TbAuthenticationProvider;
import org.thingsboard.trendz.security.provider.TrendzApiKeyAuthenticationProvider;
import org.thingsboard.trendz.security.service.TokenExtractor;

@Configuration
@EnableWebSecurity
@EnableMethodSecurity
public class SecurityConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityConfiguration.class);
    private static final String FORM_BASED_LOGIN_ENTRY_POINT = "/apiTrendz/publicApi/auth/login";
    private static final String TOKEN_REFRESH_ENTRY_POINT = "/apiTrendz/publicApi/auth/refreshToken";
    private static final String[] NON_TOKEN_BASED_AUTH_ENTRY_POINTS = new String[]{"/index.html", "/static/**", "/webjars/**", "/apiTrendz/publicApi/**"};
    private static final String TOKEN_BASED_AUTH_ENTRY_POINT = "/apiTrendz/**";
    private static final String WEBJARS_ENTRY_POINT = "/webjars/**";
    private final TbAuthenticationProvider tbAuthenticationProvider;
    private final JwtAuthenticationProvider jwtAuthenticationProvider;
    private final RefreshTokenAuthenticationProvider refreshTokenAuthenticationProvider;
    private final TrendzApiKeyAuthenticationProvider trendzApiKeyAuthenticationProvider;
    private final TokenExtractor tokenExtractor;
    private final AuthenticationSuccessHandler successHandler;
    private final TrendzErrorResponseHandler restAccessDeniedHandler;

    @Autowired
    public SecurityConfiguration(TbAuthenticationProvider tbAuthenticationProvider, JwtAuthenticationProvider jwtAuthenticationProvider, RefreshTokenAuthenticationProvider refreshTokenAuthenticationProvider, TrendzApiKeyAuthenticationProvider trendzApiKeyAuthenticationProvider, TokenExtractor tokenExtractor, AuthenticationSuccessHandler successHandler, TrendzErrorResponseHandler restAccessDeniedHandler) {
        this.tbAuthenticationProvider = tbAuthenticationProvider;
        this.jwtAuthenticationProvider = jwtAuthenticationProvider;
        this.refreshTokenAuthenticationProvider = refreshTokenAuthenticationProvider;
        this.trendzApiKeyAuthenticationProvider = trendzApiKeyAuthenticationProvider;
        this.tokenExtractor = tokenExtractor;
        this.successHandler = successHandler;
        this.restAccessDeniedHandler = restAccessDeniedHandler;
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity httpSecurity, RestLoginProcessingFilter restLoginProcessingFilter, TokenAuthenticationProcessingFilter tokenAuthenticationProcessingFilter, RefreshTokenProcessingFilter refreshTokenProcessingFilter) throws Exception {
        return (SecurityFilterChain)httpSecurity.headers(headers -> {
            headers.frameOptions(HeadersConfigurer.FrameOptionsConfig::disable);
            headers.cacheControl(HeadersConfigurer.CacheControlConfig::disable);
            headers.addHeaderWriter(this.resourcesCacheControlHeadersWriter());
        }).cors(cors -> cors.configurationSource(this.corsConfigurationSource())).csrf(AbstractHttpConfigurer::disable).exceptionHandling(Customizer.withDefaults()).sessionManagement(httpSecuritySessionManagementConfigurer -> httpSecuritySessionManagementConfigurer.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).authorizeHttpRequests(customizer -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)customizer.requestMatchers(new String[]{WEBJARS_ENTRY_POINT})).permitAll().requestMatchers(NON_TOKEN_BASED_AUTH_ENTRY_POINTS)).permitAll().requestMatchers(new String[]{TOKEN_BASED_AUTH_ENTRY_POINT})).authenticated().anyRequest()).permitAll()).exceptionHandling(customizer -> customizer.accessDeniedHandler((AccessDeniedHandler)this.restAccessDeniedHandler)).addFilterBefore((Filter)restLoginProcessingFilter, UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)tokenAuthenticationProcessingFilter, UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)refreshTokenProcessingFilter, UsernamePasswordAuthenticationFilter.class).build();
    }

    public HeaderWriter resourcesCacheControlHeadersWriter() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOriginPatterns(List.of("*"));
        configuration.setAllowedMethods(Arrays.asList("GET", "POST", "OPTIONS", "DELETE", "PUT", "PATCH"));
        configuration.setAllowedHeaders(List.of("*"));
        configuration.setAllowCredentials(Boolean.valueOf(true));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return source;
    }

    @Bean
    protected RestLoginProcessingFilter buildRestLoginProcessingFilter(AuthenticationManager authenticationManager) {
        RestLoginProcessingFilter filter = new RestLoginProcessingFilter(FORM_BASED_LOGIN_ENTRY_POINT, this.successHandler, (AuthenticationFailureHandler)this.restAccessDeniedHandler);
        filter.setAuthenticationManager(authenticationManager);
        return filter;
    }

    @Bean
    protected TokenAuthenticationProcessingFilter buildJwtTokenAuthenticationProcessingFilter(AuthenticationManager authenticationManager, SkipPathRequestMatcher skipPathRequestMatcher) {
        TokenAuthenticationProcessingFilter filter = new TokenAuthenticationProcessingFilter((AuthenticationFailureHandler)this.restAccessDeniedHandler, this.tokenExtractor, (RequestMatcher)skipPathRequestMatcher);
        filter.setAuthenticationManager(authenticationManager);
        return filter;
    }

    @Bean
    protected RefreshTokenProcessingFilter buildRefreshTokenProcessingFilter(AuthenticationManager authenticationManager) {
        RefreshTokenProcessingFilter filter = new RefreshTokenProcessingFilter(TOKEN_REFRESH_ENTRY_POINT, this.successHandler, (AuthenticationFailureHandler)this.restAccessDeniedHandler);
        filter.setAuthenticationManager(authenticationManager);
        return filter;
    }

    @Bean
    public AuthenticationManager authenticationManager() {
        return new ProviderManager(new AuthenticationProvider[]{this.tbAuthenticationProvider, this.jwtAuthenticationProvider, this.refreshTokenAuthenticationProvider, this.trendzApiKeyAuthenticationProvider});
    }

    @Bean
    public SkipPathRequestMatcher skipPathRequestMatcher() {
        List pathsToSkip = Stream.of(Arrays.stream(NON_TOKEN_BASED_AUTH_ENTRY_POINTS), Stream.of(FORM_BASED_LOGIN_ENTRY_POINT, WEBJARS_ENTRY_POINT, TOKEN_REFRESH_ENTRY_POINT)).flatMap(Function.identity()).toList();
        return new SkipPathRequestMatcher(pathsToSkip, TOKEN_BASED_AUTH_ENTRY_POINT);
    }
}

