/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.annotation.ComponentScan;

@EnableAutoConfiguration
@SpringBootConfiguration
@ComponentScan(value={"org.thingsboard.trendz.service.install"})
public class InstallHaproxyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstallHaproxyService.class);
    private static final String HAPROXY_CONFIG_FILE_PATH = "/etc/haproxy/haproxy.cfg";
    private static final Pattern FRONTEND_HTTPS_PART_REGEX = Pattern.compile("frontend https_in[\\s\\S]+?default_backend tb-backend");
    private static final Pattern DEFAULT_BACKEND_PART_REGEX = Pattern.compile("[\\s]+default_backend");
    private static final Pattern ACL_PART_REGEX = Pattern.compile(" acl[\\S\\ ]+[\\n]");
    private static final String ACL_PART_DATA = "\n\n  acl trendz_ui_resources path_beg /trendz/\n  acl trendz_back_resources path_beg /apiTrendz/";
    private static final String USING_TB_TRENDZ_DATA = "\n\n  use_backend tb-trendz if trendz_ui_resources || trendz_back_resources";
    private static final String TB_TRENDZ_DATA = "\nbackend tb-trendz\n  balance leastconn\n  option tcp-check\n  option log-health-checks\n  server tbTrendz1 127.0.0.1:8888 check inter 5s\n  http-request set-header X-Forwarded-Port %[dst_port]";

    public static void main(String[] args) {
        new InstallHaproxyService().installHaproxySettings();
    }

    public void installHaproxySettings() {
        try {
            System.out.println("HAProxy configuration process started");
            if (SystemUtils.IS_OS_LINUX) {
                boolean haproxyInstalled = this.checkHAProxyExistence();
                if (haproxyInstalled) {
                    System.out.println("HAProxy is installed!");
                    File haproxyConfigFile = new File(HAPROXY_CONFIG_FILE_PATH);
                    boolean existsHaproxyConfigFile = haproxyConfigFile.exists();
                    if (existsHaproxyConfigFile) {
                        Object configString = Files.readString(haproxyConfigFile.toPath());
                        String frontendHttpsPart = this.getSubstringByRegex((String)configString, FRONTEND_HTTPS_PART_REGEX);
                        if (frontendHttpsPart != null) {
                            int frontendPartStartIndex = ((String)configString).indexOf(frontendHttpsPart);
                            String backendPart = this.getSubstringByRegex(frontendHttpsPart, DEFAULT_BACKEND_PART_REGEX);
                            int backendPartStartIndex = frontendHttpsPart.indexOf(backendPart);
                            boolean doesAccessListsPresent = frontendHttpsPart.contains(" acl ");
                            boolean changed = false;
                            if (doesAccessListsPresent) {
                                if (((String)configString).contains(USING_TB_TRENDZ_DATA) && ((String)configString).contains(ACL_PART_DATA)) {
                                    System.out.println("Backend using and acl are already set.");
                                } else {
                                    changed = true;
                                    configString = this.insertString((String)configString, USING_TB_TRENDZ_DATA, frontendPartStartIndex + backendPartStartIndex);
                                    String aclPart = this.getSubstringByRegex(frontendHttpsPart, ACL_PART_REGEX);
                                    int aclPartStartIndex = frontendHttpsPart.indexOf(aclPart);
                                    configString = this.insertString((String)configString, ACL_PART_DATA, frontendPartStartIndex + aclPartStartIndex + aclPart.length());
                                }
                            } else if (((String)configString).contains("\n\n  acl trendz_ui_resources path_beg /trendz/\n  acl trendz_back_resources path_beg /apiTrendz/\n\n  use_backend tb-trendz if trendz_ui_resources || trendz_back_resources")) {
                                System.out.println("Backend using and acl are already set.");
                            } else {
                                changed = true;
                                configString = this.insertString((String)configString, "\n\n  acl trendz_ui_resources path_beg /trendz/\n  acl trendz_back_resources path_beg /apiTrendz/\n\n  use_backend tb-trendz if trendz_ui_resources || trendz_back_resources", frontendPartStartIndex + backendPartStartIndex);
                            }
                            if (((String)configString).contains(TB_TRENDZ_DATA)) {
                                System.out.println("Trendz backend is already set.");
                            } else {
                                changed = true;
                                configString = (String)configString + TB_TRENDZ_DATA;
                            }
                            if (changed) {
                                Files.writeString(haproxyConfigFile.toPath(), (CharSequence)configString, new OpenOption[0]);
                            }
                            System.out.println("HAProxy settings is configured successfully");
                        } else {
                            System.out.println("HAProxy config file does not contain necessary parts for correct modification!");
                        }
                    } else {
                        System.out.println("HAProxy config file does not exist!");
                    }
                } else {
                    System.out.println("HAProxy is NOT installed!");
                }
            } else {
                System.out.println("The current OS is not Linux, therefore it can not be proceed");
            }
            System.out.println("HAProxy configuration process finished");
            System.out.println("Install settings process finished");
        }
        catch (Exception e) {
            System.out.println("Installing HAProxy Settings was failed. Please, check configurations manually.");
            e.printStackTrace();
        }
    }

    private boolean checkHAProxyExistence() {
        String command = "dpkg -s haproxy";
        Pair result = this.executeCommand(command);
        List output = (List)result.getLeft();
        List error = (List)result.getRight();
        if (output.isEmpty() && !error.isEmpty()) {
            return false;
        }
        if (!output.isEmpty() && error.isEmpty()) {
            return true;
        }
        throw new IllegalStateException("The application can not to check HAProxy in the system");
    }

    private String getSubstringByRegex(String where, Pattern pattern) {
        Matcher matcher = pattern.matcher(where);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group();
    }

    private String insertString(String where, String what, int index) {
        String before = where.substring(0, index);
        String after = where.substring(index);
        return before + what + after;
    }

    private Pair<List<String>, List<String>> executeCommand(String command) {
        try {
            String line;
            Process process = Runtime.getRuntime().exec(command);
            process.waitFor();
            BufferedReader inputReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            ArrayList<String> inputLines = new ArrayList<String>();
            ArrayList<String> errorLines = new ArrayList<String>();
            while ((line = inputReader.readLine()) != null) {
                inputLines.add(line);
            }
            while ((line = errorReader.readLine()) != null) {
                errorLines.add(line);
            }
            return Pair.of(inputLines, errorLines);
        }
        catch (Exception e) {
            throw new IllegalStateException("There is error during shell command execution.", e);
        }
    }
}

