let $scope;
let $sce;
let userService;
let $timeout;
let iframe;
let startTime = 0;
let endTime = 0;
let settings;

self.actionSources = function () {
  return {
    'rowClick': {
      name: 'widget-action.row-click',
      multiple: false
    }
  };
}

self.onInit = function () {
  $scope = self.ctx.$scope;
  $scope.ctx = self.ctx;

  settings = JSON.parse(JSON.stringify(self.ctx.settings)) || {};
  $scope.originalIframeUrl = settings.viewUrl;

  if (settings.useDashboardTimeWindow) {
    self.ctx.dashboard.dashboardTimewindowChangedSubject.subscribe(ll => {
        updateTimeRange();
    });
    updateTimeRange();
  } else {
    buildViewUrl();
  }

  listenForChildMsgs();
  self.onResize();
}

self.onDataUpdated = function () {

}

self.onResize = function () {

}

self.onDestroy = function () {

}

function buildViewUrl() {
  $scope.tokenParam = getTokenUrlParams();
  if ($scope.originalIframeUrl && $scope.originalIframeUrl !== 'http://localhost:4200/viewMode/{id}/') {
    $scope.finalIframeUrl = $scope.originalIframeUrl + `?${$scope.tokenParam}`;
  }
  if (settings.useDashboardTimeWindow && startTime !== 0 && endTime !== 0) {
    $scope.finalIframeUrl = $scope.finalIframeUrl + '&startTs=' + startTime + "&endTs=" + endTime;
  }

  setTimeout(() => {
    iframe = self.ctx.$container.find('iframe');
    iframe.attr('src', $scope.finalIframeUrl);
  }, 10);
}

function getTokenUrlParams() {
  let jwtToken = localStorage.getItem('jwt_token');
  if (jwtToken) {
    jwtToken = jwtToken.replaceAll('"', "");
  }

  let refrToekn = localStorage.getItem('refresh_token');
  if (refrToekn) {
    refrToekn = refrToekn.replaceAll('"', "");
  }

  return 'token=' + jwtToken + '&refreshToken=' + refrToekn;
}

function updateTimeRange() {
  let timeWindow = $scope.ctx.dashboard.dashboardTimewindow;
  if (timeWindow.realtime) {
    startTime = Date.now() - timeWindow.realtime.timewindowMs;
    endTime = Date.now();
  } else if (timeWindow.history) {
    if (timeWindow.history.fixedTimewindow && timeWindow.history.historyType === 1) {
      startTime = timeWindow.history.fixedTimewindow.startTimeMs;
      endTime = timeWindow.history.fixedTimewindow.endTimeMs;
    } else if (timeWindow.history.timewindowMs && timeWindow.history.historyType === 0) {
      startTime = Date.now() - timeWindow.history.timewindowMs;
      endTime = Date.now();
    }
  }
  buildViewUrl();
}

function listenForChildMsgs() {
  window.addEventListener('message', function (e) {
    if (e.data && e.data.type === 'trndChildMsgConfirm') {
      console.log('confirmation from Child iFrame received', e.data);
      if (postCommandId === e.data.cmdId) {
        transferFinished = true;
      }
    } else if (e.data && e.data.type === 'entityItemSelected') {
      let rowClickDescriptors = $scope.ctx.actionsApi.getActionDescriptors('rowClick');
      console.log('child entity selected', e.data, rowClickDescriptors);
      if (rowClickDescriptors.length) {
        let entityId = e.data.innerData.entityId;
        let entityName = e.data.innerData.entityName;
        if (entityId) {
          setTimeout(() => {
            console.log('descriptor called', entityId, entityName);
            $scope.ctx.actionsApi.handleWidgetAction(null, rowClickDescriptors[0], entityId, entityName);
          }, 0);
        }
      }
    } else {
      console.log('child strange', e.data);
    }
  });
}

function getDescendantProp(obj, path) {
  return path.split('.').reduce((acc, part) => acc && acc[part], obj
)
}
