let $scope;
let $sce;
let userService;
let $timeout;
let settings;
let startTime = 0;
let endTime = 0;

let prevFilterValue;

let usePostMessage = false;
let transferFinished = false;
let postCommandId = 0;
let skipFirstUpdate = false;

self.onInit = function() {
  $scope = self.ctx.$scope;
  $scope.ctx = self.ctx;

  settings = JSON.parse(JSON.stringify(self.ctx.settings)) || {};
  $scope.originalIframeUrl = settings.viewUrl;
  $scope.filterName = settings.filterName;

  if (settings.useDashboardTimeWindow) {
    self.ctx.dashboard.dashboardTimewindowChangedSubject.subscribe(ll => {
      refreshData();
  });
  }

  listenForChildMsgs();
  self.onResize();
  //self.onDataUpdated();
}

self.actionSources = function() {
  return {
    'rowClick': {
      name: 'widget-action.row-click',
      multiple: false
    }
  };
}

self.onDataUpdated = function() {
  $scope.filterValue = readFilterValues();

  if(prevFilterValue === $scope.filterValue) {
    return;
  }
  prevFilterValue = $scope.filterValue;

  refreshData();

}

self.onResize = function() {

}

self.onDestroy = function() {

}

function refreshData() {
  if($scope.originalIframeUrl === 'http://localhost:4200/viewMode/{id}/') {
    return;
  }

  $scope.filterValue = readFilterValues();

  prevFilterValue = $scope.filterValue;

  updateTimeRange();
  buildViewUrl();

  setTimeout(() => {}, 0);
}

function buildViewUrl() {
  $scope.additionalParams = '';
  let filterObj;
  if ($scope.filterValue && $scope.filterValue !== 'Unresolved') {
    if(usePostMessage) {
      postCommandId = Math.random() * (1000);
      $scope.additionalParams = 'postFilter=' + postCommandId + '&';
      console.log('new view URL', postCommandId);
      filterObj = {};
      filterObj[$scope.filterName] = $scope.filterValue;
    } else {
      $scope.additionalParams = `${$scope.filterName}=${$scope.filterValue}&`;
    }
  }

  $scope.tokenParam = getTokenUrlParams();
  if($scope.originalIframeUrl && $scope.originalIframeUrl !== 'http://localhost:4200/viewMode/{id}/') {
    $scope.finalIframeUrl = $scope.originalIframeUrl + `?${$scope.additionalParams}${$scope.tokenParam}`;
  }
  if (settings.useDashboardTimeWindow && startTime !== 0 && endTime !== 0) {
    $scope.finalIframeUrl = $scope.finalIframeUrl + '&startTs=' + startTime + "&endTs=" + endTime;
  }

  setTimeout(() => {
    iframe = self.ctx.$container.find('iframe');
  iframe.attr('src',$scope.finalIframeUrl);
}, 10);

  transferFinished = false;
  console.log('buildViewUrl');
  if(filterObj && usePostMessage) {
    sendDataToiFrame(filterObj, 100);
  }
  if(settings.serverAliasResove) {
    let alias = self.ctx.defaultSubscription.configuredDatasources[0].entityFilter;
    sendDataToiFrame(alias, 100);
  }
}

function listenForChildMsgs() {
  window.addEventListener('message', function(e) {
    if (e.data && e.data.type === 'trndChildMsgConfirm') {
      console.log('confirmation from Child iFrame received', e.data);
      if(postCommandId === e.data.cmdId) {
        transferFinished = true;
      }
    } else if(e.data && e.data.type === 'entityItemSelected') {
      let rowClickDescriptors = $scope.ctx.actionsApi.getActionDescriptors('rowClick');
      console.log('child entity selected', e.data, rowClickDescriptors);
      if (rowClickDescriptors.length) {
        let entityId = e.data.innerData.entityId;
        let entityName = e.data.innerData.entityName;
        if (entityId) {
          setTimeout(() => {
            console.log('descriptor called', entityId, entityName);
          $scope.ctx.actionsApi.handleWidgetAction(null, rowClickDescriptors[0], entityId, entityName);
        }, 0);
        }
      }
    } else {
      console.log('child strange', e.data);
    }
  });
}

function sendDataToiFrame(innerData, timeout) {
  let msg = {innerData: innerData, type:'trndParentMsg', cmdId: postCommandId};
  setTimeout(() => {
    if(transferFinished) {
      return;
    }
    iframe = self.ctx.$container.find('iframe');
  if(iframe && iframe[0] && iframe[0].contentWindow) {
    iframe[0].contentWindow.postMessage(msg, '*');
    // transferFinished = true;
    console.log('send finished ', +postCommandId, iframe);
    sendDataToiFrame(innerData, 200);
  } else {
    console.log('repeat send', iframe);
    sendDataToiFrame(innerData, 100);
  }
}, timeout);
}

function getTokenUrlParams() {
  let jwtToken = localStorage.getItem('jwt_token');
  if(jwtToken) {
    jwtToken = jwtToken.replaceAll('"', "");
  }

  let refrToekn = localStorage.getItem('refresh_token');
  if(refrToekn) {
    refrToekn = refrToekn.replaceAll('"', "");
  }

  return 'token=' + jwtToken + '&refreshToken=' + refrToekn;
}

function readFilterValues() {
  if(self.ctx && self.ctx.defaultSubscription && self.ctx.defaultSubscription.data && self.ctx.defaultSubscription.data.length > 0) {
    let filterValues = [];
    for(let i = 0; i<self.ctx.defaultSubscription.data.length; i++ ) {
      let value = getDescendantProp(self.ctx.defaultSubscription.data[i], 'data.0.1');
      if (value && value !== 'Unresolved') {
        filterValues.push(value);
      }
    }
    if(filterValues.length) {
      if(filterValues.length > 50) {
        usePostMessage = true;
      }
      return filterValues.join("~");
    }
    usePostMessage = false;
  } else {
    console.log('trndz filter data blank', self.ctx.defaultSubscription);
    usePostMessage = false;
    return null;
  }
}

function updateTimeRange() {
  let timeWindow = $scope.ctx.dashboard.dashboardTimewindow;
  if (timeWindow.realtime) {
    startTime = Date.now() - timeWindow.realtime.timewindowMs;
    endTime = Date.now();
  } else if (timeWindow.history) {
    if (timeWindow.history.fixedTimewindow && timeWindow.history.historyType === 1) {
      startTime = timeWindow.history.fixedTimewindow.startTimeMs;
      endTime = timeWindow.history.fixedTimewindow.endTimeMs;
    } else if (timeWindow.history.timewindowMs && timeWindow.history.historyType === 0) {
      startTime = Date.now() - timeWindow.history.timewindowMs;
      endTime = Date.now();
    }
  }
}

function getDescendantProp(obj, path) {
  return path.split('.').reduce((acc, part) => acc && acc[part], obj)
}
