@ECHO OFF

setlocal ENABLEEXTENSIONS

@ECHO Detecting Java version installed.
:CHECK_JAVA
for /f tokens^=2-5^ delims^=.-_^" %%j in ('java -fullversion 2^>^&1') do set "jver=%%j%%k"
@ECHO CurrentVersion %jver%

if %jver% EQU 18 GOTO JAVA_18_INSTALLED

if %jver% EQU 110 GOTO JAVA_110_INSTALLED

if %jver% EQU 170 GOTO JAVA_17_INSTALLED

GOTO JAVA_NOT_INSTALLED

:JAVA_18_INSTALLED

@ECHO Java 1.8 found!

GOTO INSTALL_TRENDZ

:JAVA_110_INSTALLED

@ECHO Java 11 found!

GOTO INSTALL_TRENDZ

:JAVA_17_INSTALLED

@ECHO Java 17 found!

GOTO INSTALL_TRENDZ

:INSTALL_TRENDZ

@ECHO Installing Trendz ...

SET loadDemo=false

if "%1" == "--loadDemo" (
    SET loadDemo=true
)

SET BASE=%~dp0
SET LOADER_PATH=%BASE%\conf,%BASE%\extensions
SET jarfile=%BASE%\lib\trendz.jar
SET installDir=%BASE%\data

PUSHD "%BASE%\conf"

java -cp "%jarfile%" -Dloader.main=org.thingsboard.trendz.TrendzInstall^
                    -Dinstall.data_dir="%installDir%"^
                    -Dinstall.load_demo=%loadDemo%^
                    -Dspring.jpa.hibernate.ddl-auto=none^
                    -Dinstall.upgrade=false^
                    -Dlogging.config="%BASE%\install\logback.xml"^
                    org.springframework.boot.loader.launch.PropertiesLauncher

if errorlevel 1 (
   @echo Trendz installation failed!
   POPD
   exit /b %errorlevel%
)
POPD

"%BASE%"trendz.exe install

@ECHO Trendz installed successfully!

GOTO END

:JAVA_NOT_INSTALLED
@ECHO Java 11 is not installed. Only Java 11 is supported
@ECHO Please go to https://adoptopenjdk.net/index.html and install Java 11. Then retry installation.
PAUSE
GOTO END

:END
