/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.tools.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

/*
 * Exception performing whole class analysis ignored.
 */
public final class JsonUtils {
    private static final ObjectMapper objectMapper;

    public static <T> void registerDeserializer(Class<T> clazz, JsonDeserializer<T> deserializer) {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(clazz, deserializer);
        objectMapper.registerModule((Module)module);
    }

    public static <T> String toJson(T data) {
        try {
            return objectMapper.writeValueAsString(data);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Json error during serializing, class:" + data.getClass().getName(), e);
        }
    }

    public static <T> T fromJson(String jsonData, JavaType type) {
        try {
            return (T)objectMapper.readValue(jsonData, type);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Json error during deserializing, class:" + type.getTypeName(), e);
        }
    }

    public static <T> T fromJson(String jsonData, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(jsonData, clazz);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Json error during deserializing, class:" + clazz.getName(), e);
        }
    }

    public static <T> T fromJson(String jsonData, TypeReference<T> tTypeReference) {
        try {
            return (T)objectMapper.readValue(jsonData, tTypeReference);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Json error during deserializing, class:" + tTypeReference.getType().getTypeName(), e);
        }
    }

    public static <T> T fromNodeToObject(JsonNode node, Class<T> clazz) {
        try {
            return (T)objectMapper.treeToValue((TreeNode)node, clazz);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Json error during deserializing, class:" + clazz.getName(), e);
        }
    }

    public static String fromNodeToRaw(JsonNode node) {
        try {
            return objectMapper.writeValueAsString((Object)node);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Json error during serializing", e);
        }
    }

    public static JsonNode toNodeFromObject(Object obj) {
        return objectMapper.valueToTree(obj);
    }

    public static JsonNode toNodeFromRaw(String jsonData) {
        try {
            return objectMapper.readTree(jsonData);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Json error during reading tree.", e);
        }
    }

    public static JsonNode sortJsonNode(JsonNode node) {
        if (node.isObject()) {
            ObjectNode sorted = objectMapper.createObjectNode();
            ArrayList fieldNames = new ArrayList();
            node.fieldNames().forEachRemaining(fieldNames::add);
            Collections.sort(fieldNames);
            for (String field : fieldNames) {
                sorted.set(field, JsonUtils.sortJsonNode((JsonNode)node.get(field)));
            }
            return sorted;
        }
        if (node.isArray()) {
            ArrayList<JsonNode> nodes = new ArrayList<JsonNode>();
            node.forEach(n -> nodes.add(JsonUtils.sortJsonNode((JsonNode)n)));
            nodes.sort(Comparator.comparing(JsonNode::toString));
            ArrayNode sortedArr = objectMapper.createArrayNode();
            nodes.forEach(arg_0 -> ((ArrayNode)sortedArr).add(arg_0));
            return sortedArr;
        }
        return node;
    }

    public static <T> String toCanonicalJson(T data) {
        JsonNode tree = objectMapper.valueToTree(data);
        JsonNode sorted = JsonUtils.sortJsonNode((JsonNode)tree);
        try {
            return objectMapper.writeValueAsString((Object)sorted);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Can't serialize sorted JSON", e);
        }
    }

    private JsonUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    static {
        StreamReadConstraints.overrideDefaultStreamReadConstraints((StreamReadConstraints)StreamReadConstraints.builder().maxStringLength(Integer.MAX_VALUE).build());
        objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.enable(new JsonParser.Feature[]{JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS.mappedFeature()});
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        objectMapper.registerModule((Module)new Jdk8Module());
    }
}

