/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.tools;

import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

/*
 * Exception performing whole class analysis ignored.
 */
public class DonReactive {
    private static final Logger log = LoggerFactory.getLogger(DonReactive.class);
    private static final long TIMEOUT_MILLISECONDS = 300000L;
    private static final Scheduler BLOCKING_SCHEDULER = Schedulers.newBoundedElastic((int)100, (int)60, (String)"don-reactive-blocking");

    public static <T> T block(Mono<T> publisher) {
        return (T)DonReactive.block(publisher, (Duration)Duration.ofMillis(300000L));
    }

    public static <T> T block(Mono<T> publisher, Duration timeout) {
        try {
            AtomicReference<Object> resultRef = new AtomicReference<Object>(null);
            AtomicReference<Object> exceptionRef = new AtomicReference<Object>(null);
            CountDownLatch latch = new CountDownLatch(1);
            Disposable disposable = Mono.just((Object)Boolean.TRUE).subscribeOn(BLOCKING_SCHEDULER).publishOn(BLOCKING_SCHEDULER).doOnNext(o2 -> DonReactive.callbackStart()).flatMap(o -> publisher).timeout(timeout).doOnCancel(() -> {
                DonReactive.callbackCancel();
                latch.countDown();
                DonReactive.callbackComplete();
            }).subscribe(result -> {
                resultRef.set(result);
                DonReactive.callbackFinish((Object)result);
            }, throwable -> {
                exceptionRef.set(throwable);
                DonReactive.callbackFailed((Throwable)throwable);
                latch.countDown();
                DonReactive.callbackComplete();
            }, () -> {
                latch.countDown();
                DonReactive.callbackComplete();
            }, subscription -> subscription.request(1L));
            if (!latch.await(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("Failed to process reactive stream: timeout");
            }
            if (exceptionRef.get() != null) {
                throw (Throwable)exceptionRef.get();
            }
            if (resultRef.get() == null) {
                throw new Exception("Failed to process reactive stream: empty result");
            }
            return resultRef.get();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    private static void callbackStart() {
        log.debug("callbackStart");
    }

    private static <T> void callbackFinish(T result) {
        log.debug("callbackFinish");
    }

    private static void callbackFailed(Throwable throwable) {
        log.debug("callbackFailed");
    }

    private static void callbackCancel() {
        log.debug("callbackCancel");
    }

    private static void callbackComplete() {
        log.debug("callbackComplete");
    }
}

