/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.tools;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import org.apache.commons.lang3.NotImplementedException;
import org.thingsboard.trendz.tools.DateTimeUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class DateTimeUtils {
    public static final long MIN_TS = -30610224000000L;
    public static final long MAX_TS = 32503680000000L;

    public static ZoneId fromTzName(String tzName) {
        try {
            return tzName == null ? ZoneId.systemDefault() : ZoneId.of(tzName);
        }
        catch (Exception e) {
            return ZoneId.systemDefault();
        }
    }

    public static String toTzName(ZoneId zoneId) {
        return "Europe/Kiev".equals(zoneId.toString()) ? "Europe/Kyiv" : zoneId.toString();
    }

    public static ZonedDateTime fromTs(long ts) {
        return DateTimeUtils.fromTs((long)ts, (ZoneId)ZoneId.systemDefault());
    }

    public static ZonedDateTime fromTs(long ts, ZoneId zoneId) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(ts), zoneId);
    }

    public static long toTs(ZonedDateTime zonedDateTime) {
        return zonedDateTime.toInstant().toEpochMilli();
    }

    public static ZonedDateTime min(ZonedDateTime d1, ZonedDateTime d2) {
        return d1.isBefore(d2) ? d1 : d2;
    }

    public static ZonedDateTime max(ZonedDateTime d1, ZonedDateTime d2) {
        return d1.isBefore(d2) ? d2 : d1;
    }

    public static int getOffsetInMilliseconds(ZoneId zoneId) {
        ZonedDateTime nowInZone = ZonedDateTime.now(zoneId);
        ZoneOffset offset = nowInZone.getOffset();
        int secondsOffset = offset.getTotalSeconds();
        return secondsOffset * 1000;
    }

    public static ZonedDateTime extendedTruncateTo(ZonedDateTime date, ChronoUnit chronoUnit) {
        return switch (1.$SwitchMap$java$time$temporal$ChronoUnit[chronoUnit.ordinal()]) {
            case 1 -> date.truncatedTo(ChronoUnit.DAYS).with(ChronoField.DAY_OF_WEEK, 1L);
            case 2 -> date.truncatedTo(ChronoUnit.DAYS).withDayOfMonth(1);
            case 3 -> date.truncatedTo(ChronoUnit.DAYS).withDayOfYear(1);
            case 4, 5, 6, 7 -> throw new NotImplementedException("Not implemented for time unit: " + String.valueOf(chronoUnit));
            case 8 -> throw new IllegalArgumentException("Impossible!");
            default -> date.truncatedTo(chronoUnit);
        };
    }

    public static long extendedTruncateTo(long ts, ZoneId zoneId, ChronoUnit chronoUnit) {
        return DateTimeUtils.toTs((ZonedDateTime)DateTimeUtils.extendedTruncateTo((ZonedDateTime)DateTimeUtils.fromTs((long)ts, (ZoneId)zoneId), (ChronoUnit)chronoUnit));
    }

    public static Duration toDuration(ZonedDateTime referenceData, long unitCount, ChronoUnit unit) {
        if (unit.isDurationEstimated()) {
            if (referenceData == null) {
                throw new IllegalArgumentException("For estimated duration the reference data is needed!");
            }
            ZonedDateTime startDate = DateTimeUtils.extendedTruncateTo((ZonedDateTime)referenceData, (ChronoUnit)unit);
            ZonedDateTime endDate = startDate.plus(unitCount, unit);
            return Duration.ofMillis(DateTimeUtils.toTs((ZonedDateTime)endDate) - DateTimeUtils.toTs((ZonedDateTime)startDate));
        }
        return Duration.of(unitCount, unit);
    }

    public static long fromDuration(ZonedDateTime referenceData, Duration duration, ChronoUnit unit) {
        if (unit.isDurationEstimated()) {
            if (referenceData == null) {
                throw new IllegalArgumentException("For estimated duration the reference data is needed!");
            }
            ZonedDateTime startDate = DateTimeUtils.extendedTruncateTo((ZonedDateTime)referenceData, (ChronoUnit)unit);
            ZonedDateTime endDate = startDate.plus(duration);
            return DateTimeUtils.toTs((ZonedDateTime)endDate) - DateTimeUtils.toTs((ZonedDateTime)startDate);
        }
        return switch (1.$SwitchMap$java$time$temporal$ChronoUnit[unit.ordinal()]) {
            case 9 -> duration.toDays();
            case 10 -> duration.toHours();
            case 11 -> duration.toMinutes();
            case 12 -> duration.getSeconds();
            case 13 -> duration.toMillis();
            case 14 -> duration.toMillis() * 1000L;
            case 15 -> duration.toNanos();
            default -> throw new UnsupportedOperationException("Unsupported unit: " + String.valueOf(unit));
        };
    }

    private DateTimeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

