/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.tools;

import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.exception.service.definition.BusinessEntityNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;

public final class BusinessEntityUtils {
    public static BusinessEntityField findNameField(BusinessEntity businessEntity, JwtSecurityUser user) {
        return businessEntity.getFields().stream().filter(field -> field.getQuery().getQueryType() == FieldQueryType.ENTITY_NAME).findAny().orElseThrow(() -> new BusinessEntityNotFoundException(businessEntity.getId(), user.getTenantId()));
    }

    private BusinessEntityUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

