/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.subscription;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.dao.system.TrendzLicenceKeyDao;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.service.DataEncryptor;
import org.thingsboard.trendz.service.provider.cache.CacheConfigurationName;
import org.thingsboard.trendz.service.provider.cache.CacheService;
import org.thingsboard.trendz.subscription.CompositeSubscriptionService;
import org.thingsboard.trendz.subscription.SubscriptionState;
import org.thingsboard.trendz.subscription.SubscriptionType;
import org.thingsboard.trendz.subscription.TrendzLicenceInfo;

@Service
public class LicenceService {
    private static final Logger log = LoggerFactory.getLogger(LicenceService.class);
    private final CompositeSubscriptionService compositeSubscriptionService;
    private final TrendzLicenceKeyDao trendzLicenceKeyDao;
    private final DataEncryptor dataEncryptor;
    private final Cache subscriptionTypeCache;
    private final SubscriptionType testSubscriptionType;

    @Autowired
    public LicenceService(CompositeSubscriptionService compositeSubscriptionService, TrendzLicenceKeyDao trendzLicenceKeyDao, DataEncryptor dataEncryptor, CacheService cacheService, @Value(value="${license.testSubscription}") SubscriptionType testSubscriptionType) {
        this.compositeSubscriptionService = compositeSubscriptionService;
        this.trendzLicenceKeyDao = trendzLicenceKeyDao;
        this.dataEncryptor = dataEncryptor;
        this.subscriptionTypeCache = cacheService.getCache(CacheConfigurationName.subscriptionTypeCacheName);
        this.testSubscriptionType = testSubscriptionType;
    }

    public TrendzLicenceInfo provideLicenceInfo(JwtSecurityUser user) {
        SubscriptionState subscriptionState = this.compositeSubscriptionService.getSubscriptionState(user);
        boolean valid = subscriptionState.isValid();
        String name = subscriptionState.getName();
        return TrendzLicenceInfo.builder().isValid(valid).subscriptionType(name).subscriptionStartTimestamp(0L).subscriptionEndTimestamp(-1L).build();
    }

    public SubscriptionType getSubscriptionType(JwtSecurityUser user) {
        return (SubscriptionType)this.subscriptionTypeCache.get((Object)user, () -> {
            SubscriptionState subscriptionState = this.compositeSubscriptionService.getSubscriptionState(user);
            return subscriptionState.getType();
        });
    }
}

