/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.subscription;

import jakarta.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.service.AuthenticationService;
import org.thingsboard.trendz.service.customize.UserManagementService;
import org.thingsboard.trendz.service.provider.TbAssetService;
import org.thingsboard.trendz.service.provider.TbDeviceService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.subscription.BaseSubscriptionService;
import org.thingsboard.trendz.subscription.CloudLicenseChecker;
import org.thingsboard.trendz.subscription.SubscriptionService;
import org.thingsboard.trendz.subscription.SubscriptionState;

@Component
@Profile(value={"!install"})
public class CompositeSubscriptionService
implements SubscriptionService {
    private static final Logger log = LoggerFactory.getLogger(CompositeSubscriptionService.class);
    private final SubscriptionService subscriptionService;

    @Autowired
    public CompositeSubscriptionService(@Value(value="${deployment.cloud}") boolean cloud, @Value(value="${license.secret}") String licenseSecret, @Value(value="${license.instance_data_file:trndz-instance-license.data}") String instanceDataFilePath, TbAssetService assetService, TbDeviceService deviceService, UserManagementService userManagementService, AuthenticationService authenticationService, TbRestDataSource tbRestDataSource) {
        this.subscriptionService = cloud ? new CloudLicenseChecker(userManagementService, authenticationService, tbRestDataSource) : new BaseSubscriptionService(licenseSecret, instanceDataFilePath, assetService, deviceService, authenticationService, userManagementService);
    }

    @PreDestroy
    public void stop() {
        this.subscriptionService.stop();
    }

    public SubscriptionState getSubscriptionState(JwtSecurityUser securityUser) {
        return this.subscriptionService.getSubscriptionState(securityUser);
    }
}

