/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.cache.CachedTelemetry;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.cache.CachedTelemetryService;
import org.thingsboard.trendz.service.sql.SqlValueLoader;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import reactor.core.publisher.Mono;

@Service
public class TelemetryCachePreloader {
    private static final Logger log = LoggerFactory.getLogger(TelemetryCachePreloader.class);
    @Autowired
    private CachedTelemetryService cachedTelemetryService;
    @Autowired
    private SqlValueLoader sqlValueLoader;

    public Mono<Set<Item>> preloadCache(Set<Item> collectedItems, ViewRequest request, ViewField viewField, BusinessEntity businessEntity, BusinessEntityField entityField, ViewContext ctx) {
        if (BusinessEntityType.EXTERNAL.equals((Object)businessEntity.getQuery().getEntityType())) {
            this.sqlValueLoader.preloadExternalValues(businessEntity, request, ctx);
        }
        if (!request.isUsePersistedCacheTelemetry() || !CachedTelemetryService.isPossibleToUseTelemetryCache((ViewRequest)request, (ViewField)viewField, (BusinessEntityField)entityField)) {
            return Mono.just(collectedItems);
        }
        Set itemIds = collectedItems.stream().map(Item::getId).filter(id -> !ctx.getPreloadedCache().containsCache(viewField, id)).collect(Collectors.toSet());
        long startTs = request.getStartTs(viewField);
        long endTs = request.getEndTs(viewField);
        this.cachedTelemetryService.validateNeededTimeRangeOfCache(startTs, endTs, request.getZoneId(), request.getCachingDateAggregationType());
        return this.cachedTelemetryService.loadAllCompatibleCachedTelemetry(itemIds, startTs, endTs, viewField, request.getCachingDateAggregationType()).map(cachedTelemetryList -> {
            for (CachedTelemetry cache : cachedTelemetryList) {
                ctx.getPreloadedCache().addCache(viewField, cache.getItemId(), cache);
            }
            return collectedItems;
        });
    }
}

