/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.DataCell;
import org.thingsboard.trendz.domain.runtime.DataRow;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.service.aggregation.DateAggregationGroup;
import org.thingsboard.trendz.service.aggregation.DateAggregationKey;
import org.thingsboard.trendz.service.aggregation.DateAggregationValue;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.AggregatedValue;
import org.thingsboard.trendz.service.view.proto.FieldState;
import org.thingsboard.trendz.service.view.proto.Row;
import org.thingsboard.trendz.service.view.proto.RowBuilder;
import org.thingsboard.trendz.service.view.proto.ViewRequest;

public class RowBuilder {
    private static final Logger log = LoggerFactory.getLogger(RowBuilder.class);
    private List<Row> rows = new CopyOnWriteArrayList();

    public RowBuilder(Row initialRow) {
        this.rows.add(initialRow);
    }

    public List<Row> getAllRows() {
        return new ArrayList<Row>(this.rows);
    }

    public void addRow(Row row) {
        this.rows.add(row);
    }

    public void addRows(List<Row> rows) {
        this.rows.addAll(rows);
    }

    public List<DataRow> build(ViewRequest request, ViewContext ctx) {
        ArrayList result = Lists.newArrayList();
        for (Row row : this.rows) {
            DataRow dataRow = new DataRow(null, new ArrayList());
            ArrayList<DayAggregationBucket> dayGroups = new ArrayList<DayAggregationBucket>();
            for (UUID viewFieldId : row.getFieldStates().keySet()) {
                FieldState fieldState = (FieldState)row.getFieldStates().get(viewFieldId);
                AggregatedValue aggValue = fieldState.getValue();
                ViewField viewField = row.getOrderedFields().stream().filter(vf -> vf.getId().equals(viewFieldId)).findAny().orElseThrow();
                if (viewField.isMissedRelationField() || viewField.isHidden() || aggValue == null) continue;
                UUID rowClickEntityId = request.getRowClickEntityId();
                if (rowClickEntityId != null && rowClickEntityId.equals(viewField.getBusinessEntityId())) {
                    Set itemList;
                    if (aggValue.getFieldValue() != null && CollectionUtils.isNotEmpty((Collection)aggValue.getFieldValue().getItems())) {
                        itemList = aggValue.getFieldValue().getItems().stream().map(Item::toLite).collect(Collectors.toSet());
                    } else if (aggValue.getFieldValue() == null && aggValue.hasDateGroups()) {
                        itemList = aggValue.getDateGroups().values().stream().map(FieldValue::getItems).flatMap(Collection::stream).map(Item::toLite).collect(Collectors.toSet());
                    } else {
                        throw new TrendzInternalException();
                    }
                    if (!itemList.isEmpty()) {
                        BusinessEntity businessEntity = (BusinessEntity)ctx.getBusinessEntityMap().get(request.getRowClickEntityId());
                        BusinessEntityType entityType = businessEntity.getQuery().getEntityType();
                        List<DataRow.EntityIdAndName> ids = itemList.stream().map(item -> {
                            AssetId id = switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$entity$BusinessEntityType[entityType.ordinal()]) {
                                case 1 -> new AssetId(item.getId());
                                case 2 -> new DeviceId(item.getId());
                                case 3 -> new CustomerId(item.getId());
                                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(entityType));
                            };
                            return new DataRow.EntityIdAndName((EntityId)id, item.getName());
                        }).toList();
                        dataRow.setEntityIds(ids);
                    }
                }
                if (aggValue.getFieldValue() == null) {
                    if (MapUtils.isNotEmpty((Map)aggValue.getDateGroups())) {
                        for (DateAggregationGroup dayGroup : aggValue.getDateGroups().keySet()) {
                            dayGroups.add(new DayAggregationBucket(dayGroup, viewFieldId, (FieldValue)aggValue.getDateGroups().get(dayGroup)));
                        }
                        continue;
                    }
                    throw new TrendzInternalException("Aggregated Value is not defined");
                }
                DataCell cell = new DataCell(viewFieldId, aggValue.getFieldValue().getInnerValue());
                dataRow.getCells().add(cell);
            }
            result.add(dataRow);
            result.addAll(this.processDayGroupCells(dataRow, dayGroups));
        }
        return Lists.newArrayList((Iterable)Sets.newHashSet((Iterable)result));
    }

    public void filterBlankFields(ViewRequest request, ViewContext ctx) {
        Set filterIds;
        if (CollectionUtils.isNotEmpty((Collection)request.getRuntimeFilters()) && CollectionUtils.isNotEmpty(filterIds = request.getRuntimeFilters().stream().filter(f -> !f.isBlankFilter()).map(RuntimeFilterField::getViewFieldId).collect(Collectors.toSet()))) {
            Set blankRowIds = this.rows.stream().filter(row -> {
                List filterFields = row.getOrderedFields().stream().filter(f -> filterIds.contains(f.getId())).collect(Collectors.toList());
                boolean isBlank = filterFields.stream().anyMatch(field -> {
                    FieldState fieldState = (FieldState)row.getFieldStates().get(field.getId());
                    if (fieldState != null && fieldState.getValue() != null && fieldState.getValue().getFieldValue() != null) {
                        return fieldState.getValue().getFieldValue().getFieldType().equals((Object)FieldType.BLANK);
                    }
                    return false;
                });
                return isBlank;
            }).map(Row::getId).collect(Collectors.toSet());
            List blankRows = this.rows.stream().filter(row -> blankRowIds.contains(row.getId())).collect(Collectors.toList());
            this.rows = this.rows.stream().filter(row -> !blankRowIds.contains(row.getId())).collect(Collectors.toList());
            for (Row blankRow : blankRows) {
                Map fieldStates = blankRow.getFieldStates();
                for (ViewField viewField : blankRow.getOrderedFields()) {
                    FieldValue fieldValue;
                    FieldState fieldState = (FieldState)fieldStates.get(viewField.getId());
                    if (fieldState.getValue() == null || fieldState.getValue().getFieldValue() == null || (fieldValue = fieldState.getValue().getFieldValue()).getInnerValue() == null) continue;
                    ctx.removeFieldValue(viewField.getId(), fieldValue.getInnerValue());
                }
            }
        }
    }

    private List<DataRow> processDayGroupCells(DataRow originalRow, List<DayAggregationBucket> dayGroups) {
        ArrayList newRows = Lists.newArrayList();
        HashMap<DayAggregationBucket, DataRow> processedRows = new HashMap<DayAggregationBucket, DataRow>();
        DataRow currentRow = originalRow;
        DataRow rowTemplate = originalRow.clone();
        for (DayAggregationBucket group : dayGroups) {
            if (processedRows.containsKey(group)) {
                currentRow = (DataRow)processedRows.get(group);
            }
            DataCell mainCell = this.findOrCreateCell(currentRow, group.fieldId);
            mainCell.setData(group.fieldValue.getInnerValue());
            for (Map.Entry entry : group.aggregationKey.getKeys().entrySet()) {
                DataCell cell = this.findOrCreateCell(currentRow, ((DateAggregationKey)entry.getKey()).getDateViewFieldId());
                cell.setData((Object)((DateAggregationValue)entry.getValue()).getValue());
            }
            processedRows.put(group, currentRow);
            if (currentRow != originalRow) {
                newRows.add(currentRow);
            }
            currentRow = rowTemplate.clone();
        }
        return newRows;
    }

    private DataCell findOrCreateCell(DataRow row, UUID fieldId) {
        for (DataCell cell : row.getCells()) {
            if (!cell.getViewFieldId().equals(fieldId)) continue;
            return cell;
        }
        DataCell dataCell = new DataCell(fieldId, null);
        row.getCells().add(dataCell);
        return dataCell;
    }
}

