/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.aggregation.DateAggregationGroup;
import org.thingsboard.trendz.service.aggregation.DateAggregationValue;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.AggregatedValue;
import org.thingsboard.trendz.service.view.proto.FieldState;

public class Row {
    private static final Logger log = LoggerFactory.getLogger(Row.class);
    private final UUID id;
    private List<ViewField> orderedFields;
    private Map<UUID, FieldState> fieldStates;
    private Map<UUID, List<AggregatedValue>> hiddenValues;

    public Row(Row that) {
        this.id = that.id;
        this.orderedFields = that.orderedFields == null ? null : that.orderedFields.stream().map(ViewField::new).collect(Collectors.toList());
        this.fieldStates = that.fieldStates == null ? null : that.fieldStates.entrySet().stream().map(entry -> Map.entry((UUID)entry.getKey(), new FieldState((FieldState)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.hiddenValues = that.hiddenValues == null ? null : that.hiddenValues.entrySet().stream().map(entry -> {
            UUID key = (UUID)entry.getKey();
            List value = entry.getValue() == null ? null : ((List)entry.getValue()).stream().map(AggregatedValue::new).collect(Collectors.toList());
            return Map.entry(key, value);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Row(List<ViewField> viewFields) {
        this.id = TimeStampUUIDGenerator.generateId();
        this.orderedFields = viewFields;
        this.fieldStates = new ConcurrentHashMap();
        this.hiddenValues = new ConcurrentHashMap();
        for (ViewField viewField : viewFields) {
            this.fieldStates.put(viewField.getId(), new FieldState());
        }
    }

    public FieldState getFieldState(ViewField viewField) {
        return (FieldState)this.fieldStates.get(viewField.getId());
    }

    public void markAsProcessed(ViewField viewField, AggregatedValue value) {
        FieldState fieldState = (FieldState)this.fieldStates.get(viewField.getId());
        fieldState.setValue(value);
        fieldState.setProcessed(true);
    }

    public Row copy() {
        Row row = new Row(this.orderedFields);
        ConcurrentHashMap<UUID, FieldState> stateCopy = new ConcurrentHashMap<UUID, FieldState>();
        for (UUID viewFieldId : this.fieldStates.keySet()) {
            FieldState fieldState = (FieldState)this.fieldStates.get(viewFieldId);
            stateCopy.put(viewFieldId, new FieldState(fieldState));
        }
        row.fieldStates = stateCopy;
        row.hiddenValues = new ConcurrentHashMap(this.hiddenValues);
        return row;
    }

    public Optional<ViewField> getNextUnprocessed() {
        for (ViewField viewField : this.orderedFields) {
            FieldState fieldState = (FieldState)this.fieldStates.get(viewField.getId());
            if (fieldState.isProcessed()) continue;
            return Optional.of(viewField);
        }
        return Optional.empty();
    }

    public Optional<Set<Item>> getEntityItems(UUID businessEntityId, ViewContext ctx) {
        boolean found = false;
        ViewField latestMatchedField = null;
        Set latestItemIdSet = null;
        for (ViewField viewField : this.orderedFields) {
            FieldState fieldState;
            if (!viewField.getBusinessEntityId().equals(businessEntityId) || (fieldState = (FieldState)this.fieldStates.get(viewField.getId())) == null || !fieldState.isProcessed()) continue;
            found = true;
            latestMatchedField = viewField;
            latestItemIdSet = fieldState.getValue().getItems().stream().map(Item::getId).collect(Collectors.toSet());
        }
        if (found) {
            Map idToItemMap = ctx.getIdToItemMap();
            Map childItemIdToParentItemIdSetMap = ctx.getChildItemIdToParentItemIdSetMap();
            boolean afterLatest = false;
            Set initialRootItemIdSet = Item.getRootParents(latestItemIdSet, (Map)childItemIdToParentItemIdSetMap);
            for (ViewField viewField : this.orderedFields) {
                if (afterLatest) {
                    FieldState fieldState = (FieldState)this.fieldStates.get(viewField.getId());
                    if (fieldState == null || !fieldState.isProcessed()) continue;
                    Set currentItemIdSet = fieldState.getValue().getItems().stream().map(Item::getId).collect(Collectors.toSet());
                    if (currentItemIdSet.isEmpty()) break;
                    Set rootItemIdSet = Item.getRootParents(currentItemIdSet, (Map)childItemIdToParentItemIdSetMap);
                    Sets.SetView intersection = Sets.intersection((Set)initialRootItemIdSet, (Set)rootItemIdSet);
                    HashSet filteredItemIdSet = new HashSet();
                    for (UUID itemId : latestItemIdSet) {
                        Set itemRootParentIdSet = Item.getRootParents(Set.of(itemId), (Map)childItemIdToParentItemIdSetMap);
                        if (Sets.intersection((Set)intersection, (Set)itemRootParentIdSet).isEmpty()) continue;
                        filteredItemIdSet.add(itemId);
                    }
                    latestItemIdSet = filteredItemIdSet;
                    continue;
                }
                afterLatest = viewField == latestMatchedField;
            }
            Set latestItems = latestItemIdSet.stream().map(idToItemMap::get).collect(Collectors.toSet());
            return Optional.of(latestItems);
        }
        return Optional.empty();
    }

    public String toString() {
        Object line = "";
        for (ViewField viewField : this.orderedFields) {
            FieldState fieldState = (FieldState)this.fieldStates.get(viewField.getId());
            if (!fieldState.isProcessed()) continue;
            if (fieldState.getValue().getFieldValue() != null) {
                line = (String)line + viewField.getLabel() + " = " + String.valueOf(fieldState.getValue().getFieldValue().getInnerValue()) + "; ";
                continue;
            }
            line = (String)line + viewField.getLabel() + " ";
            if (fieldState.getValue().getDateGroups() != null) {
                for (Map.Entry entry : fieldState.getValue().getDateGroups().entrySet()) {
                    Object key = "";
                    for (Map.Entry keyEntry : ((DateAggregationGroup)entry.getKey()).getKeys().entrySet()) {
                        key = (String)key + "[" + String.valueOf(keyEntry.getKey()) + "-" + ((DateAggregationValue)keyEntry.getValue()).getValue() + "]";
                    }
                    line = (String)line + (String)key + " = " + String.valueOf(((FieldValue)entry.getValue()).getInnerValue());
                }
                line = (String)line + "; ";
                continue;
            }
            line = (String)line + " = empty; ";
        }
        return line;
    }

    public UUID getId() {
        return this.id;
    }

    public List<ViewField> getOrderedFields() {
        return this.orderedFields;
    }

    public Map<UUID, FieldState> getFieldStates() {
        return this.fieldStates;
    }

    public Map<UUID, List<AggregatedValue>> getHiddenValues() {
        return this.hiddenValues;
    }
}

