/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.service.view.ViewContext;

public class RequestStats {
    private static final Logger log = LoggerFactory.getLogger(RequestStats.class);
    private long submitTs;
    private long finishTs;
    private long initFinishTs;
    private long customerDictionaryLoadTime;
    private long filterOptionsWaitTime;
    private Map<BusinessEntity, Long> filterOptionsLoadTime = new ConcurrentHashMap();
    private AtomicInteger mainIterations = new AtomicInteger();
    private Map<Integer, Integer> rowsAfterIteration = Collections.synchronizedMap(new TreeMap());
    private Map<Integer, Long> iterationDuration = Collections.synchronizedMap(new TreeMap());
    private Map<ViewField, AtomicLong> totalFieldProcessingTime = new ConcurrentHashMap();
    private Map<ViewField, AtomicLong> fieldValueLoadAndAggregateTime = new ConcurrentHashMap();
    private Map<ViewField, AtomicLong> itemsLoadTime = new ConcurrentHashMap();
    private Map<ViewField, AtomicLong> fieldValueLoadTime = new ConcurrentHashMap();
    private Map<ViewField, AtomicLong> fieldQueryCount = new ConcurrentHashMap();
    private Map<ViewField, AtomicLong> fieldQueryTime = new ConcurrentHashMap();

    public void printDebug(ViewContext ctx) {
        log.debug("Total time {} ms", (Object)(this.finishTs - this.submitTs));
        log.debug("Init time {} ms", (Object)(this.initFinishTs - this.submitTs));
        log.debug("Customer load time {} ms", (Object)this.customerDictionaryLoadTime);
        log.debug("FilterOptions wait time {} ms", (Object)this.filterOptionsWaitTime);
        log.debug("Iterations - {} {}", (Object)this.mainIterations.get(), ctx.getOrderedFields().stream().map(f -> f.getLabel() + "_" + String.valueOf(f.getAggregationType())).collect(Collectors.toList()));
        for (Integer iteration : this.rowsAfterIteration.keySet()) {
            log.debug("\t {} : rows {} duration {} ms", new Object[]{iteration, this.rowsAfterIteration.get(iteration), this.iterationDuration.get(iteration)});
        }
        for (ViewField viewField : this.totalFieldProcessingTime.keySet()) {
            log.debug("ViewField details: {} {}", (Object)viewField.getLabel(), (Object)viewField.getAggregationType());
            long totalFieldTime = ((AtomicLong)this.totalFieldProcessingTime.get(viewField)).get();
            log.debug("\t totalTime {}", (Object)totalFieldTime);
            if (this.itemsLoadTime.containsKey(viewField)) {
                log.debug("\t items load time {} ms ", (Object)((AtomicLong)this.itemsLoadTime.get(viewField)).get());
            }
            if (this.fieldValueLoadAndAggregateTime.containsKey(viewField)) {
                log.debug("\t value load and aggregate time {} ms ", (Object)((AtomicLong)this.fieldValueLoadAndAggregateTime.get(viewField)).get());
            }
            long fieldLoad = -1L;
            if (this.fieldValueLoadTime.containsKey(viewField)) {
                fieldLoad = ((AtomicLong)this.fieldValueLoadTime.get(viewField)).get();
                log.debug("\t field value load time {} ms", (Object)fieldLoad);
            }
            if (this.fieldQueryCount.containsKey(viewField)) {
                long cnt = ((AtomicLong)this.fieldQueryCount.get(viewField)).get();
                long fieldQuery = ((AtomicLong)this.fieldQueryTime.get(viewField)).get();
                log.debug("\t Ts queries {} duration {} ms; avg {} ms", new Object[]{cnt, fieldQuery, fieldQuery / cnt});
            }
            log.debug("\t Other time {}", (Object)(totalFieldTime - fieldLoad));
        }
        for (BusinessEntity entity : this.filterOptionsLoadTime.keySet()) {
            log.debug("{} filter options - {} ms", (Object)entity.getName(), this.filterOptionsLoadTime.get(entity));
        }
    }

    public long getSubmitTs() {
        return this.submitTs;
    }

    public long getFinishTs() {
        return this.finishTs;
    }

    public long getInitFinishTs() {
        return this.initFinishTs;
    }

    public long getCustomerDictionaryLoadTime() {
        return this.customerDictionaryLoadTime;
    }

    public long getFilterOptionsWaitTime() {
        return this.filterOptionsWaitTime;
    }

    public Map<BusinessEntity, Long> getFilterOptionsLoadTime() {
        return this.filterOptionsLoadTime;
    }

    public AtomicInteger getMainIterations() {
        return this.mainIterations;
    }

    public Map<Integer, Integer> getRowsAfterIteration() {
        return this.rowsAfterIteration;
    }

    public Map<Integer, Long> getIterationDuration() {
        return this.iterationDuration;
    }

    public Map<ViewField, AtomicLong> getTotalFieldProcessingTime() {
        return this.totalFieldProcessingTime;
    }

    public Map<ViewField, AtomicLong> getFieldValueLoadAndAggregateTime() {
        return this.fieldValueLoadAndAggregateTime;
    }

    public Map<ViewField, AtomicLong> getItemsLoadTime() {
        return this.itemsLoadTime;
    }

    public Map<ViewField, AtomicLong> getFieldValueLoadTime() {
        return this.fieldValueLoadTime;
    }

    public Map<ViewField, AtomicLong> getFieldQueryCount() {
        return this.fieldQueryCount;
    }

    public Map<ViewField, AtomicLong> getFieldQueryTime() {
        return this.fieldQueryTime;
    }

    public void setSubmitTs(long submitTs) {
        this.submitTs = submitTs;
    }

    public void setFinishTs(long finishTs) {
        this.finishTs = finishTs;
    }

    public void setInitFinishTs(long initFinishTs) {
        this.initFinishTs = initFinishTs;
    }

    public void setCustomerDictionaryLoadTime(long customerDictionaryLoadTime) {
        this.customerDictionaryLoadTime = customerDictionaryLoadTime;
    }

    public void setFilterOptionsWaitTime(long filterOptionsWaitTime) {
        this.filterOptionsWaitTime = filterOptionsWaitTime;
    }

    public void setFilterOptionsLoadTime(Map<BusinessEntity, Long> filterOptionsLoadTime) {
        this.filterOptionsLoadTime = filterOptionsLoadTime;
    }

    public void setMainIterations(AtomicInteger mainIterations) {
        this.mainIterations = mainIterations;
    }

    public void setRowsAfterIteration(Map<Integer, Integer> rowsAfterIteration) {
        this.rowsAfterIteration = rowsAfterIteration;
    }

    public void setIterationDuration(Map<Integer, Long> iterationDuration) {
        this.iterationDuration = iterationDuration;
    }

    public void setTotalFieldProcessingTime(Map<ViewField, AtomicLong> totalFieldProcessingTime) {
        this.totalFieldProcessingTime = totalFieldProcessingTime;
    }

    public void setFieldValueLoadAndAggregateTime(Map<ViewField, AtomicLong> fieldValueLoadAndAggregateTime) {
        this.fieldValueLoadAndAggregateTime = fieldValueLoadAndAggregateTime;
    }

    public void setItemsLoadTime(Map<ViewField, AtomicLong> itemsLoadTime) {
        this.itemsLoadTime = itemsLoadTime;
    }

    public void setFieldValueLoadTime(Map<ViewField, AtomicLong> fieldValueLoadTime) {
        this.fieldValueLoadTime = fieldValueLoadTime;
    }

    public void setFieldQueryCount(Map<ViewField, AtomicLong> fieldQueryCount) {
        this.fieldQueryCount = fieldQueryCount;
    }

    public void setFieldQueryTime(Map<ViewField, AtomicLong> fieldQueryTime) {
        this.fieldQueryTime = fieldQueryTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestStats)) {
            return false;
        }
        RequestStats other = (RequestStats)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getSubmitTs() != other.getSubmitTs()) {
            return false;
        }
        if (this.getFinishTs() != other.getFinishTs()) {
            return false;
        }
        if (this.getInitFinishTs() != other.getInitFinishTs()) {
            return false;
        }
        if (this.getCustomerDictionaryLoadTime() != other.getCustomerDictionaryLoadTime()) {
            return false;
        }
        if (this.getFilterOptionsWaitTime() != other.getFilterOptionsWaitTime()) {
            return false;
        }
        Map this$filterOptionsLoadTime = this.getFilterOptionsLoadTime();
        Map other$filterOptionsLoadTime = other.getFilterOptionsLoadTime();
        if (this$filterOptionsLoadTime == null ? other$filterOptionsLoadTime != null : !((Object)this$filterOptionsLoadTime).equals(other$filterOptionsLoadTime)) {
            return false;
        }
        AtomicInteger this$mainIterations = this.getMainIterations();
        AtomicInteger other$mainIterations = other.getMainIterations();
        if (this$mainIterations == null ? other$mainIterations != null : !this$mainIterations.equals(other$mainIterations)) {
            return false;
        }
        Map this$rowsAfterIteration = this.getRowsAfterIteration();
        Map other$rowsAfterIteration = other.getRowsAfterIteration();
        if (this$rowsAfterIteration == null ? other$rowsAfterIteration != null : !((Object)this$rowsAfterIteration).equals(other$rowsAfterIteration)) {
            return false;
        }
        Map this$iterationDuration = this.getIterationDuration();
        Map other$iterationDuration = other.getIterationDuration();
        if (this$iterationDuration == null ? other$iterationDuration != null : !((Object)this$iterationDuration).equals(other$iterationDuration)) {
            return false;
        }
        Map this$totalFieldProcessingTime = this.getTotalFieldProcessingTime();
        Map other$totalFieldProcessingTime = other.getTotalFieldProcessingTime();
        if (this$totalFieldProcessingTime == null ? other$totalFieldProcessingTime != null : !((Object)this$totalFieldProcessingTime).equals(other$totalFieldProcessingTime)) {
            return false;
        }
        Map this$fieldValueLoadAndAggregateTime = this.getFieldValueLoadAndAggregateTime();
        Map other$fieldValueLoadAndAggregateTime = other.getFieldValueLoadAndAggregateTime();
        if (this$fieldValueLoadAndAggregateTime == null ? other$fieldValueLoadAndAggregateTime != null : !((Object)this$fieldValueLoadAndAggregateTime).equals(other$fieldValueLoadAndAggregateTime)) {
            return false;
        }
        Map this$itemsLoadTime = this.getItemsLoadTime();
        Map other$itemsLoadTime = other.getItemsLoadTime();
        if (this$itemsLoadTime == null ? other$itemsLoadTime != null : !((Object)this$itemsLoadTime).equals(other$itemsLoadTime)) {
            return false;
        }
        Map this$fieldValueLoadTime = this.getFieldValueLoadTime();
        Map other$fieldValueLoadTime = other.getFieldValueLoadTime();
        if (this$fieldValueLoadTime == null ? other$fieldValueLoadTime != null : !((Object)this$fieldValueLoadTime).equals(other$fieldValueLoadTime)) {
            return false;
        }
        Map this$fieldQueryCount = this.getFieldQueryCount();
        Map other$fieldQueryCount = other.getFieldQueryCount();
        if (this$fieldQueryCount == null ? other$fieldQueryCount != null : !((Object)this$fieldQueryCount).equals(other$fieldQueryCount)) {
            return false;
        }
        Map this$fieldQueryTime = this.getFieldQueryTime();
        Map other$fieldQueryTime = other.getFieldQueryTime();
        return !(this$fieldQueryTime == null ? other$fieldQueryTime != null : !((Object)this$fieldQueryTime).equals(other$fieldQueryTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestStats;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $submitTs = this.getSubmitTs();
        result = result * 59 + (int)($submitTs >>> 32 ^ $submitTs);
        long $finishTs = this.getFinishTs();
        result = result * 59 + (int)($finishTs >>> 32 ^ $finishTs);
        long $initFinishTs = this.getInitFinishTs();
        result = result * 59 + (int)($initFinishTs >>> 32 ^ $initFinishTs);
        long $customerDictionaryLoadTime = this.getCustomerDictionaryLoadTime();
        result = result * 59 + (int)($customerDictionaryLoadTime >>> 32 ^ $customerDictionaryLoadTime);
        long $filterOptionsWaitTime = this.getFilterOptionsWaitTime();
        result = result * 59 + (int)($filterOptionsWaitTime >>> 32 ^ $filterOptionsWaitTime);
        Map $filterOptionsLoadTime = this.getFilterOptionsLoadTime();
        result = result * 59 + ($filterOptionsLoadTime == null ? 43 : ((Object)$filterOptionsLoadTime).hashCode());
        AtomicInteger $mainIterations = this.getMainIterations();
        result = result * 59 + ($mainIterations == null ? 43 : $mainIterations.hashCode());
        Map $rowsAfterIteration = this.getRowsAfterIteration();
        result = result * 59 + ($rowsAfterIteration == null ? 43 : ((Object)$rowsAfterIteration).hashCode());
        Map $iterationDuration = this.getIterationDuration();
        result = result * 59 + ($iterationDuration == null ? 43 : ((Object)$iterationDuration).hashCode());
        Map $totalFieldProcessingTime = this.getTotalFieldProcessingTime();
        result = result * 59 + ($totalFieldProcessingTime == null ? 43 : ((Object)$totalFieldProcessingTime).hashCode());
        Map $fieldValueLoadAndAggregateTime = this.getFieldValueLoadAndAggregateTime();
        result = result * 59 + ($fieldValueLoadAndAggregateTime == null ? 43 : ((Object)$fieldValueLoadAndAggregateTime).hashCode());
        Map $itemsLoadTime = this.getItemsLoadTime();
        result = result * 59 + ($itemsLoadTime == null ? 43 : ((Object)$itemsLoadTime).hashCode());
        Map $fieldValueLoadTime = this.getFieldValueLoadTime();
        result = result * 59 + ($fieldValueLoadTime == null ? 43 : ((Object)$fieldValueLoadTime).hashCode());
        Map $fieldQueryCount = this.getFieldQueryCount();
        result = result * 59 + ($fieldQueryCount == null ? 43 : ((Object)$fieldQueryCount).hashCode());
        Map $fieldQueryTime = this.getFieldQueryTime();
        result = result * 59 + ($fieldQueryTime == null ? 43 : ((Object)$fieldQueryTime).hashCode());
        return result;
    }

    public String toString() {
        return "RequestStats(submitTs=" + this.getSubmitTs() + ", finishTs=" + this.getFinishTs() + ", initFinishTs=" + this.getInitFinishTs() + ", customerDictionaryLoadTime=" + this.getCustomerDictionaryLoadTime() + ", filterOptionsWaitTime=" + this.getFilterOptionsWaitTime() + ", filterOptionsLoadTime=" + String.valueOf(this.getFilterOptionsLoadTime()) + ", mainIterations=" + String.valueOf(this.getMainIterations()) + ", rowsAfterIteration=" + String.valueOf(this.getRowsAfterIteration()) + ", iterationDuration=" + String.valueOf(this.getIterationDuration()) + ", totalFieldProcessingTime=" + String.valueOf(this.getTotalFieldProcessingTime()) + ", fieldValueLoadAndAggregateTime=" + String.valueOf(this.getFieldValueLoadAndAggregateTime()) + ", itemsLoadTime=" + String.valueOf(this.getItemsLoadTime()) + ", fieldValueLoadTime=" + String.valueOf(this.getFieldValueLoadTime()) + ", fieldQueryCount=" + String.valueOf(this.getFieldQueryCount()) + ", fieldQueryTime=" + String.valueOf(this.getFieldQueryTime()) + ")";
    }
}

