/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.ViewRequest;

@Service
public class LoadFieldOrderingService {
    private static final Logger log = LoggerFactory.getLogger(LoadFieldOrderingService.class);
    private static final Set<FieldQueryType> ATTRIBUTE_TYPE_SET = Set.of(FieldQueryType.ENTITY_ID, FieldQueryType.ENTITY_NAME, FieldQueryType.ENTITY_LABEL, FieldQueryType.ATTRIBUTE, FieldQueryType.OWNER);

    public List<ViewField> order(ViewRequest request, ViewContext context) {
        Map distancesFromRoot = context.getDistancesFromRoot();
        List<ViewField> ordered = request.getFields().stream().filter(viewField -> !this.innerLoadField(viewField, context)).sorted((o1, o2) -> {
            int compare = this.compareByCalculationField(o1, o2);
            if (compare != 0) {
                return compare;
            }
            compare = this.compareByUniqueAggregation(o1, o2);
            if (compare != 0) {
                return compare;
            }
            compare = this.compareByFieldType(context, o1, o2);
            if (compare != 0) {
                return compare;
            }
            compare = this.compareByRootDistance(distancesFromRoot, o1, o2);
            if (compare != 0) {
                return compare;
            }
            compare = this.compareByPredictionFieldCriteria(o1, o2);
            if (compare != 0) {
                return compare;
            }
            return 0;
        }).collect(Collectors.toList());
        if (log.isInfoEnabled()) {
            List orderedFieldNameList = ordered.stream().map(f -> f.getLabel() + "[" + String.valueOf(f.getAggregationType()) + "]").collect(Collectors.toList());
            log.info("Fields load order {}", orderedFieldNameList);
        }
        return ordered;
    }

    private boolean innerLoadField(ViewField viewField, ViewContext ctx) {
        BusinessEntityField entityField = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(viewField.getEntityFieldId());
        boolean isForState = viewField.isForStateCondition();
        boolean isTelemetry = entityField != null && entityField.hasTime();
        return isForState && isTelemetry;
    }

    private int compareByCalculationField(ViewField o1, ViewField o2) {
        boolean i1 = o1.isSimpleCalculation();
        boolean i2 = o2.isSimpleCalculation();
        return Boolean.compare(i1, i2);
    }

    private int compareByUniqueAggregation(ViewField o1, ViewField o2) {
        if (o1.isSimpleCalculation() != o2.isSimpleCalculation()) {
            throw new TrendzException("Calculated field must be already separated by previous comparison.");
        }
        if (o1.isSimpleCalculation() && o2.isSimpleCalculation()) {
            return 0;
        }
        boolean i1 = FieldAggregation.UNIQ.equals((Object)o1.getAggregationType());
        boolean i2 = FieldAggregation.UNIQ.equals((Object)o2.getAggregationType());
        return Boolean.compare(i2, i1);
    }

    private int compareByFieldType(ViewContext context, ViewField o1, ViewField o2) {
        FieldQueryType i2;
        if (o1.isSimpleCalculation() != o2.isSimpleCalculation()) {
            throw new TrendzException("Calculated field must be already separated by previous comparison.");
        }
        if (o1.isSimpleCalculation() && o2.isSimpleCalculation()) {
            return 0;
        }
        FieldQueryType i1 = this.getQueryType(context, o1);
        if (i1 == (i2 = this.getQueryType(context, o2))) {
            return 0;
        }
        return i1 == FieldQueryType.ATTRIBUTE ? -1 : 1;
    }

    private int compareByRootDistance(Map<UUID, Integer> distancesFromRoot, ViewField o1, ViewField o2) {
        if (o1.isSimpleCalculation() != o2.isSimpleCalculation()) {
            throw new TrendzException("Calculated field must be already separated by previous comparison.");
        }
        if (o1.isSimpleCalculation() && o2.isSimpleCalculation()) {
            return 0;
        }
        int oneDistance = distancesFromRoot.getOrDefault(o1.getBusinessEntityId(), Integer.MAX_VALUE);
        int twoDistance = distancesFromRoot.getOrDefault(o2.getBusinessEntityId(), Integer.MAX_VALUE);
        log.trace("Root distance {}:{} and {}:{}", new Object[]{o1.getLabel(), oneDistance, o2.getLabel(), twoDistance});
        return Integer.compare(oneDistance, twoDistance);
    }

    private int compareByPredictionFieldCriteria(ViewField o1, ViewField o2) {
        if (o1.isSimpleCalculation() != o2.isSimpleCalculation()) {
            throw new TrendzException("Calculated field must be already separated by previous comparison.");
        }
        if (o1.isSimpleCalculation() && o2.isSimpleCalculation()) {
            return 0;
        }
        boolean i1 = o1.isPredictionModelField();
        boolean i2 = o2.isPredictionModelField();
        return Boolean.compare(i1, i2);
    }

    private FieldQueryType getQueryType(ViewContext ctx, ViewField viewField) {
        boolean isAttribute;
        UUID entityFieldId;
        Map idToEntityFieldMap = ctx.getBusinessEntityFieldMap();
        BusinessEntityField entityField = (BusinessEntityField)idToEntityFieldMap.get(entityFieldId = viewField.getEntityFieldId());
        FieldQueryType queryType = entityField == null ? null : entityField.getQuery().getQueryType();
        boolean isTelemetry = queryType != null && !ATTRIBUTE_TYPE_SET.contains(queryType);
        isTelemetry |= viewField.isCalculatedField();
        isTelemetry |= viewField.isStateField();
        isTelemetry |= viewField.isAnomalyField();
        isTelemetry |= viewField.isAlarmField();
        boolean bl = isAttribute = queryType != null && ATTRIBUTE_TYPE_SET.contains(queryType);
        if ((isTelemetry |= viewField.isPredictionModelField()) != isAttribute) {
            return isTelemetry ? FieldQueryType.TELEMETRY : FieldQueryType.ATTRIBUTE;
        }
        throw new TrendzException("Wrong definition of ordering field: " + viewField.getLabel());
    }
}

