/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view.proto;

import com.google.common.collect.Lists;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityFieldQuery;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.config.DateAggregationType;
import org.thingsboard.trendz.domain.definition.view.config.FilterCondition;
import org.thingsboard.trendz.domain.definition.view.config.RuntimeFilterField;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.exception.TrendzInternalException;
import org.thingsboard.trendz.service.aggregation.DateAggregationGroup;
import org.thingsboard.trendz.service.filter.FilterRequestService;
import org.thingsboard.trendz.service.provider.tb3.FilterOptionTask;
import org.thingsboard.trendz.service.provider.tb3.tb31filter.query.TsValue;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.AggregatedValue;
import org.thingsboard.trendz.service.view.proto.FilterService;
import org.thingsboard.trendz.service.view.proto.FilterServiceImpl;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.tools.DateTimeUtils;

@Component
public class FilterServiceImpl
implements FilterService {
    private static final Logger log = LoggerFactory.getLogger(FilterServiceImpl.class);

    public List<AggregatedValue> filterAggregatedValue(List<AggregatedValue> original, ViewField viewField, ViewRequest request, ViewContext ctx) {
        if (original.isEmpty()) {
            return original;
        }
        if (original.iterator().next().getFieldValue() == null) {
            return this.filterDateGroupFields(original, viewField, request, ctx);
        }
        return this.filterSimpleFields(original, viewField, request, ctx);
    }

    public boolean matchFieldValue(FieldValue original, ViewField viewField, ViewRequest request) {
        return request.getRuntimeFilters().stream().filter(f -> f.getViewFieldId().equals(viewField.getId())).findAny().map(runtimeFilterField -> original.getInnerValue() != null && this.simpleFilterMatched(runtimeFilterField, original)).orElse(true);
    }

    public void loadFilterOptions(ViewContext ctx, ViewRequest request) {
        if (request == null) {
            return;
        }
        for (FilterOptionTask filterOptionTask : ctx.getFieldFilterOptionTasks()) {
            if (!filterOptionTask.getStarted().compareAndSet(false, true)) continue;
            long startTs = System.currentTimeMillis();
            Set entityFieldIds = filterOptionTask.getBusinessEntity().getFields().stream().map(BusinessEntityField::getId).collect(Collectors.toSet());
            List items = filterOptionTask.getItemList();
            Set viewFieldIds = request.getRuntimeFilters().stream().filter(runtimeFilterField -> !runtimeFilterField.isBlankFilter()).map(RuntimeFilterField::getViewFieldId).collect(Collectors.toSet());
            Set viewFields = request.getFields().stream().filter(vf -> entityFieldIds.contains(vf.getEntityFieldId())).filter(vf -> viewFieldIds.contains(vf.getId())).collect(Collectors.toSet());
            for (Item item : items) {
                for (ViewField viewfield : viewFields) {
                    BusinessEntityField bef = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(viewfield.getEntityFieldId());
                    BusinessEntityFieldQuery fieldQuery = bef.getQuery();
                    String value = FieldQueryType.ENTITY_NAME.equals((Object)bef.getQuery().getQueryType()) ? item.getName() : (FieldQueryType.ENTITY_LABEL.equals((Object)bef.getQuery().getQueryType()) ? item.getLabel() : (FieldQueryType.ATTRIBUTE.equals((Object)bef.getQuery().getQueryType()) ? ((TsValue)item.getAttributes().get(fieldQuery.getKey())).getValue() : null));
                    ctx.addFieldValue(viewfield.getId(), (Object)value);
                }
            }
            long endTs = System.currentTimeMillis();
            log.trace("Options load time took {} ms. Found {} items", (Object)(endTs - startTs), (Object)items.size());
            ctx.getStats().getFilterOptionsLoadTime().put(filterOptionTask.getBusinessEntity(), endTs - startTs);
        }
    }

    public boolean processTelemetryThroughDateFilter(ViewContext ctx, ViewField viewField, RuntimeFilterField filterField, long ts, ZoneId zoneId) {
        Set selection = filterField.getSelection();
        FilterCondition condition = filterField.getCondition();
        ZonedDateTime datetime = DateTimeUtils.fromTs((long)ts, (ZoneId)zoneId);
        Map englishToLabelMap = FilterRequestService.ENGLISH_TO_LABEL_MAP;
        Map<FilterCondition, Predicate<DateAggregationType>> conditionsMap = Map.of(FilterCondition.ANY, __ -> true, FilterCondition.ONE_OF, aggType -> switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$DateAggregationType[aggType.ordinal()]) {
            case 1 -> {
                String hourStr = String.valueOf(datetime.getHour());
                ctx.addFieldValue(viewField.getId(), (Object)hourStr);
                if (selection.isEmpty() || selection.contains(hourStr)) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                String dayOfMonthStr = String.valueOf(datetime.getDayOfMonth());
                ctx.addFieldValue(viewField.getId(), (Object)dayOfMonthStr);
                if (selection.isEmpty() || selection.contains(dayOfMonthStr)) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                String dayOfWeek = (String)englishToLabelMap.get(datetime.getDayOfWeek().getDisplayName(TextStyle.FULL, Locale.getDefault()));
                ctx.addFieldValue(viewField.getId(), (Object)dayOfWeek);
                if (selection.isEmpty() || selection.contains(dayOfWeek)) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                String dayOfMonth = (String)englishToLabelMap.get(datetime.getMonth().getDisplayName(TextStyle.FULL, Locale.getDefault()));
                ctx.addFieldValue(viewField.getId(), (Object)dayOfMonth);
                if (selection.isEmpty() || selection.contains(dayOfMonth)) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        }, FilterCondition.NO_ONE_OF, aggType -> switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$DateAggregationType[aggType.ordinal()]) {
            case 1 -> {
                String hourStr = String.valueOf(datetime.getHour());
                ctx.addFieldValue(viewField.getId(), (Object)hourStr);
                if (selection.isEmpty() || !selection.contains(hourStr)) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                String dayOfMonthStr = String.valueOf(datetime.getDayOfMonth());
                ctx.addFieldValue(viewField.getId(), (Object)dayOfMonthStr);
                if (selection.isEmpty() || !selection.contains(dayOfMonthStr)) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                String dayOfWeek = (String)englishToLabelMap.get(datetime.getDayOfWeek().getDisplayName(TextStyle.FULL, Locale.getDefault()));
                ctx.addFieldValue(viewField.getId(), (Object)dayOfWeek);
                if (selection.isEmpty() || !selection.contains(dayOfWeek)) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                String dayOfMonth = (String)englishToLabelMap.get(datetime.getMonth().getDisplayName(TextStyle.FULL, Locale.getDefault()));
                ctx.addFieldValue(viewField.getId(), (Object)dayOfMonth);
                if (selection.isEmpty() || !selection.contains(dayOfMonth)) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        });
        return conditionsMap.get(condition).test(viewField.getDateGrouping());
    }

    private List<AggregatedValue> filterDateGroupFields(List<AggregatedValue> original, ViewField viewField, ViewRequest request, ViewContext ctx) {
        Optional<RuntimeFilterField> directFieldFilter = request.getRuntimeFilters().stream().filter(f -> f.getViewFieldId().equals(viewField.getId())).findAny();
        if (directFieldFilter.isPresent()) {
            ArrayList filtered = Lists.newArrayList();
            for (AggregatedValue aggValue : original) {
                ArrayList groupForRemove = Lists.newArrayList();
                for (DateAggregationGroup dayGroup : aggValue.getDateGroups().keySet()) {
                    FieldValue fieldValue = (FieldValue)aggValue.getDateGroups().get(dayGroup);
                    if (this.simpleFilterMatched(directFieldFilter.get(), fieldValue)) continue;
                    groupForRemove.add(dayGroup);
                }
                for (DateAggregationGroup group : groupForRemove) {
                    aggValue.getDateGroups().remove(group);
                }
                if (aggValue.getDateGroups().isEmpty()) continue;
                filtered.add(aggValue);
            }
            return filtered;
        }
        return original;
    }

    private List<AggregatedValue> filterSimpleFields(List<AggregatedValue> original, ViewField viewField, ViewRequest request, ViewContext ctx) {
        Optional<RuntimeFilterField> filter = request.getRuntimeFilters().stream().filter(f -> f.getViewFieldId().equals(viewField.getId())).findAny();
        if (filter.isPresent()) {
            original.stream().filter(av -> av.getFieldValue().getInnerValue() != null).forEach(av -> ctx.addFieldValue(viewField.getId(), av.getFieldValue().getInnerValue()));
            return original.stream().filter(av -> this.simpleFilterMatched((RuntimeFilterField)filter.get(), av.getFieldValue())).collect(Collectors.toList());
        }
        return original;
    }

    private boolean simpleFilterMatched(RuntimeFilterField filter, FieldValue fieldValue) {
        if (filter.getCondition() == FilterCondition.ANY) {
            return true;
        }
        if (fieldValue.getInnerValue() == null) {
            return false;
        }
        String strVal = fieldValue.getInnerValue().toString();
        FieldType fieldType = fieldValue.getFieldType();
        HashSet<Object> currentSelection = filter.getSelection();
        if (fieldType.equals((Object)FieldType.NUMERIC) && !currentSelection.isEmpty()) {
            HashSet<Object> newSelection = new HashSet<Object>();
            for (String value : filter.getSelection()) {
                if (value.lastIndexOf(46) == -1) {
                    newSelection.add(value + ".0");
                    continue;
                }
                newSelection.add(value);
            }
            currentSelection = newSelection;
        }
        switch (1.$SwitchMap$org$thingsboard$trendz$domain$definition$view$config$FilterCondition[filter.getCondition().ordinal()]) {
            case 1: {
                return CollectionUtils.isEmpty((Collection)currentSelection) || currentSelection.contains(strVal);
            }
            case 2: {
                return CollectionUtils.isEmpty((Collection)currentSelection) || !currentSelection.contains(strVal);
            }
            case 3: {
                return fieldType == FieldType.NUMERIC && (filter.getNumericParam() == null || (Double)fieldValue.getInnerValue() < filter.getNumericParam());
            }
            case 4: {
                return fieldType == FieldType.NUMERIC && (filter.getNumericParam() == null || (Double)fieldValue.getInnerValue() <= filter.getNumericParam());
            }
            case 5: {
                return fieldType == FieldType.NUMERIC && (filter.getNumericParam() == null || (Double)fieldValue.getInnerValue() > filter.getNumericParam());
            }
            case 6: {
                return fieldType == FieldType.NUMERIC && (filter.getNumericParam() == null || (Double)fieldValue.getInnerValue() >= filter.getNumericParam());
            }
            case 7: {
                return fieldType == FieldType.STRING && StringUtils.isNotBlank((CharSequence)strVal) && (StringUtils.isBlank((CharSequence)filter.getStrParam()) || strVal.startsWith(filter.getStrParam()));
            }
            case 8: {
                return fieldType == FieldType.STRING && StringUtils.isNotBlank((CharSequence)strVal) && (StringUtils.isBlank((CharSequence)filter.getStrParam()) || strVal.contains(filter.getStrParam()));
            }
            case 9: {
                return fieldType == FieldType.STRING && (StringUtils.isBlank((CharSequence)strVal) || StringUtils.isBlank((CharSequence)filter.getStrParam()) || !strVal.contains(filter.getStrParam()));
            }
            case 10: {
                return fieldType == FieldType.STRING && StringUtils.isNotBlank((CharSequence)strVal) && (StringUtils.isBlank((CharSequence)filter.getStrParam()) || strVal.endsWith(filter.getStrParam()));
            }
            case 11: {
                return fieldType == FieldType.DATE && (filter.getNumericParam() == null || (Double)fieldValue.getInnerValue() < filter.getNumericParam());
            }
            case 12: {
                return fieldType == FieldType.DATE && (filter.getNumericParam() == null || (Double)fieldValue.getInnerValue() <= filter.getNumericParam());
            }
            case 13: {
                return fieldType == FieldType.DATE && (filter.getNumericParam() == null || (Double)fieldValue.getInnerValue() > filter.getNumericParam());
            }
            case 14: {
                return fieldType == FieldType.DATE && (filter.getNumericParam() == null || (Double)fieldValue.getInnerValue() >= filter.getNumericParam());
            }
        }
        throw new TrendzInternalException("Unimplemented filter condition " + String.valueOf(filter.getCondition()));
    }
}

