/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.domain.definition.view.FieldAggregation;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.measurement.Measurable;
import org.thingsboard.trendz.domain.measurement.MeasuredTaskType;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.service.graph.RelationGraph;
import org.thingsboard.trendz.service.graph.RelationGraphService;
import org.thingsboard.trendz.service.provider.version.TbVersion;
import org.thingsboard.trendz.service.provider.version.TbVersionChecker;
import org.thingsboard.trendz.service.provider.version.TbVersionNumber;
import org.thingsboard.trendz.service.script.calculatedfield.CalculatedFieldProcessor;
import org.thingsboard.trendz.service.stats.StatsCollector;
import org.thingsboard.trendz.service.view.ItemService;
import org.thingsboard.trendz.service.view.ViewContext;
import org.thingsboard.trendz.service.view.proto.AggregatedValue;
import org.thingsboard.trendz.service.view.proto.AggregationService;
import org.thingsboard.trendz.service.view.proto.DataLoader;
import org.thingsboard.trendz.service.view.proto.FieldState;
import org.thingsboard.trendz.service.view.proto.FilterService;
import org.thingsboard.trendz.service.view.proto.Row;
import org.thingsboard.trendz.service.view.proto.RowBuilder;
import org.thingsboard.trendz.service.view.proto.ViewRequest;
import org.thingsboard.trendz.service.view.proto.WindowedStreamStore;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class ViewRequestFieldProcessor {
    private static final Logger log = LoggerFactory.getLogger(ViewRequestFieldProcessor.class);
    @Autowired
    private ItemService itemService;
    @Autowired
    private DataLoader dataLoader;
    @Autowired
    private AggregationService aggregationService;
    @Autowired
    private FilterService filterService;
    @Autowired
    private StatsCollector statsCollector;
    @Autowired
    private TbVersionChecker tbVersionChecker;
    @Autowired
    private CalculatedFieldProcessor calculatedFieldProcessor;
    @Autowired
    private RelationGraphService relationGraphService;

    @Measurable(context="#context", type=MeasuredTaskType.FIELD_PROCESSING, viewFieldName="#viewField.label", viewFieldAggregation="#viewField.aggregationType")
    public Mono<Boolean> processNextField(RowBuilder rowBuilder, Row row, ViewField viewField, ViewRequest request, ViewContext context) {
        long methodId = context.getProcessFieldMethodIdCounter().addAndGet(1L);
        AtomicLong startTs = new AtomicLong();
        AtomicLong processingStartTs = new AtomicLong();
        return Mono.just((Object)new Object()).doOnNext(o -> startTs.set(System.currentTimeMillis())).flatMap(o1 -> {
            log.trace("{}", (Object)rowBuilder);
            if (viewField.isSimpleCalculation()) {
                return this.calculatedFieldProcessor.processCalculatedField(row, viewField, request, context).collectList();
            }
            return Mono.just((Object)o1).flatMap(o2 -> this.loadItems(context, request, viewField, row, methodId)).doOnNext(itemList -> {
                log.trace("Found [{}] items for field [{}]", (Object)itemList.size(), (Object)viewField.getLabel());
                context.getStats().getItemsLoadTime().computeIfAbsent(viewField, id -> new AtomicLong()).addAndGet(System.currentTimeMillis() - startTs.get());
            }).flatMap(itemList -> {
                processingStartTs.set(System.currentTimeMillis());
                if (viewField.isMissedRelationField()) {
                    return Mono.justOrEmpty(Collections.singletonList(new AggregatedValue(null, itemList)));
                }
                WindowedStreamStore windowedStreamStore = this.buildCurrentGroup(row, request, context);
                return this.dataLoader.loadData(viewField, itemList, windowedStreamStore, request, context, methodId).collectList().flatMap(loadingData -> this.aggregationService.aggregate(loadingData, viewField, request.getMinimalDateAggregation(), request.getDateAggregationFieldsVisible(), request, context, methodId));
            });
        }).doOnNext(values -> {
            context.getStats().getFieldValueLoadAndAggregateTime().computeIfAbsent(viewField, i -> new AtomicLong()).addAndGet(System.currentTimeMillis() - processingStartTs.get());
            this.finishRowProcessing(values, viewField, row, rowBuilder, request, context);
            context.getStats().getTotalFieldProcessingTime().computeIfAbsent(viewField, id -> new AtomicLong()).addAndGet(System.currentTimeMillis() - startTs.get());
        }).map(values -> true);
    }

    private WindowedStreamStore buildCurrentGroup(Row row, ViewRequest request, ViewContext ctx) {
        ConcurrentHashMap<ViewField, Object> groupKeys = new ConcurrentHashMap<ViewField, Object>();
        for (ViewField viewField : request.getFields()) {
            Object grKey;
            FieldState fieldState;
            UUID entityFieldId = viewField.getEntityFieldId();
            BusinessEntityField entityField = (BusinessEntityField)ctx.getBusinessEntityFieldMap().get(entityFieldId);
            boolean hasTime = entityField != null && entityField.hasTime() || viewField.isAlarmField();
            boolean forStateCondition = viewField.isForStateCondition();
            if (viewField.getAggregationType() != FieldAggregation.UNIQ || !hasTime || forStateCondition || !(fieldState = row.getFieldState(viewField)).isProcessed() || (grKey = fieldState.getValue().getFieldValue().getInnerValue()) == null || grKey.equals(new HashSet<Object>(Collections.singleton(null)))) continue;
            groupKeys.put(viewField, grKey);
        }
        return new WindowedStreamStore(groupKeys, row);
    }

    private Mono<Set<Item>> loadItems(ViewContext ctx, ViewRequest request, ViewField viewField, Row row, long methodId) {
        Flux resultItems;
        if (request.isUsingManualDatasetAsParent(viewField) || request.isUsingManualDatasetAsChild(viewField)) {
            return Mono.just(Set.of(request.getManualDatasetItem(viewField)));
        }
        UUID entityId = viewField.getBusinessEntityId();
        Optional optional = row.getEntityItems(entityId, ctx);
        if (optional.isPresent()) {
            Set itemSet = (Set)optional.get();
            Set itemIdSet = itemSet.stream().map(Item::getId).collect(Collectors.toSet());
            Map businessEntityIdToItemsSet = ctx.getBusinessEntityIdToItemIdSet();
            businessEntityIdToItemsSet.computeIfAbsent(viewField.getBusinessEntityId(), id -> ConcurrentHashMap.newKeySet()).addAll(itemIdSet);
            return Mono.just((Object)itemSet);
        }
        RelationGraph relationGraph = ctx.getRelationGraph();
        UUID rootEntityId = request.getRootEntityId();
        BusinessEntity businessEntity = (BusinessEntity)ctx.getBusinessEntityMap().get(entityId);
        Optional<BusinessEntity> parentBusinessEntityOpt = this.relationGraphService.getParentEntity(relationGraph, rootEntityId, entityId).map(id -> (BusinessEntity)ctx.getBusinessEntityMap().get(id));
        if (parentBusinessEntityOpt.isPresent()) {
            BusinessEntity parentBusinessEntity = parentBusinessEntityOpt.orElseThrow();
            ViewField nearestParentField = (ViewField)ctx.findNearestParentField(parentBusinessEntity.getId(), viewField).orElseThrow();
            Set parentItems = (Set)row.getEntityItems(nearestParentField.getBusinessEntityId(), ctx).orElseThrow();
            resultItems = this.itemService.loadRelated(ctx, viewField, request, parentItems, parentBusinessEntity.getId(), entityId, ctx.getJwtToken());
        } else {
            resultItems = this.itemService.loadItems(businessEntity, viewField, request, ctx, ctx.getJwtToken()).collectList().flatMapMany(items -> this.preloadRelatedItems(ctx, request, items).map(r -> items)).flatMapIterable(l -> l);
        }
        if (request.isPreviewRequest()) {
            resultItems = resultItems.take((long)request.getPreviewItemCount());
        }
        return resultItems.doOnNext(item -> {
            Map businessEntityIdToItemsSet = ctx.getBusinessEntityIdToItemIdSet();
            businessEntityIdToItemsSet.computeIfAbsent(entityId, id -> ConcurrentHashMap.newKeySet()).add(item.getId());
        }).collectList().map(HashSet::new);
    }

    private Mono<Boolean> preloadRelatedItems(ViewContext ctx, ViewRequest request, List<Item> rootItems) {
        if (CollectionUtils.isNotEmpty(rootItems) && this.isRelatedItemsPreloadAllowed(request, ctx)) {
            log.debug("Preload all related items for {} roots", (Object)rootItems.size());
            return this.itemService.loadAllMultiRootRelatedItems(ctx, request, rootItems, ctx.getJwtToken()).collectList().map(i -> true);
        }
        return Mono.just((Object)false);
    }

    private boolean isRelatedItemsPreloadAllowed(ViewRequest request, ViewContext ctx) {
        if (!request.isMultirootItemsLoadingEnabled()) {
            return false;
        }
        long uniqBECount = ctx.getOrderedFields().stream().map(ViewField::getBusinessEntityId).filter(Objects::nonNull).filter(id -> !EntityId.NULL_UUID.equals(id)).distinct().count();
        TbVersion tbVersion = this.tbVersionChecker.getVersion(ctx.getJwtToken());
        return uniqBECount > 1L && tbVersion.getVersion().greaterOrEqual(TbVersionNumber.V_3_3_3);
    }

    private void finishRowProcessing(List<AggregatedValue> values, ViewField viewField, Row row, RowBuilder rowBuilder, ViewRequest request, ViewContext context) {
        int originalSize = values.size();
        this.filterService.loadFilterOptions(context, request);
        values = this.filterService.filterAggregatedValue(values, viewField, request, context);
        if (CollectionUtils.isEmpty((Collection)values) && originalSize == 0) {
            AggregatedValue agValue = new AggregatedValue(new FieldValue((Item)null, FieldType.BLANK, null), Collections.emptySet());
            row.markAsProcessed(viewField, agValue);
        } else if (CollectionUtils.isNotEmpty((Collection)values)) {
            boolean hasDateGroups = values.stream().allMatch(AggregatedValue::hasDateGroups);
            boolean singleValue = values.stream().allMatch(value -> value.getFieldValue() != null);
            if (singleValue == hasDateGroups && !viewField.isMissedRelationField()) {
                throw new IllegalStateException("Different aggregated values states!");
            }
            if (viewField.isHidden()) {
                if (singleValue) {
                    Set hiddenItems = values.stream().map(AggregatedValue::getFieldValue).map(FieldValue::getItems).flatMap(Collection::stream).collect(Collectors.toSet());
                    Set innerValues = values.stream().map(AggregatedValue::getFieldValue).map(FieldValue::getInnerValue).collect(Collectors.toSet());
                    FieldType type = ((BusinessEntityField)context.getBusinessEntityFieldMap().get(viewField.getEntityFieldId())).getType();
                    row.markAsProcessed(viewField, new AggregatedValue(new FieldValue(hiddenItems, type, innerValues), hiddenItems));
                    row.getHiddenValues().put(viewField.getEntityFieldId(), values);
                }
                if (hasDateGroups) {
                    Set items = values.stream().map(AggregatedValue::getItems).flatMap(Collection::stream).collect(Collectors.toSet());
                    HashMap dateGroups = new HashMap();
                    values.forEach(value -> dateGroups.putAll(value.getDateGroups()));
                    AggregatedValue aggregatedValue = new AggregatedValue(null, items, dateGroups);
                    row.markAsProcessed(viewField, aggregatedValue);
                    row.getHiddenValues().put(viewField.getEntityFieldId(), values);
                }
            } else {
                Iterator iterator = values.iterator();
                AggregatedValue firstValue = (AggregatedValue)iterator.next();
                ArrayList<Row> newRows = new ArrayList<Row>(values.size());
                while (iterator.hasNext()) {
                    Row copy = row.copy();
                    AggregatedValue nextValue = (AggregatedValue)iterator.next();
                    copy.markAsProcessed(viewField, nextValue);
                    if (viewField.getEntityFieldId() != null) {
                        copy.getHiddenValues().put(viewField.getEntityFieldId(), Collections.singletonList(nextValue));
                    }
                    newRows.add(copy);
                }
                rowBuilder.addRows(newRows);
                if (viewField.getEntityFieldId() != null) {
                    row.getHiddenValues().put(viewField.getEntityFieldId(), Collections.singletonList(firstValue));
                }
                row.markAsProcessed(viewField, firstValue);
            }
        } else {
            if (viewField.getEntityFieldId() != null) {
                row.getHiddenValues().put(viewField.getEntityFieldId(), values);
            }
            row.markAsProcessed(viewField, new AggregatedValue(new FieldValue(Collections.emptySet(), FieldType.BLANK, null), Collections.emptySet()));
        }
    }
}

