/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.view;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.trendz.domain.base.TimeRange;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;
import org.thingsboard.trendz.domain.definition.view.config.ViewField;
import org.thingsboard.trendz.domain.measurement.MeasurementReport;
import org.thingsboard.trendz.domain.runtime.FieldFilterOption;
import org.thingsboard.trendz.domain.runtime.FieldValue;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.domain.tb.provider.RequestPriority;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.cache.PreloadedCache;
import org.thingsboard.trendz.service.graph.RelationGraph;
import org.thingsboard.trendz.service.provider.tb3.FilterOptionTask;
import org.thingsboard.trendz.service.sql.SqlEntry;
import org.thingsboard.trendz.service.view.proto.RequestStats;
import org.thingsboard.trendz.service.view.proto.RowBuilder;
import org.thingsboard.trendz.service.view.proto.StreamTelemetryStore;

public class ViewContext {
    private static final Logger log = LoggerFactory.getLogger(ViewContext.class);
    private Map<UUID, BusinessEntity> businessEntityMap = new HashMap();
    private Map<UUID, BusinessEntityField> businessEntityFieldMap = new HashMap();
    private Map<UUID, Item> idToItemMap = new ConcurrentHashMap();
    private Map<UUID, Set<UUID>> childItemIdToParentItemIdSetMap = new ConcurrentHashMap();
    private Map<UUID, Set<UUID>> parentItemIdToChildItemIdSetMap = new ConcurrentHashMap();
    private Map<UUID, Set<UUID>> businessEntityIdToItemIdSet = new ConcurrentHashMap();
    private Map<UUID, Set<Object>> distinctFieldValues = new ConcurrentHashMap();
    private Collection<FilterOptionTask> fieldFilterOptionTasks = new ConcurrentLinkedQueue();
    private Map<UUID, String> ownerDictionary = new ConcurrentHashMap();
    private Map<String, AtomicLong> fieldKeyToItemsCnt = new ConcurrentHashMap();
    private Map<String, AtomicLong> fieldKeyToValuesCnt = new ConcurrentHashMap();
    private Map<UUID, StreamTelemetryStore> streamStoreMap = new ConcurrentHashMap();
    private Map<UUID, List<FieldValue>> timeEventFields = new ConcurrentHashMap();
    private Map<UUID, List<SqlEntry>> externalItemValuesMap = new ConcurrentHashMap();
    private long maxRealTs;
    private AtomicLong processFieldMethodIdCounter = new AtomicLong(0L);
    private PreloadedCache preloadedCache = new PreloadedCache();
    private RelationGraph relationGraph;
    private Map<UUID, Integer> distancesFromRoot;
    private List<ViewField> orderedFields;
    private RowBuilder rowBuilder;
    private JwtSecurityUser user;
    private String jwtToken;
    private boolean predictionPreAggregationDisabled;
    private MeasurementReport measurementReport;
    private RequestStats stats;
    private Map<UUID, UUID> predictionToHistoricalFieldMap;
    private Set<UUID> historicalFieldSet;
    private Map<UUID, Map<UUID, Long>> lastHistoricalTsPointMap;
    private final Map<UUID, Map<String, Map<Boolean, Map<TimeRange, Collection<FieldValue>>>>> telemetryRequestCache = new ConcurrentHashMap();
    private RequestPriority priority;
    private final AtomicLong tbTelemetryRequestCount = new AtomicLong(0L);
    private final AtomicLong telemetryPointsCount = new AtomicLong(0L);

    public ViewContext(ViewContext that) {
        throw new NotImplementedException("not yet");
    }

    public ViewContext(List<BusinessEntity> allEntities, RelationGraph relationGraph, JwtSecurityUser user, String jwtToken, RequestPriority priority) {
        for (BusinessEntity entity : allEntities) {
            this.businessEntityMap.put(entity.getId(), entity);
            for (BusinessEntityField entityField : entity.getFields()) {
                this.businessEntityFieldMap.put(entityField.getId(), entityField);
            }
        }
        this.relationGraph = relationGraph;
        this.user = user;
        this.jwtToken = jwtToken;
    }

    public void registerItem(Item item) {
        this.idToItemMap.put(item.getId(), item);
        this.childItemIdToParentItemIdSetMap.computeIfAbsent(item.getId(), id -> ConcurrentHashMap.newKeySet());
        this.parentItemIdToChildItemIdSetMap.computeIfAbsent(item.getId(), id -> ConcurrentHashMap.newKeySet());
        if (item.getParentId() != null) {
            this.childItemIdToParentItemIdSetMap.computeIfAbsent(item.getParentId(), id -> ConcurrentHashMap.newKeySet());
            this.childItemIdToParentItemIdSetMap.computeIfAbsent(item.getId(), id -> ConcurrentHashMap.newKeySet()).add(item.getParentId());
            this.parentItemIdToChildItemIdSetMap.computeIfAbsent(item.getParentId(), id -> ConcurrentHashMap.newKeySet()).add(item.getId());
        }
    }

    public void saveItemTelemetry(UUID itemId, long startTs, long endTs, String telemetryKey, boolean isCountAgg, List<FieldValue> data) {
        TimeRange queriedRange = new TimeRange(startTs, endTs);
        ConcurrentLinkedQueue copyOfData = data.stream().map(FieldValue::new).collect(Collectors.toCollection(ConcurrentLinkedQueue::new));
        this.telemetryRequestCache.computeIfAbsent(itemId, i -> new ConcurrentHashMap()).computeIfAbsent(telemetryKey, i -> new ConcurrentHashMap()).computeIfAbsent(isCountAgg, i -> new ConcurrentHashMap()).put(queriedRange, copyOfData);
    }

    public Collection<FieldValue> getSavedItemTelemetry(UUID itemId, long startTs, long endTs, String telemetryKey, boolean isCountAgg) {
        TimeRange queriedRange = new TimeRange(startTs, endTs);
        Collection fieldValues = (Collection)this.telemetryRequestCache.computeIfAbsent(itemId, i -> new ConcurrentHashMap()).computeIfAbsent(telemetryKey, i -> new ConcurrentHashMap()).computeIfAbsent(isCountAgg, i -> new ConcurrentHashMap()).get(queriedRange);
        if (fieldValues == null) {
            return null;
        }
        return fieldValues.stream().map(FieldValue::new).collect(Collectors.toCollection(ConcurrentLinkedQueue::new));
    }

    public void addFieldValue(UUID viewFieldId, Object value) {
        if (value != null) {
            Set values = this.distinctFieldValues.computeIfAbsent(viewFieldId, k -> ConcurrentHashMap.newKeySet());
            values.add(value);
        }
    }

    public void removeFieldValue(UUID viewFieldId, Object value) {
        if (value != null) {
            Set values = this.distinctFieldValues.computeIfAbsent(viewFieldId, k -> ConcurrentHashMap.newKeySet());
            values.remove(value);
        }
    }

    public List<FieldFilterOption> getFieldFilterOptions() {
        ArrayList result = Lists.newArrayList();
        for (UUID viewFieldId : this.distinctFieldValues.keySet()) {
            TreeSet distinctOptions = new TreeSet(((Set)this.distinctFieldValues.get(viewFieldId)).stream().map(Object::toString).collect(Collectors.toSet()));
            result.add(new FieldFilterOption(viewFieldId, distinctOptions));
        }
        return result;
    }

    public StreamTelemetryStore getStreamStore(UUID beFieldId) {
        return this.streamStoreMap.computeIfAbsent(beFieldId, k -> new StreamTelemetryStore());
    }

    public void addNoneAgrValue(UUID beFieldId, FieldValue fv) {
        List valueStore = this.timeEventFields.computeIfAbsent(beFieldId, id -> new ArrayList());
        if (valueStore.size() < 1000) {
            valueStore.add(fv);
        }
    }

    public Optional<ViewField> findNearestParentField(UUID parentEntityId, ViewField childViewField) {
        ViewField nearest = null;
        for (ViewField viewField : this.orderedFields) {
            if (viewField.getBusinessEntityId().equals(parentEntityId)) {
                nearest = viewField;
            }
            if (!viewField.equals((Object)childViewField)) continue;
            break;
        }
        return Optional.ofNullable(nearest);
    }

    public Relation getParentChildRelation(UUID parentBusinessEntityId, UUID childBusinessEntityId) {
        ArrayList allEntities = new ArrayList(this.businessEntityMap.values());
        List foundRelationFrom = allEntities.stream().filter(entity -> entity.getId().equals(parentBusinessEntityId)).map(BusinessEntity::getRelations).flatMap(Collection::stream).filter(relation -> relation.getRelatedEntityId().equals(childBusinessEntityId)).filter(Relation::isEnabled).collect(Collectors.toList());
        if (foundRelationFrom.size() >= 2) {
            throw new TrendzException("Found unexpected relations count between entities: " + foundRelationFrom.size());
        }
        if (foundRelationFrom.isEmpty()) {
            Optional<Relation> foundRelationTo = allEntities.stream().filter(entity -> entity.getId().equals(childBusinessEntityId)).map(BusinessEntity::getRelations).flatMap(Collection::stream).filter(relation -> relation.getRelatedEntityId().equals(parentBusinessEntityId)).findAny();
            if (foundRelationTo.isEmpty()) {
                throw new IllegalStateException("Expected relation between nodes was not found");
            }
            return foundRelationTo.get();
        }
        return (Relation)foundRelationFrom.iterator().next();
    }

    public void setFieldValuesCnt(ViewField viewField, int count) {
        String key = viewField.getLabel() + "_" + String.valueOf(viewField.getAggregationType());
        this.fieldKeyToValuesCnt.computeIfAbsent(key, k -> new AtomicLong()).addAndGet(count);
    }

    public void setFieldItemsCnt(ViewField viewField, int count) {
        String key = viewField.getLabel() + "_" + String.valueOf(viewField.getAggregationType());
        this.fieldKeyToItemsCnt.computeIfAbsent(key, k -> new AtomicLong()).addAndGet(count);
    }

    public Map<UUID, BusinessEntity> getBusinessEntityMap() {
        return this.businessEntityMap;
    }

    public Map<UUID, BusinessEntityField> getBusinessEntityFieldMap() {
        return this.businessEntityFieldMap;
    }

    public Map<UUID, Item> getIdToItemMap() {
        return this.idToItemMap;
    }

    public Map<UUID, Set<UUID>> getChildItemIdToParentItemIdSetMap() {
        return this.childItemIdToParentItemIdSetMap;
    }

    public Map<UUID, Set<UUID>> getParentItemIdToChildItemIdSetMap() {
        return this.parentItemIdToChildItemIdSetMap;
    }

    public Map<UUID, Set<UUID>> getBusinessEntityIdToItemIdSet() {
        return this.businessEntityIdToItemIdSet;
    }

    public Map<UUID, Set<Object>> getDistinctFieldValues() {
        return this.distinctFieldValues;
    }

    public Collection<FilterOptionTask> getFieldFilterOptionTasks() {
        return this.fieldFilterOptionTasks;
    }

    public Map<UUID, String> getOwnerDictionary() {
        return this.ownerDictionary;
    }

    public Map<String, AtomicLong> getFieldKeyToItemsCnt() {
        return this.fieldKeyToItemsCnt;
    }

    public Map<String, AtomicLong> getFieldKeyToValuesCnt() {
        return this.fieldKeyToValuesCnt;
    }

    public Map<UUID, StreamTelemetryStore> getStreamStoreMap() {
        return this.streamStoreMap;
    }

    public Map<UUID, List<FieldValue>> getTimeEventFields() {
        return this.timeEventFields;
    }

    public Map<UUID, List<SqlEntry>> getExternalItemValuesMap() {
        return this.externalItemValuesMap;
    }

    public long getMaxRealTs() {
        return this.maxRealTs;
    }

    public AtomicLong getProcessFieldMethodIdCounter() {
        return this.processFieldMethodIdCounter;
    }

    public PreloadedCache getPreloadedCache() {
        return this.preloadedCache;
    }

    public RelationGraph getRelationGraph() {
        return this.relationGraph;
    }

    public Map<UUID, Integer> getDistancesFromRoot() {
        return this.distancesFromRoot;
    }

    public List<ViewField> getOrderedFields() {
        return this.orderedFields;
    }

    public RowBuilder getRowBuilder() {
        return this.rowBuilder;
    }

    public JwtSecurityUser getUser() {
        return this.user;
    }

    public String getJwtToken() {
        return this.jwtToken;
    }

    public boolean isPredictionPreAggregationDisabled() {
        return this.predictionPreAggregationDisabled;
    }

    public MeasurementReport getMeasurementReport() {
        return this.measurementReport;
    }

    public RequestStats getStats() {
        return this.stats;
    }

    public Map<UUID, UUID> getPredictionToHistoricalFieldMap() {
        return this.predictionToHistoricalFieldMap;
    }

    public Set<UUID> getHistoricalFieldSet() {
        return this.historicalFieldSet;
    }

    public Map<UUID, Map<UUID, Long>> getLastHistoricalTsPointMap() {
        return this.lastHistoricalTsPointMap;
    }

    public Map<UUID, Map<String, Map<Boolean, Map<TimeRange, Collection<FieldValue>>>>> getTelemetryRequestCache() {
        return this.telemetryRequestCache;
    }

    public RequestPriority getPriority() {
        return this.priority;
    }

    public AtomicLong getTbTelemetryRequestCount() {
        return this.tbTelemetryRequestCount;
    }

    public AtomicLong getTelemetryPointsCount() {
        return this.telemetryPointsCount;
    }

    public void setBusinessEntityMap(Map<UUID, BusinessEntity> businessEntityMap) {
        this.businessEntityMap = businessEntityMap;
    }

    public void setBusinessEntityFieldMap(Map<UUID, BusinessEntityField> businessEntityFieldMap) {
        this.businessEntityFieldMap = businessEntityFieldMap;
    }

    public void setIdToItemMap(Map<UUID, Item> idToItemMap) {
        this.idToItemMap = idToItemMap;
    }

    public void setChildItemIdToParentItemIdSetMap(Map<UUID, Set<UUID>> childItemIdToParentItemIdSetMap) {
        this.childItemIdToParentItemIdSetMap = childItemIdToParentItemIdSetMap;
    }

    public void setParentItemIdToChildItemIdSetMap(Map<UUID, Set<UUID>> parentItemIdToChildItemIdSetMap) {
        this.parentItemIdToChildItemIdSetMap = parentItemIdToChildItemIdSetMap;
    }

    public void setBusinessEntityIdToItemIdSet(Map<UUID, Set<UUID>> businessEntityIdToItemIdSet) {
        this.businessEntityIdToItemIdSet = businessEntityIdToItemIdSet;
    }

    public void setDistinctFieldValues(Map<UUID, Set<Object>> distinctFieldValues) {
        this.distinctFieldValues = distinctFieldValues;
    }

    public void setFieldFilterOptionTasks(Collection<FilterOptionTask> fieldFilterOptionTasks) {
        this.fieldFilterOptionTasks = fieldFilterOptionTasks;
    }

    public void setOwnerDictionary(Map<UUID, String> ownerDictionary) {
        this.ownerDictionary = ownerDictionary;
    }

    public void setFieldKeyToItemsCnt(Map<String, AtomicLong> fieldKeyToItemsCnt) {
        this.fieldKeyToItemsCnt = fieldKeyToItemsCnt;
    }

    public void setFieldKeyToValuesCnt(Map<String, AtomicLong> fieldKeyToValuesCnt) {
        this.fieldKeyToValuesCnt = fieldKeyToValuesCnt;
    }

    public void setStreamStoreMap(Map<UUID, StreamTelemetryStore> streamStoreMap) {
        this.streamStoreMap = streamStoreMap;
    }

    public void setTimeEventFields(Map<UUID, List<FieldValue>> timeEventFields) {
        this.timeEventFields = timeEventFields;
    }

    public void setExternalItemValuesMap(Map<UUID, List<SqlEntry>> externalItemValuesMap) {
        this.externalItemValuesMap = externalItemValuesMap;
    }

    public void setMaxRealTs(long maxRealTs) {
        this.maxRealTs = maxRealTs;
    }

    public void setProcessFieldMethodIdCounter(AtomicLong processFieldMethodIdCounter) {
        this.processFieldMethodIdCounter = processFieldMethodIdCounter;
    }

    public void setPreloadedCache(PreloadedCache preloadedCache) {
        this.preloadedCache = preloadedCache;
    }

    public void setRelationGraph(RelationGraph relationGraph) {
        this.relationGraph = relationGraph;
    }

    public void setDistancesFromRoot(Map<UUID, Integer> distancesFromRoot) {
        this.distancesFromRoot = distancesFromRoot;
    }

    public void setOrderedFields(List<ViewField> orderedFields) {
        this.orderedFields = orderedFields;
    }

    public void setRowBuilder(RowBuilder rowBuilder) {
        this.rowBuilder = rowBuilder;
    }

    public void setUser(JwtSecurityUser user) {
        this.user = user;
    }

    public void setJwtToken(String jwtToken) {
        this.jwtToken = jwtToken;
    }

    public void setPredictionPreAggregationDisabled(boolean predictionPreAggregationDisabled) {
        this.predictionPreAggregationDisabled = predictionPreAggregationDisabled;
    }

    public void setMeasurementReport(MeasurementReport measurementReport) {
        this.measurementReport = measurementReport;
    }

    public void setStats(RequestStats stats) {
        this.stats = stats;
    }

    public void setPredictionToHistoricalFieldMap(Map<UUID, UUID> predictionToHistoricalFieldMap) {
        this.predictionToHistoricalFieldMap = predictionToHistoricalFieldMap;
    }

    public void setHistoricalFieldSet(Set<UUID> historicalFieldSet) {
        this.historicalFieldSet = historicalFieldSet;
    }

    public void setLastHistoricalTsPointMap(Map<UUID, Map<UUID, Long>> lastHistoricalTsPointMap) {
        this.lastHistoricalTsPointMap = lastHistoricalTsPointMap;
    }

    public void setPriority(RequestPriority priority) {
        this.priority = priority;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ViewContext)) {
            return false;
        }
        ViewContext other = (ViewContext)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getMaxRealTs() != other.getMaxRealTs()) {
            return false;
        }
        if (this.isPredictionPreAggregationDisabled() != other.isPredictionPreAggregationDisabled()) {
            return false;
        }
        Map this$businessEntityMap = this.getBusinessEntityMap();
        Map other$businessEntityMap = other.getBusinessEntityMap();
        if (this$businessEntityMap == null ? other$businessEntityMap != null : !((Object)this$businessEntityMap).equals(other$businessEntityMap)) {
            return false;
        }
        Map this$businessEntityFieldMap = this.getBusinessEntityFieldMap();
        Map other$businessEntityFieldMap = other.getBusinessEntityFieldMap();
        if (this$businessEntityFieldMap == null ? other$businessEntityFieldMap != null : !((Object)this$businessEntityFieldMap).equals(other$businessEntityFieldMap)) {
            return false;
        }
        Map this$idToItemMap = this.getIdToItemMap();
        Map other$idToItemMap = other.getIdToItemMap();
        if (this$idToItemMap == null ? other$idToItemMap != null : !((Object)this$idToItemMap).equals(other$idToItemMap)) {
            return false;
        }
        Map this$childItemIdToParentItemIdSetMap = this.getChildItemIdToParentItemIdSetMap();
        Map other$childItemIdToParentItemIdSetMap = other.getChildItemIdToParentItemIdSetMap();
        if (this$childItemIdToParentItemIdSetMap == null ? other$childItemIdToParentItemIdSetMap != null : !((Object)this$childItemIdToParentItemIdSetMap).equals(other$childItemIdToParentItemIdSetMap)) {
            return false;
        }
        Map this$parentItemIdToChildItemIdSetMap = this.getParentItemIdToChildItemIdSetMap();
        Map other$parentItemIdToChildItemIdSetMap = other.getParentItemIdToChildItemIdSetMap();
        if (this$parentItemIdToChildItemIdSetMap == null ? other$parentItemIdToChildItemIdSetMap != null : !((Object)this$parentItemIdToChildItemIdSetMap).equals(other$parentItemIdToChildItemIdSetMap)) {
            return false;
        }
        Map this$businessEntityIdToItemIdSet = this.getBusinessEntityIdToItemIdSet();
        Map other$businessEntityIdToItemIdSet = other.getBusinessEntityIdToItemIdSet();
        if (this$businessEntityIdToItemIdSet == null ? other$businessEntityIdToItemIdSet != null : !((Object)this$businessEntityIdToItemIdSet).equals(other$businessEntityIdToItemIdSet)) {
            return false;
        }
        Map this$distinctFieldValues = this.getDistinctFieldValues();
        Map other$distinctFieldValues = other.getDistinctFieldValues();
        if (this$distinctFieldValues == null ? other$distinctFieldValues != null : !((Object)this$distinctFieldValues).equals(other$distinctFieldValues)) {
            return false;
        }
        Collection this$fieldFilterOptionTasks = this.getFieldFilterOptionTasks();
        Collection other$fieldFilterOptionTasks = other.getFieldFilterOptionTasks();
        if (this$fieldFilterOptionTasks == null ? other$fieldFilterOptionTasks != null : !((Object)this$fieldFilterOptionTasks).equals(other$fieldFilterOptionTasks)) {
            return false;
        }
        Map this$ownerDictionary = this.getOwnerDictionary();
        Map other$ownerDictionary = other.getOwnerDictionary();
        if (this$ownerDictionary == null ? other$ownerDictionary != null : !((Object)this$ownerDictionary).equals(other$ownerDictionary)) {
            return false;
        }
        Map this$fieldKeyToItemsCnt = this.getFieldKeyToItemsCnt();
        Map other$fieldKeyToItemsCnt = other.getFieldKeyToItemsCnt();
        if (this$fieldKeyToItemsCnt == null ? other$fieldKeyToItemsCnt != null : !((Object)this$fieldKeyToItemsCnt).equals(other$fieldKeyToItemsCnt)) {
            return false;
        }
        Map this$fieldKeyToValuesCnt = this.getFieldKeyToValuesCnt();
        Map other$fieldKeyToValuesCnt = other.getFieldKeyToValuesCnt();
        if (this$fieldKeyToValuesCnt == null ? other$fieldKeyToValuesCnt != null : !((Object)this$fieldKeyToValuesCnt).equals(other$fieldKeyToValuesCnt)) {
            return false;
        }
        Map this$streamStoreMap = this.getStreamStoreMap();
        Map other$streamStoreMap = other.getStreamStoreMap();
        if (this$streamStoreMap == null ? other$streamStoreMap != null : !((Object)this$streamStoreMap).equals(other$streamStoreMap)) {
            return false;
        }
        Map this$timeEventFields = this.getTimeEventFields();
        Map other$timeEventFields = other.getTimeEventFields();
        if (this$timeEventFields == null ? other$timeEventFields != null : !((Object)this$timeEventFields).equals(other$timeEventFields)) {
            return false;
        }
        Map this$externalItemValuesMap = this.getExternalItemValuesMap();
        Map other$externalItemValuesMap = other.getExternalItemValuesMap();
        if (this$externalItemValuesMap == null ? other$externalItemValuesMap != null : !((Object)this$externalItemValuesMap).equals(other$externalItemValuesMap)) {
            return false;
        }
        AtomicLong this$processFieldMethodIdCounter = this.getProcessFieldMethodIdCounter();
        AtomicLong other$processFieldMethodIdCounter = other.getProcessFieldMethodIdCounter();
        if (this$processFieldMethodIdCounter == null ? other$processFieldMethodIdCounter != null : !this$processFieldMethodIdCounter.equals(other$processFieldMethodIdCounter)) {
            return false;
        }
        PreloadedCache this$preloadedCache = this.getPreloadedCache();
        PreloadedCache other$preloadedCache = other.getPreloadedCache();
        if (this$preloadedCache == null ? other$preloadedCache != null : !this$preloadedCache.equals(other$preloadedCache)) {
            return false;
        }
        RelationGraph this$relationGraph = this.getRelationGraph();
        RelationGraph other$relationGraph = other.getRelationGraph();
        if (this$relationGraph == null ? other$relationGraph != null : !this$relationGraph.equals(other$relationGraph)) {
            return false;
        }
        Map this$distancesFromRoot = this.getDistancesFromRoot();
        Map other$distancesFromRoot = other.getDistancesFromRoot();
        if (this$distancesFromRoot == null ? other$distancesFromRoot != null : !((Object)this$distancesFromRoot).equals(other$distancesFromRoot)) {
            return false;
        }
        List this$orderedFields = this.getOrderedFields();
        List other$orderedFields = other.getOrderedFields();
        if (this$orderedFields == null ? other$orderedFields != null : !((Object)this$orderedFields).equals(other$orderedFields)) {
            return false;
        }
        RowBuilder this$rowBuilder = this.getRowBuilder();
        RowBuilder other$rowBuilder = other.getRowBuilder();
        if (this$rowBuilder == null ? other$rowBuilder != null : !this$rowBuilder.equals(other$rowBuilder)) {
            return false;
        }
        JwtSecurityUser this$user = this.getUser();
        JwtSecurityUser other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$jwtToken = this.getJwtToken();
        String other$jwtToken = other.getJwtToken();
        if (this$jwtToken == null ? other$jwtToken != null : !this$jwtToken.equals(other$jwtToken)) {
            return false;
        }
        MeasurementReport this$measurementReport = this.getMeasurementReport();
        MeasurementReport other$measurementReport = other.getMeasurementReport();
        if (this$measurementReport == null ? other$measurementReport != null : !this$measurementReport.equals(other$measurementReport)) {
            return false;
        }
        RequestStats this$stats = this.getStats();
        RequestStats other$stats = other.getStats();
        if (this$stats == null ? other$stats != null : !this$stats.equals(other$stats)) {
            return false;
        }
        Map this$predictionToHistoricalFieldMap = this.getPredictionToHistoricalFieldMap();
        Map other$predictionToHistoricalFieldMap = other.getPredictionToHistoricalFieldMap();
        if (this$predictionToHistoricalFieldMap == null ? other$predictionToHistoricalFieldMap != null : !((Object)this$predictionToHistoricalFieldMap).equals(other$predictionToHistoricalFieldMap)) {
            return false;
        }
        Set this$historicalFieldSet = this.getHistoricalFieldSet();
        Set other$historicalFieldSet = other.getHistoricalFieldSet();
        if (this$historicalFieldSet == null ? other$historicalFieldSet != null : !((Object)this$historicalFieldSet).equals(other$historicalFieldSet)) {
            return false;
        }
        Map this$lastHistoricalTsPointMap = this.getLastHistoricalTsPointMap();
        Map other$lastHistoricalTsPointMap = other.getLastHistoricalTsPointMap();
        if (this$lastHistoricalTsPointMap == null ? other$lastHistoricalTsPointMap != null : !((Object)this$lastHistoricalTsPointMap).equals(other$lastHistoricalTsPointMap)) {
            return false;
        }
        Map this$telemetryRequestCache = this.getTelemetryRequestCache();
        Map other$telemetryRequestCache = other.getTelemetryRequestCache();
        if (this$telemetryRequestCache == null ? other$telemetryRequestCache != null : !((Object)this$telemetryRequestCache).equals(other$telemetryRequestCache)) {
            return false;
        }
        RequestPriority this$priority = this.getPriority();
        RequestPriority other$priority = other.getPriority();
        if (this$priority == null ? other$priority != null : !this$priority.equals(other$priority)) {
            return false;
        }
        AtomicLong this$tbTelemetryRequestCount = this.getTbTelemetryRequestCount();
        AtomicLong other$tbTelemetryRequestCount = other.getTbTelemetryRequestCount();
        if (this$tbTelemetryRequestCount == null ? other$tbTelemetryRequestCount != null : !this$tbTelemetryRequestCount.equals(other$tbTelemetryRequestCount)) {
            return false;
        }
        AtomicLong this$telemetryPointsCount = this.getTelemetryPointsCount();
        AtomicLong other$telemetryPointsCount = other.getTelemetryPointsCount();
        return !(this$telemetryPointsCount == null ? other$telemetryPointsCount != null : !this$telemetryPointsCount.equals(other$telemetryPointsCount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ViewContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxRealTs = this.getMaxRealTs();
        result = result * 59 + (int)($maxRealTs >>> 32 ^ $maxRealTs);
        result = result * 59 + (this.isPredictionPreAggregationDisabled() ? 79 : 97);
        Map $businessEntityMap = this.getBusinessEntityMap();
        result = result * 59 + ($businessEntityMap == null ? 43 : ((Object)$businessEntityMap).hashCode());
        Map $businessEntityFieldMap = this.getBusinessEntityFieldMap();
        result = result * 59 + ($businessEntityFieldMap == null ? 43 : ((Object)$businessEntityFieldMap).hashCode());
        Map $idToItemMap = this.getIdToItemMap();
        result = result * 59 + ($idToItemMap == null ? 43 : ((Object)$idToItemMap).hashCode());
        Map $childItemIdToParentItemIdSetMap = this.getChildItemIdToParentItemIdSetMap();
        result = result * 59 + ($childItemIdToParentItemIdSetMap == null ? 43 : ((Object)$childItemIdToParentItemIdSetMap).hashCode());
        Map $parentItemIdToChildItemIdSetMap = this.getParentItemIdToChildItemIdSetMap();
        result = result * 59 + ($parentItemIdToChildItemIdSetMap == null ? 43 : ((Object)$parentItemIdToChildItemIdSetMap).hashCode());
        Map $businessEntityIdToItemIdSet = this.getBusinessEntityIdToItemIdSet();
        result = result * 59 + ($businessEntityIdToItemIdSet == null ? 43 : ((Object)$businessEntityIdToItemIdSet).hashCode());
        Map $distinctFieldValues = this.getDistinctFieldValues();
        result = result * 59 + ($distinctFieldValues == null ? 43 : ((Object)$distinctFieldValues).hashCode());
        Collection $fieldFilterOptionTasks = this.getFieldFilterOptionTasks();
        result = result * 59 + ($fieldFilterOptionTasks == null ? 43 : ((Object)$fieldFilterOptionTasks).hashCode());
        Map $ownerDictionary = this.getOwnerDictionary();
        result = result * 59 + ($ownerDictionary == null ? 43 : ((Object)$ownerDictionary).hashCode());
        Map $fieldKeyToItemsCnt = this.getFieldKeyToItemsCnt();
        result = result * 59 + ($fieldKeyToItemsCnt == null ? 43 : ((Object)$fieldKeyToItemsCnt).hashCode());
        Map $fieldKeyToValuesCnt = this.getFieldKeyToValuesCnt();
        result = result * 59 + ($fieldKeyToValuesCnt == null ? 43 : ((Object)$fieldKeyToValuesCnt).hashCode());
        Map $streamStoreMap = this.getStreamStoreMap();
        result = result * 59 + ($streamStoreMap == null ? 43 : ((Object)$streamStoreMap).hashCode());
        Map $timeEventFields = this.getTimeEventFields();
        result = result * 59 + ($timeEventFields == null ? 43 : ((Object)$timeEventFields).hashCode());
        Map $externalItemValuesMap = this.getExternalItemValuesMap();
        result = result * 59 + ($externalItemValuesMap == null ? 43 : ((Object)$externalItemValuesMap).hashCode());
        AtomicLong $processFieldMethodIdCounter = this.getProcessFieldMethodIdCounter();
        result = result * 59 + ($processFieldMethodIdCounter == null ? 43 : $processFieldMethodIdCounter.hashCode());
        PreloadedCache $preloadedCache = this.getPreloadedCache();
        result = result * 59 + ($preloadedCache == null ? 43 : $preloadedCache.hashCode());
        RelationGraph $relationGraph = this.getRelationGraph();
        result = result * 59 + ($relationGraph == null ? 43 : $relationGraph.hashCode());
        Map $distancesFromRoot = this.getDistancesFromRoot();
        result = result * 59 + ($distancesFromRoot == null ? 43 : ((Object)$distancesFromRoot).hashCode());
        List $orderedFields = this.getOrderedFields();
        result = result * 59 + ($orderedFields == null ? 43 : ((Object)$orderedFields).hashCode());
        RowBuilder $rowBuilder = this.getRowBuilder();
        result = result * 59 + ($rowBuilder == null ? 43 : $rowBuilder.hashCode());
        JwtSecurityUser $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $jwtToken = this.getJwtToken();
        result = result * 59 + ($jwtToken == null ? 43 : $jwtToken.hashCode());
        MeasurementReport $measurementReport = this.getMeasurementReport();
        result = result * 59 + ($measurementReport == null ? 43 : $measurementReport.hashCode());
        RequestStats $stats = this.getStats();
        result = result * 59 + ($stats == null ? 43 : $stats.hashCode());
        Map $predictionToHistoricalFieldMap = this.getPredictionToHistoricalFieldMap();
        result = result * 59 + ($predictionToHistoricalFieldMap == null ? 43 : ((Object)$predictionToHistoricalFieldMap).hashCode());
        Set $historicalFieldSet = this.getHistoricalFieldSet();
        result = result * 59 + ($historicalFieldSet == null ? 43 : ((Object)$historicalFieldSet).hashCode());
        Map $lastHistoricalTsPointMap = this.getLastHistoricalTsPointMap();
        result = result * 59 + ($lastHistoricalTsPointMap == null ? 43 : ((Object)$lastHistoricalTsPointMap).hashCode());
        Map $telemetryRequestCache = this.getTelemetryRequestCache();
        result = result * 59 + ($telemetryRequestCache == null ? 43 : ((Object)$telemetryRequestCache).hashCode());
        RequestPriority $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : $priority.hashCode());
        AtomicLong $tbTelemetryRequestCount = this.getTbTelemetryRequestCount();
        result = result * 59 + ($tbTelemetryRequestCount == null ? 43 : $tbTelemetryRequestCount.hashCode());
        AtomicLong $telemetryPointsCount = this.getTelemetryPointsCount();
        result = result * 59 + ($telemetryPointsCount == null ? 43 : $telemetryPointsCount.hashCode());
        return result;
    }

    public String toString() {
        return "ViewContext(businessEntityMap=" + String.valueOf(this.getBusinessEntityMap()) + ", businessEntityFieldMap=" + String.valueOf(this.getBusinessEntityFieldMap()) + ", idToItemMap=" + String.valueOf(this.getIdToItemMap()) + ", childItemIdToParentItemIdSetMap=" + String.valueOf(this.getChildItemIdToParentItemIdSetMap()) + ", parentItemIdToChildItemIdSetMap=" + String.valueOf(this.getParentItemIdToChildItemIdSetMap()) + ", businessEntityIdToItemIdSet=" + String.valueOf(this.getBusinessEntityIdToItemIdSet()) + ", distinctFieldValues=" + String.valueOf(this.getDistinctFieldValues()) + ", fieldFilterOptionTasks=" + String.valueOf(this.getFieldFilterOptionTasks()) + ", ownerDictionary=" + String.valueOf(this.getOwnerDictionary()) + ", fieldKeyToItemsCnt=" + String.valueOf(this.getFieldKeyToItemsCnt()) + ", fieldKeyToValuesCnt=" + String.valueOf(this.getFieldKeyToValuesCnt()) + ", streamStoreMap=" + String.valueOf(this.getStreamStoreMap()) + ", timeEventFields=" + String.valueOf(this.getTimeEventFields()) + ", externalItemValuesMap=" + String.valueOf(this.getExternalItemValuesMap()) + ", maxRealTs=" + this.getMaxRealTs() + ", processFieldMethodIdCounter=" + String.valueOf(this.getProcessFieldMethodIdCounter()) + ", preloadedCache=" + String.valueOf(this.getPreloadedCache()) + ", relationGraph=" + String.valueOf(this.getRelationGraph()) + ", distancesFromRoot=" + String.valueOf(this.getDistancesFromRoot()) + ", orderedFields=" + String.valueOf(this.getOrderedFields()) + ", rowBuilder=" + String.valueOf(this.getRowBuilder()) + ", user=" + String.valueOf(this.getUser()) + ", jwtToken=" + this.getJwtToken() + ", predictionPreAggregationDisabled=" + this.isPredictionPreAggregationDisabled() + ", measurementReport=" + String.valueOf(this.getMeasurementReport()) + ", stats=" + String.valueOf(this.getStats()) + ", predictionToHistoricalFieldMap=" + String.valueOf(this.getPredictionToHistoricalFieldMap()) + ", historicalFieldSet=" + String.valueOf(this.getHistoricalFieldSet()) + ", lastHistoricalTsPointMap=" + String.valueOf(this.getLastHistoricalTsPointMap()) + ", telemetryRequestCache=" + String.valueOf(this.getTelemetryRequestCache()) + ", priority=" + String.valueOf(this.getPriority()) + ", tbTelemetryRequestCount=" + String.valueOf(this.getTbTelemetryRequestCount()) + ", telemetryPointsCount=" + String.valueOf(this.getTelemetryPointsCount()) + ")";
    }

    private static /* synthetic */ Map.Entry lambda$new$0(Map.Entry entry) {
        return Map.entry((UUID)entry.getKey(), (Map)entry.getValue());
    }
}

