/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.user;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.trendz.dao.user.UserMetadataDao;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfig;
import org.thingsboard.trendz.domain.definition.view.config.DatePickerConfigSelectType;
import org.thingsboard.trendz.domain.runtime.ItemLite;
import org.thingsboard.trendz.domain.user.UserMetadata;
import org.thingsboard.trendz.exception.service.definition.BusinessEntityNotFoundException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.service.definition.BusinessEntityService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Mono;

@Service
public class UserMetadataService {
    private final BusinessEntityService businessEntityService;
    private final UserMetadataDao userMetadataDao;
    private final TbRestDataSource tbRestDataSource;

    @Autowired
    public UserMetadataService(BusinessEntityService businessEntityService, UserMetadataDao userMetadataDao, TbRestDataSource tbRestDataSource) {
        this.businessEntityService = businessEntityService;
        this.userMetadataDao = userMetadataDao;
        this.tbRestDataSource = tbRestDataSource;
    }

    public DatePickerConfig getDatePickerConfig(JwtSecurityUser user) {
        return this.userMetadataDao.getMetadata(user).map(UserMetadata::getDefaultDatePickerConfig).orElseGet(() -> DatePickerConfig.builder().relativeLastAmount(1).relativeUnit("this").selectedUnit(new DatePickerConfigSelectType("Weeks", DatePickerConfigSelectType.Value.week, false)).selectedType(new DatePickerConfigSelectType("Relative Dates", DatePickerConfigSelectType.Value.relative, true)).build());
    }

    public void saveDatePickerConfig(JwtSecurityUser user, DatePickerConfig datePickerConfig) {
        this.userMetadataDao.updateMetadata(user, datePickerConfig, null, null);
    }

    public UUID getBusinessEntityId(JwtSecurityUser user) {
        Optional<UUID> entityIdOptional = this.userMetadataDao.getMetadata(user).map(UserMetadata::getDefaultBusinessEntityId).filter(id -> !EntityId.NULL_UUID.equals(id));
        if (entityIdOptional.isEmpty()) {
            return EntityId.NULL_UUID;
        }
        UUID entityId = entityIdOptional.get();
        if (this.businessEntityService.findEntityById(user, entityId).isEmpty()) {
            this.userMetadataDao.updateMetadata(user, null, EntityId.NULL_UUID, null);
            return EntityId.NULL_UUID;
        }
        return entityId;
    }

    public void saveBusinessEntityId(JwtSecurityUser user, UUID entityId) {
        if (!EntityId.NULL_UUID.equals(entityId)) {
            this.businessEntityService.findEntityById(user, entityId).orElseThrow(() -> new BusinessEntityNotFoundException(entityId, user.getTenantId()));
        }
        this.userMetadataDao.updateMetadata(user, null, entityId, null);
    }

    public List<UserMetadata> saveAll(List<UserMetadata> userMetadata) {
        return this.userMetadataDao.saveAll(userMetadata);
    }

    public List<UserMetadata> getAll(JwtSecurityUser user) {
        return this.userMetadataDao.findAllByTenantId(user);
    }

    public ItemLite getItem(JwtSecurityUser user, String jwtToken) {
        return this.userMetadataDao.getMetadata(user).map(UserMetadata::getDefaultItem).orElseGet(() -> ((Optional)DonReactive.block((Mono)this.tbRestDataSource.getLastActiveEntity(user, jwtToken))).orElseGet(ItemLite::new));
    }

    public void saveItem(JwtSecurityUser user, ItemLite item) {
        this.userMetadataDao.updateMetadata(user, null, null, item);
    }
}

