/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.translation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.tools.DonReactive;
import org.thingsboard.trendz.tools.json.JsonUtils;
import reactor.core.publisher.Mono;

@Service
public class TranslationService {
    private static final Logger log = LoggerFactory.getLogger(TranslationService.class);
    private final TbRestDataSource tbRestDataSource;

    @Autowired
    public TranslationService(TbRestDataSource tbRestDataSource) {
        this.tbRestDataSource = tbRestDataSource;
    }

    public String getTranslationsBeforeLogin(String forLocale) {
        return (String)DonReactive.block((Mono)this.tbRestDataSource.loadTranslationBeforeLogin(forLocale));
    }

    public String getTranslationAfterLogin(String forLocale, String jwtToken) {
        List translations = (List)DonReactive.block((Mono)this.tbRestDataSource.loadTranslationsAfterLogin(forLocale, jwtToken));
        return switch (translations.size()) {
            case 1 -> (String)translations.get(0);
            case 2 -> this.mergeTbTranslationWithCustom((String)translations.get(0), (String)translations.get(1), forLocale);
            default -> throw new TrendzException("Could not load translations. Translations response size: " + translations.size());
        };
    }

    private String mergeTbTranslationWithCustom(String customTranslation, String tbTranslation, String locale) {
        try {
            JsonNode customTranslationNode = JsonUtils.toNodeFromRaw((String)customTranslation);
            JsonNode tbTranslationNode = JsonUtils.toNodeFromRaw((String)tbTranslation);
            if (!customTranslationNode.has("translationMap")) {
                return tbTranslation;
            }
            JsonNode translationMap = customTranslationNode.get("translationMap");
            if (!translationMap.has(locale)) {
                return tbTranslation;
            }
            JsonNode customTranslationForLocale = translationMap.get(locale);
            if (!customTranslationForLocale.isTextual()) {
                return tbTranslation;
            }
            JsonNode parsedCustomTranslationForLocale = JsonUtils.getObjectMapper().readTree(customTranslationForLocale.asText());
            if (!(parsedCustomTranslationForLocale instanceof ObjectNode)) {
                return tbTranslation;
            }
            return JsonUtils.getObjectMapper().readerForUpdating((Object)tbTranslationNode).readValue(parsedCustomTranslationForLocale).toString();
        }
        catch (IOException e) {
            throw new TrendzException("Could not update translations with custom translations", (Throwable)e);
        }
    }
}

