/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.topology;

import com.google.common.collect.Lists;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.trendz.dao.TimeStampUUIDGenerator;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityQuery;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntityType;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityField;
import org.thingsboard.trendz.domain.definition.entity.field.BusinessEntityFieldQuery;
import org.thingsboard.trendz.domain.definition.entity.field.FieldQueryType;
import org.thingsboard.trendz.domain.definition.entity.field.FieldType;
import org.thingsboard.trendz.exception.TrendzException;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.service.AuthenticationService;
import org.thingsboard.trendz.service.provider.TbAssetService;
import org.thingsboard.trendz.service.provider.TbDeviceService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.task.TaskExecutionProgressDecorator;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.progress_content.TopologyDiscoveryProgressContent;
import org.thingsboard.trendz.service.topology.DiscoverConfig;
import org.thingsboard.trendz.service.topology.TbRelationDiscovery;
import org.thingsboard.trendz.service.topology.TopologyDiscoveryService;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class TbTopologyDiscoveryService
implements TopologyDiscoveryService {
    private static final Logger log = LoggerFactory.getLogger(TbTopologyDiscoveryService.class);
    private final AuthenticationService authenticationService;
    private final TbRelationDiscovery relationDiscovery;
    private final TbAssetService assetService;
    private final TbDeviceService deviceService;
    private final TbRestDataSource apiClient;

    @Autowired
    public TbTopologyDiscoveryService(AuthenticationService authenticationService, TbRelationDiscovery relationDiscovery, TbAssetService assetService, TbDeviceService deviceService, TbRestDataSource apiClient) {
        this.authenticationService = authenticationService;
        this.relationDiscovery = relationDiscovery;
        this.assetService = assetService;
        this.deviceService = deviceService;
        this.apiClient = apiClient;
    }

    @TaskExecutionProgressDecorator(name="Discovering actual topology entities")
    public List<BusinessEntity> discoverTopology(TaskExecutionProgressStepBuilder parentStepBuilder, DiscoverConfig discoverConfig, JwtSecurityUser user) {
        List deviceSchema;
        List assetSchema;
        TopologyDiscoveryProgressContent mutableContent = (TopologyDiscoveryProgressContent)parentStepBuilder.getStepContent(TopologyDiscoveryProgressContent.class);
        mutableContent.setCurrentState("Start new topology discovery");
        ArrayList<BusinessEntity> businessEntities = new ArrayList<BusinessEntity>();
        try (TaskExecutionProgressStepBuilder stepBuilder = parentStepBuilder.makeStep("fetch asset schema");){
            assetSchema = this.fetchAssetSchema(stepBuilder, discoverConfig, user);
        }
        stepBuilder = parentStepBuilder.makeStep("fetch device schema");
        try {
            deviceSchema = this.fetchDeviceSchema(stepBuilder, discoverConfig, user);
        }
        finally {
            if (stepBuilder != null) {
                stepBuilder.close();
            }
        }
        stepBuilder = parentStepBuilder.makeStep("unite schema");
        try {
            businessEntities.addAll(assetSchema);
            businessEntities.addAll(deviceSchema);
            for (BusinessEntity businessEntity : businessEntities) {
                for (BusinessEntityField businessEntityField : businessEntity.getFields()) {
                    businessEntityField.setId(TimeStampUUIDGenerator.generateId());
                    businessEntityField.setBusinessEntityId(businessEntity.getId());
                }
            }
        }
        finally {
            if (stepBuilder != null) {
                stepBuilder.close();
            }
        }
        stepBuilder = parentStepBuilder.makeStep("discovery relations");
        try {
            this.relationDiscovery.discoverRelations(stepBuilder, businessEntities, discoverConfig, user);
        }
        finally {
            if (stepBuilder != null) {
                stepBuilder.close();
            }
        }
        log.info("Discovered topology has {} business entities.", (Object)businessEntities.size());
        return businessEntities;
    }

    private List<BusinessEntity> fetchAssetSchema(TaskExecutionProgressStepBuilder stepBuilder, DiscoverConfig discoverConfig, JwtSecurityUser user) {
        TopologyDiscoveryProgressContent mutableContent = (TopologyDiscoveryProgressContent)stepBuilder.getStepContent(TopologyDiscoveryProgressContent.class);
        mutableContent.setCurrentState("Discover assets");
        String jwtToken = this.authenticationService.getToken(user);
        Set assetTypes = this.assetService.loadAssetTypes(jwtToken).stream().filter(arg_0 -> this.isNotIgnorableAssetType(arg_0)).collect(Collectors.toSet());
        log.info("Found asset types {}", (Object)assetTypes.size());
        mutableContent.setAssetTypes(assetTypes.size());
        ArrayList<BusinessEntity> businessEntities = new ArrayList<BusinessEntity>();
        for (String assetType : assetTypes) {
            Set assets = this.assetService.loadAssetByType(assetType, jwtToken);
            mutableContent.setAssetsDetected(mutableContent.getAssetsDetected() + assets.size());
            log.info("Load {} assets for type {}", (Object)assets.size(), (Object)assetType);
            if (!CollectionUtils.isNotEmpty((Collection)assets)) continue;
            ConcurrentHashMap<CallSite, BusinessEntityField> fields = new ConcurrentHashMap<CallSite, BusinessEntityField>();
            BusinessEntityField idField = this.buildField(assetType + " ID", FieldQueryType.ENTITY_ID, null, (Object)"");
            fields.put((CallSite)((Object)(idField.getName() + System.currentTimeMillis())), idField);
            BusinessEntityField nameField = this.buildField(assetType, FieldQueryType.ENTITY_NAME, null, (Object)"");
            fields.put((CallSite)((Object)(nameField.getName() + System.currentTimeMillis())), nameField);
            BusinessEntityField labelField = this.buildField(assetType + " Label", FieldQueryType.ENTITY_LABEL, null, (Object)"");
            fields.put((CallSite)((Object)(labelField.getName() + System.currentTimeMillis())), labelField);
            BusinessEntityField ownerField = this.buildField("Owner", FieldQueryType.OWNER, null, (Object)"");
            fields.put((CallSite)((Object)(ownerField.getName() + System.currentTimeMillis())), ownerField);
            ArrayList assetsToAnalyze = Lists.newArrayList((Iterable)assets);
            if (assets.size() >= discoverConfig.getMinItemToAnalyze()) {
                assetsToAnalyze = Lists.newArrayList();
                int analyzed = 0;
                for (Asset asset : assets) {
                    if (++analyzed % 100 >= discoverConfig.getAnalyzePercent()) continue;
                    assetsToAnalyze.add(asset);
                }
            }
            DonReactive.block((Mono)Flux.fromIterable((Iterable)assetsToAnalyze).flatMap(a -> this.fetchAssetFields(a, fields, jwtToken, user.getTenantId())).collectList());
            ArrayList entityFields = Lists.newArrayList(fields.values());
            this.resolveNameDuplicates((List)entityFields);
            BusinessEntity assetBE = BusinessEntity.builder().id(TimeStampUUIDGenerator.generateId()).tenantId(user.getTenantId()).name(assetType).description("").fields((List)entityFields).relations(new ArrayList()).query(new BusinessEntityQuery(BusinessEntityType.ASSET, assetType)).sharedWithCustomers(false).build();
            businessEntities.add(assetBE);
            mutableContent.setAssetsAnalyzed(mutableContent.getAssetsAnalyzed() + assets.size());
        }
        log.info("Finish asset schema loading");
        return businessEntities;
    }

    private List<BusinessEntity> fetchDeviceSchema(TaskExecutionProgressStepBuilder stepBuilder, DiscoverConfig discoverConfig, JwtSecurityUser user) {
        TopologyDiscoveryProgressContent mutableContent = (TopologyDiscoveryProgressContent)stepBuilder.getStepContent(TopologyDiscoveryProgressContent.class);
        mutableContent.setCurrentState("Discover devices");
        String jwtToken = this.authenticationService.getToken(user);
        Set deviceTypes = this.deviceService.loadDeviceTypes(jwtToken);
        log.info("Found device types {}", (Object)deviceTypes.size());
        mutableContent.setDeviceTypes(deviceTypes.size());
        ArrayList<BusinessEntity> businessEntities = new ArrayList<BusinessEntity>();
        for (String deviceType : deviceTypes) {
            Set devices = this.deviceService.loadDeviceByType(deviceType, jwtToken);
            mutableContent.setDevicesDetected(mutableContent.getDevicesDetected() + devices.size());
            log.info("Load {} devices for type {}", (Object)devices.size(), (Object)deviceType);
            if (!CollectionUtils.isNotEmpty((Collection)devices)) continue;
            ConcurrentHashMap<CallSite, BusinessEntityField> fields = new ConcurrentHashMap<CallSite, BusinessEntityField>();
            BusinessEntityField idField = this.buildField(deviceType + " ID", FieldQueryType.ENTITY_ID, null, (Object)"");
            fields.put((CallSite)((Object)(idField.getName() + System.currentTimeMillis())), idField);
            BusinessEntityField nameField = this.buildField(deviceType, FieldQueryType.ENTITY_NAME, null, (Object)"");
            fields.put((CallSite)((Object)(nameField.getName() + System.currentTimeMillis())), nameField);
            BusinessEntityField labelField = this.buildField(deviceType + " Label", FieldQueryType.ENTITY_LABEL, null, (Object)"");
            fields.put((CallSite)((Object)(labelField.getName() + System.currentTimeMillis())), labelField);
            BusinessEntityField ownerField = this.buildField("Owner", FieldQueryType.OWNER, null, (Object)"");
            fields.put((CallSite)((Object)(ownerField.getName() + System.currentTimeMillis())), ownerField);
            ArrayList devicesToAnalyze = Lists.newArrayList((Iterable)devices);
            if (devices.size() >= discoverConfig.getMinItemToAnalyze()) {
                devicesToAnalyze = Lists.newArrayList();
                int analyzed = 0;
                for (Device device : devices) {
                    if (++analyzed % 100 >= discoverConfig.getAnalyzePercent()) continue;
                    devicesToAnalyze.add(device);
                }
            }
            DonReactive.block((Mono)Flux.fromIterable((Iterable)devicesToAnalyze).flatMap(d -> this.fetchDeviceFields(d, fields, jwtToken, user.getTenantId())).collectList());
            ArrayList entityFields = Lists.newArrayList(fields.values());
            this.resolveNameDuplicates((List)entityFields);
            BusinessEntity deviceBE = BusinessEntity.builder().id(TimeStampUUIDGenerator.generateId()).tenantId(user.getTenantId()).name(deviceType).description("").fields((List)entityFields).relations(new ArrayList()).query(new BusinessEntityQuery(BusinessEntityType.DEVICE, deviceType)).sharedWithCustomers(false).build();
            businessEntities.add(deviceBE);
            mutableContent.setDevicesAnalyzed(mutableContent.getDevicesAnalyzed() + devices.size());
        }
        log.info("Finish device schema loading");
        return businessEntities;
    }

    private Flux<Long> fetchAssetFields(Asset asset, Map<String, BusinessEntityField> fields, String jwtToken, UUID tenantId) {
        return Flux.merge((Publisher[])new Publisher[]{this.fetchAttributeFields("SERVER_SCOPE", EntityType.ASSET, asset.getUuidId(), fields, jwtToken, tenantId), this.fetchTelemetryFields(BusinessEntityType.ASSET, asset.getUuidId(), fields, jwtToken, tenantId)}).doOnError(throwable -> log.error("Error fetching asset fields", throwable));
    }

    private Flux<Long> fetchDeviceFields(Device device, Map<String, BusinessEntityField> fields, String jwtToken, UUID tenantId) {
        return Flux.merge((Publisher[])new Publisher[]{this.fetchAttributeFields("CLIENT_SCOPE", EntityType.DEVICE, device.getUuidId(), fields, jwtToken, tenantId), this.fetchAttributeFields("SHARED_SCOPE", EntityType.DEVICE, device.getUuidId(), fields, jwtToken, tenantId), this.fetchAttributeFields("SERVER_SCOPE", EntityType.DEVICE, device.getUuidId(), fields, jwtToken, tenantId), this.fetchTelemetryFields(BusinessEntityType.DEVICE, device.getUuidId(), fields, jwtToken, tenantId)}).doOnError(throwable -> log.error("Error fetching device fields", throwable));
    }

    private Mono<Long> fetchAttributeFields(String scope, EntityType entityType, UUID id, Map<String, BusinessEntityField> fields, String jwtToken, UUID tenantId) {
        return this.apiClient.findAttributeKeys(null, scope, entityType.name(), id, jwtToken).map(Optional::get).map(keys -> keys.stream().filter(key -> {
            if (key == null) {
                log.warn("null key was detected for item {} for tenant {} for scope {}. Skipped.", new Object[]{id, tenantId, scope});
                return false;
            }
            String uniqueKey = key + "_" + scope + "_attr";
            return !fields.containsKey(uniqueKey);
        }).collect(Collectors.joining(","))).filter(keys -> !keys.isEmpty()).flatMapMany(key -> this.apiClient.loadAttribute(null, entityType.name(), id, scope, key, jwtToken)).map(attr -> this.buildField(attr.getKey(), FieldQueryType.ATTRIBUTE, scope, attr.getValue())).doOnNext(field -> fields.put(field.uniqKey(), (BusinessEntityField)field)).count();
    }

    private Mono<Long> fetchTelemetryFields(BusinessEntityType entityType, UUID id, Map<String, BusinessEntityField> fields, String jwtToken, UUID tenantId) {
        return this.apiClient.findTelemetryKeys(null, entityType.name(), id, jwtToken).map(Optional::get).map(keys -> keys.stream().filter(key -> {
            if (key == null) {
                log.warn("null key was detected for item {} for tenant {}. Skipped.", (Object)id, (Object)tenantId);
                return false;
            }
            String uniqueKey = key + "_ts_key";
            return !fields.containsKey(uniqueKey);
        }).collect(Collectors.joining(","))).filter(keys -> !keys.isEmpty()).flatMapMany(key -> this.apiClient.loadLatestTelemetry(null, entityType, id, key, jwtToken)).flatMapIterable(Map::entrySet).flatMapIterable(entry -> ((List)entry.getValue()).stream().filter(v -> v.getValue() != null).map(v -> Pair.of((Object)((String)entry.getKey()), (Object)v.getValue())).collect(Collectors.toList())).map(tuple -> this.buildField((String)tuple.getLeft(), FieldQueryType.TELEMETRY, null, tuple.getRight())).doOnNext(field -> fields.put(field.uniqKey(), (BusinessEntityField)field)).count();
    }

    private void resolveNameDuplicates(List<BusinessEntityField> entityFields) {
        Map nameDuplicatedFieldsMap = entityFields.stream().filter(field -> {
            if (field.getName() == null) {
                throw new TrendzException("Found null name for field %s, query = %s".formatted(field.getId(), field.getQuery()));
            }
            return true;
        }).collect(Collectors.groupingBy(BusinessEntityField::getName, Collectors.toList()));
        for (List fieldListByName : nameDuplicatedFieldsMap.values()) {
            if (fieldListByName.size() <= 1) continue;
            Map typeDuplicatedFieldMap = fieldListByName.stream().collect(Collectors.groupingBy(i -> i.getQuery().getQueryType(), Collectors.toList()));
            for (List fieldListByType : typeDuplicatedFieldMap.values()) {
                if (fieldListByName.size() <= 1) {
                    BusinessEntityField field2 = (BusinessEntityField)fieldListByName.iterator().next();
                    FieldQueryType queryType = field2.getQuery().getQueryType();
                    field2.setName(field2.getName() + "_" + queryType.name());
                    continue;
                }
                Map scopeDuplicatedFieldMap = fieldListByType.stream().collect(Collectors.groupingBy(i -> (String)ObjectUtils.firstNonNull((Object[])new String[]{i.getQuery().getScope(), ""}), Collectors.toList()));
                for (List fieldListByScope : scopeDuplicatedFieldMap.values()) {
                    if (fieldListByScope.size() <= 1) {
                        BusinessEntityField field3 = (BusinessEntityField)fieldListByScope.iterator().next();
                        FieldQueryType queryType = field3.getQuery().getQueryType();
                        String scope = (String)ObjectUtils.firstNonNull((Object[])new String[]{field3.getQuery().getScope(), ""});
                        field3.setName(field3.getName() + "_" + queryType.name() + (String)(scope.isEmpty() ? "" : "_" + scope));
                        continue;
                    }
                    throw new IllegalStateException("The business fields are absolutely same: " + Arrays.toString(fieldListByScope.stream().map(BusinessEntityField::getName).toArray()));
                }
            }
        }
    }

    private BusinessEntityField buildField(String key, FieldQueryType queryType, String scope, Object value) {
        FieldType fieldType = this.detectType(value.toString());
        return BusinessEntityField.builder().id(TimeStampUUIDGenerator.generateId()).businessEntityId(null).name(key).description("").hidden(false).type(fieldType).query(new BusinessEntityFieldQuery(queryType, key, scope)).calcFunction(null).build();
    }

    private FieldType detectType(String value) {
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            return FieldType.BOOLEAN;
        }
        if (NumberUtils.isParsable((String)value)) {
            try {
                Double.parseDouble(value);
            }
            catch (NumberFormatException ignored) {
                return FieldType.STRING;
            }
            return FieldType.NUMERIC;
        }
        return FieldType.STRING;
    }

    private boolean isNotIgnorableAssetType(String assetType) {
        return !Set.of("AlarmPropagationAsset", "TbServiceQueue").contains(assetType);
    }
}

