/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.trendz.service.topology;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.thingsboard.server.common.data.relation.EntityRelation;
import org.thingsboard.trendz.domain.definition.entity.BusinessEntity;
import org.thingsboard.trendz.domain.definition.entity.relation.Direction;
import org.thingsboard.trendz.domain.definition.entity.relation.Relation;
import org.thingsboard.trendz.domain.runtime.Item;
import org.thingsboard.trendz.security.entity.JwtSecurityUser;
import org.thingsboard.trendz.security.service.AuthenticationService;
import org.thingsboard.trendz.service.provider.TbItemService;
import org.thingsboard.trendz.service.provider.TbRestDataSource;
import org.thingsboard.trendz.service.task.TaskExecutionProgressDecorator;
import org.thingsboard.trendz.service.task.TaskExecutionProgressStepBuilder;
import org.thingsboard.trendz.service.task.progress_content.TopologyDiscoveryProgressContent;
import org.thingsboard.trendz.service.topology.DiscoverConfig;
import org.thingsboard.trendz.tools.DonReactive;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class TbRelationDiscovery {
    private static final Logger log = LoggerFactory.getLogger(TbRelationDiscovery.class);
    private final AuthenticationService authenticationService;
    private final TbRestDataSource apiClient;
    private final TbItemService itemService;

    @Autowired
    public TbRelationDiscovery(AuthenticationService authenticationService, TbRestDataSource apiClient, TbItemService itemService) {
        this.authenticationService = authenticationService;
        this.apiClient = apiClient;
        this.itemService = itemService;
    }

    @TaskExecutionProgressDecorator(name="Discovering actual topology relations")
    public void discoverRelations(TaskExecutionProgressStepBuilder stepBuilder, List<BusinessEntity> businessEntities, DiscoverConfig discoverConfig, JwtSecurityUser user) {
        TopologyDiscoveryProgressContent mutableContent = (TopologyDiscoveryProgressContent)stepBuilder.getStepContent(TopologyDiscoveryProgressContent.class);
        mutableContent.setCurrentState("Discover relations");
        String jwtToken = this.authenticationService.getToken(user);
        HashMap relationMap = new HashMap();
        HashMap entityIdToBusiness = new HashMap();
        for (BusinessEntity businessEntity : businessEntities) {
            List items = (List)DonReactive.block((Mono)this.itemService.loadItems(businessEntity, null, null, null, jwtToken).collectList());
            log.info("Loaded {} items for business entity {}", (Object)items.size(), (Object)businessEntity.getName());
            ArrayList itemsToAnalyze = Lists.newArrayList((Iterable)items);
            if (items.size() >= discoverConfig.getMinItemToAnalyze()) {
                itemsToAnalyze = Lists.newArrayList();
                int analyzed = 0;
                for (Item item2 : items) {
                    if (++analyzed % 100 >= discoverConfig.getAnalyzePercent()) continue;
                    itemsToAnalyze.add(item2);
                }
            }
            DonReactive.block((Mono)Flux.fromIterable((Iterable)itemsToAnalyze).flatMap(item -> this.apiClient.findRelations(item.getId(), businessEntity.getQuery().getEntityType().name(), jwtToken, null, Direction.FROM).collectList()).filter(l -> !l.isEmpty()).doOnNext(r -> relationMap.put(((EntityRelation)r.get(0)).getFrom().getId(), r)).collectList());
            items.forEach(en -> entityIdToBusiness.put(en.getId(), businessEntity));
            mutableContent.setRelationsDetected(mutableContent.getRelationsDetected() + items.size());
        }
        this.mapEntities(relationMap, entityIdToBusiness);
        businessEntities.forEach(arg_0 -> this.clearRedundantRelations(arg_0));
    }

    private void mapEntities(Map<UUID, List<EntityRelation>> relationMap, Map<UUID, BusinessEntity> entityToBusiness) {
        HashMap<UUID, Multimap> mappingEntityToType = new HashMap<UUID, Multimap>();
        HashMap<UUID, Multimap> mappingTypeToEntity = new HashMap<UUID, Multimap>();
        for (UUID entityId : entityToBusiness.keySet()) {
            if (!CollectionUtils.isNotEmpty((Collection)relationMap.get(entityId))) continue;
            for (EntityRelation relation : relationMap.get(entityId)) {
                if (!entityToBusiness.containsKey(relation.getTo().getId())) continue;
                Multimap toType = (Multimap)mappingEntityToType.get(entityId);
                if (toType == null) {
                    toType = HashMultimap.create();
                    mappingEntityToType.put(entityId, toType);
                }
                toType.put((Object)relation.getType(), (Object)entityToBusiness.get(relation.getTo().getId()));
                Multimap toEntity = (Multimap)mappingTypeToEntity.get(entityId);
                if (toEntity == null) {
                    toEntity = HashMultimap.create();
                    mappingTypeToEntity.put(entityId, toEntity);
                }
                toEntity.put((Object)entityToBusiness.get(relation.getTo().getId()), (Object)relation.getType());
            }
        }
        for (UUID businessEntityId : mappingEntityToType.keySet()) {
            BusinessEntity businessEntity = entityToBusiness.get(businessEntityId);
            for (String relationType : ((Multimap)mappingEntityToType.get(businessEntityId)).keySet()) {
                for (BusinessEntity toEntity : ((Multimap)mappingEntityToType.get(businessEntityId)).get((Object)relationType)) {
                    Relation relation = Relation.builder().name(relationType).enabled(true).relatedEntityId(toEntity.getId()).relationType(relationType).direction(Direction.FROM).build();
                    businessEntity.getRelations().add(relation);
                    toEntity.getRelations().add(relation.revert(businessEntity.getId()));
                }
            }
        }
    }

    private void clearRedundantRelations(BusinessEntity entity) {
        if (entity.getRelations() != null) {
            entity.setRelations((List)Lists.newArrayList((Iterable)Sets.newHashSet((Iterable)entity.getRelations())));
            log.info("Discovered {} relations for {} : [{}]", new Object[]{entity.getRelations().size(), entity.getName(), entity.getRelations()});
        } else {
            log.info("Discover process didnt find relations for {}", (Object)entity.getName());
        }
    }
}

